// FirLp.h: interface for the CFirLp class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FIRLP_H__72E63F01_6458_11D6_98FA_00045A5B13D3__INCLUDED_)
#define AFX_FIRLP_H__72E63F01_6458_11D6_98FA_00045A5B13D3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// Types of windowing
const int HAMMING = 0;
const int HANNING = 1;
const int BLACKMAN = 2;
const int RAISEDCOSINE = 3;// Same as Hanning
const int CUSTOMPARAMS = 4;// Supply your own 3 parameters

class CFirLp  
{
public:
////////////////////////////////////////////////////
// 'nSize' = Number of taps in filter
// 'dCutOff' = Cutoff freq of filter
////////////////////////////////////////////////////
	CFirLp::CFirLp(int nSize, double dCutOff);	// Default type to Hamming
////////////////////////////////////////////////////
// 'w' = Filter Type
////////////////////////////////////////////////////
	CFirLp::CFirLp(int nSize, double dCutOff, int w);
////////////////////////////////////////////////////
// 'dPrm1'  'dPrm2'  'dPrm3' are coefficients for windowing formula:
// E.g. Blackman: 0.5, 0.5, 0.08
// w(n) = dPrm1 + dPrm2 * cos(z) - dPrm2 * cos(2*z);
////////////////////////////////////////////////////
	CFirLp::CFirLp(int nSize, double dCutOff, double dPrm1, double dPrm2, double dPrm3);

	virtual ~CFirLp();
////////////////////////////////////////////////////
// 'dData' is new input to filter,
// Return: filtered output
////////////////////////////////////////////////////
	double Fir(double dData);
////////////////////////////////////////////////////
// Typical useage:
//	double* pd = new double[FIRSZE];
//	int nSze = firn.GetCoefficients(pd, FIRSZE);
//	delete pd;
	int GetCoefficients(double* pd, int nZ);
////////////////////////////////////////////////////

protected:
	Common(int nSize, double dCutOff, double dParam1, double dParam2, double dParam3);

	double* dpBase;		// Base address of allocated data array
	double* dpHiEnd;	// High end of array (used for wraparound check)
	double* dpHBase;	// Base address of coefficient array "H"
	int nY;				// Index into data array
	int nSze;			// Size of Fir filter 
	int nHalf;			// Rounded-down, half size
	int nBit0;			// Odd/Even bit
	int nHalf1;			// Handle nSize odd case.

};

#endif // !defined(AFX_FIRLP_H__72E63F01_6458_11D6_98FA_00045A5B13D3__INCLUDED_)
