/* VERZIA 20000204 */
  /*------------------------------------------------------------------*
          COMPORT.C
                subor subroutin potrebnych k ovladaniu serioveho portu
  *------------------------------------------------------------------*/

/*  Nasleduju potrebne HEADER FILES: /* */

#include <stdio.h>
#include <signal.h>
#if defined (DOS)
 #include <dos.h>
 #include <conio.h>
#endif

#include "defines.h"
#include "subrout.h"

#include "serial.h"

/* Dalsie, tu pouzite funkcie, su definovane v:
#include "linuxdos.c"

/* */

/* ---------------------Definicie common premennych--------------------- */
extern int port_vybrany;           /* vyber portu uzivatelom; ak = 0, pouzi default COM_PORT */
extern unsigned int com_portbase,  /* bazova adresa serioveho portu pre ovladanie jemnych pohybov, ftometra, etc. */
                    com_port_intr; /* systemovy interrupt od serioveho portu */
#if defined (DOS)
 extern void interrupt ( *oldhandler)(void);  /* prerusenie */
#endif


/* ###########Subroutine############
   Tato routina zisti ci je uz mozne pisat na port:
    Po N pokusoch nastane time-out.
        Ak mozno pisat, vrati 1,
           inak vracia 0

*/
int com_port_mozno_pisat_()

{
        int i=0, n=MAX_TRY_PORT;
           /* nenulove bity 01100000 znamenaju, ze nemozeme vysielat */
           do
            {
             if( (inportb(com_portbase+LSR) & 96) )
              return(1);
             else
              i++;
            }while( i < n ) ;

            return(0);

}
/* ######End Suboutine: com_port_mozno_pisat_ ###########*/


/* ###########Subroutine############
   Tato routina zisti ci je uz mozne pisat na port (kontroluje uz len LSR):
    Po N pokusoch nastane time-out.
        Ak mozno pisat, vrati 1,
           inak vracia 0

*/
int com_port_mozno_pisat_lsr_()

{
        int i=0, n=MAX_TRY_PORT;
           /* nenulove bity 01100000 znamenaju, ze nemozeme vysielat */
           do
            {
               if( (inportb(com_portbase+LSR) & 96) )
                 return(1);
               i++;
            }while( i < n ) ;

            return(0);

}
/* ######End Suboutine: com_port_mozno_pisat_lsr_ ###########*/


/* ###########Subroutine############
   Tato routina zisti ci je uz mozne citat z portu:
    Po N pokusoch nastane time-out.
        Ak mozno citat, vrati 1,
           inak vracia 0

*/
int com_port_mozno_citat_orig_()

{
        int i=0, n=MAX_TRY_PORT;
           /* nenulovy bit 00000001 znamena, ze nemozeme citat */
           do
            {
               if( (inportb(com_portbase+LSR) & 1) )
                 return(1);
               i++;
            }while( i < n ) ;

            return(0);

}
/* ######End Suboutine: com_port_mozno_citat_ ###########*/

int com_port_mozno_citat_()

{
        unsigned char i;
           /* nenulovy bit 00000001 znamena, ze nemozeme citat */
           do
            {
            }while( !(inportb(com_portbase+LSR) & 1) );
           return(1);

}
/* ######End Suboutine: com_port_mozno_citat_ ###########*/

/* ###########Subroutine############
   Tato vycita seriovy port a tym ho vycisti

*/
int com_port_cisti_()

{
        int   cnum;

     cnum = inportb(com_portbase + MCR) | DTR | RTS;
     #if defined (VIA_IFACE)
      /* GPS prijimac je pripojeny cez interface Vl.Kollara:
         je potrebne DTR v registri MCR nastavit na 0 ->
         to sposobi, ze Iface sa prepne do modu GPS z modu fotometra */
      cnum = cnum & 254 ;
     #endif
     outportb(com_portbase + MCR, cnum);
     cnum = inportb(com_portbase + LSR);
     cnum = inportb(com_portbase + MSR);
     cnum = inportb(com_portbase + RXR);
     cnum = inportb(com_portbase + IER);
     cnum = inportb(com_portbase + IIR);

     return(0);

}
/* ######End Suboutine: com_port_cisti_ ###########*/

/* ###########Subroutine############
   Tato routina "vypne" seriovy port
*/
void com_port_stop_()

{
   char c;
   int  port = COM_PORT;

   if(port_vybrany)
     port=port_vybrany;


/* Go off-line */
 /*   c = inportb(IMR);                     /* */
 /*   outportb(IMR, (c | 0x10));            /* chip 8259 */
 /*   outportb(com_portbase + IER, 0);      /* disable interrupt */
 /*   outportb(IMR, EOI);                   /* chip 8259 */
 /*   outportb(com_portbase + MCR, 0);      /* */

    /* reset the old interrupt handler */
#if defined (DOS)
    setvect(com_port_intr, oldhandler); /* */
#endif

#if defined (LINUX)
        /* zrusenie povolenia pristupu na porty */
        if (ioperm(com_portbase, 7, 0)) {perror("ioperm"); exit(1);}
#endif

         /*
         ansi_clearscreen_();
         ansi_gotoxy_(8, 10); /* */
         #if defined (SLOVAK)
          printf(" Vypol som seriovy port COM%d \n", port);
         #else
          printf(" The serial port COM%d was put off-line \n", port);
         #endif

       return;
}
/* ######End Suboutine: com_port_stop_ ###########*/


/* ###########Subroutine############
   Tato routina sa vola pri signaloch chyby behu programu:
    vypise varovanie a "vypne" seriovy port

*/
void abnormal_termination_(int sig, int type, int *reglist)

{
  ansi_clearscreen_();
  ansi_gotoxy_(8, 15);
  /* vypne port */
  com_port_stop_();

  /* vypis varovania */
  ansi_gotoxy_(10, 15);
  #if defined (SLOVAK)
    printf(" CHYBA: nekorektne ukoncenie programu! \n");
    ansi_gotoxy_(12, 12);
    printf(" Seriovy port (obsluha preruseni) vypnuty! \n");
  #else
    printf(" ERROR: abnormal program termination! \n");
    ansi_gotoxy_(12, 12);
    printf(" Serial port (interrupt handling) turned off! \n");
  #endif

  ansi_gotoxy_clear_(15, 5);
  printf("Sig: %d  Type: %d", sig, type);
  ansi_gotoxy_(15, 25);
  switch(sig)
  {
   case 0:
   {
     #if defined (SLOVAK)
      printf("Chyba vykonavania programu!");
     #else
      printf("Execution error!");
     #endif
     break;
   }
   case 1:
   {
     #if defined (SLOVAK)
      printf("CtrlBreak bolo stalacene!");
     #else
      printf("CtrlBreak was pressed!");
     #endif
     break;
   }
   case SIGABRT:
   {
     printf("SIGABRT signal");
     break;
   }
   case SIGFPE:
   {
     printf("SIGFPE signal: Floating point trap");
     break;
   }
   case SIGILL:
   {
     printf("SIGILL signal: Illegal instruction");
     break;
   }
   case SIGINT:
   {
     printf("SIGINT signal");
     break;
   }
   case SIGSEGV:
   {
     printf("SIGSEGV signal: Memory access violation");
     break;
   }
   case SIGTERM:
   {
     printf("SIGTERM signal");
     break;
   }
   default:
   {
     #if defined (SLOVAK)
      printf("NEZNAMY signal!");
     #else
      printf("UNKNOWN signal!");
     #endif
   }
  }

  /* ukonci program */
  exit(1);

  return;

}

/* ######End Suboutine: abnormal_termination_ ###########*/


/* ###########Subroutine############
   Tato routina inicializuje seriovy port:
        nastavi jeho rychlost, pocet bitov, stop bit, paritu...
   Zisti vektor prerusenia od OS a ulozi ho do oldhandler.
   Pri chybe vracia 1, ak OK, tak vrati 0

*/
int com_port_init_(void)

{

        int i=0, pom=1;

    /* Communications parameters */
        int        port     = COM_PORT;
        int        speed    = COM_PORT_SPEED;
        int        parity   = COM_PORT_PARITY;
        int        bits     = COM_PORT_BITS;
        int        stopbit  = COM_PORT_STOPBITS;
/*      long int   timeout  = COM_PORT_TIMEOUT; */   /* zatial nepouzite */

        int   offset;     /* zatial nepouzite */
        int   divisor;
        int   setting;
        int   irq;
        int   cnum;
        char  c;

        if(port_vybrany)
         port=port_vybrany;


/* ****Vypis*** */
    ansi_clearscreen_();
    ansi_gotoxy_(12, 10);
    #if defined (SLOVAK)
     printf(" Inicializujem seriovy port COM%d \n", port);
    #else
     printf(" The serial port COM%d is being initialized \n", port);
    #endif


/* ****Port**** */
    com_portbase = 0;                         /* Otherwise set com_portbase      */
    switch (port)
    { /* Sort out the base address */
      case COM1 : 
		  offset = 0x0000;
                  com_portbase = COM1BASE;
                  com_port_intr = PORTINTERRUPT13;
                  irq = IRQ4;
                  break;
      case COM2 :
		  offset = 0x0002;
                  com_portbase = COM2BASE;
                  com_port_intr = PORTINTERRUPT24;
                  irq = IRQ3;
                  break;
      case COM3 :
		  offset = 0x0004;
                  com_portbase = COM3BASE;
                  com_port_intr = PORTINTERRUPT13;
                  irq = IRQ4;
                  break;
      case COM4 :
		  offset = 0x0008;
                  com_portbase = COM4BASE;
                  com_port_intr = PORTINTERRUPT24;
                  irq = IRQ3;
                  break;
      default   :
		  offset = 0x0000;
                  com_portbase = COM1BASE;
                  com_port_intr = PORTINTERRUPT13;
                  irq = IRQ4;
    }


#if defined (LINUX)
        /* povolenie pristupu na porty */
        if (ioperm(com_portbase, 7, 1)) {perror("ioperm"); exit(1);}
#endif

/* ****Interrupt masking**** */
/*
    c = inportb(IMR);
    outportb(IMR, (c | 0x10));          /* chip 8259 */

/* ****Speed setting**** */
    divisor = (int) (115200L/speed);
    c = inportb(com_portbase + LCR);
    outportb(com_portbase + LCR, (c | 0x80));           /* Set DLAB */
    outportb(com_portbase + DLL, (divisor & 0x00FF));
    outportb(com_portbase + DLH, ((divisor >> 8) & 0x00FF));
    outportb(com_portbase + LCR, c);                    /* Reset DLAB */

/* ****Others:Parity, Bits, StopBit**** */
    setting  = bits-5;
    setting |= ((stopbit == 1) ? 0x00 : 0x04);
    setting |= parity;
    outportb(com_portbase + LCR, setting);

/* ****Enable interrupt**** */
#if defined (DOS)
    oldhandler = getvect(com_port_intr);               /* save the old interrupt vector */
#endif
/*  outportb(com_portbase + MCR, 0x0B); */
/*  outportb(com_portbase + IER, MC_INT); */

/* ****Port start**** */ /* VYCISTENIE PORTu */
     com_port_cisti_();

/* ****Interrupt unmasking**** */
/*  c = inportb(IMR);                                */
/*  outportb(IMR, (c & irq));           /* chip 8259 */
/*  outportb(ICR, EOI);                 /* chip 8259 */


/*
    if( (pom & 195) != 0 )
     {
      ansi_gotoxy_(12, 10);
      #if defined (SLOVAK)
       printf(" CHYBA pri inicializovani serioveho portu COM%d ! \n", port);
      #else
       printf(" The serial port COM%d initialization ERROR! \n", port);
      #endif
      delay(1500);
      ansi_gotoxy_clear_(12, 1);
      return(1);
     }
*/
    ansi_gotoxy_(12, 10);
    #if defined (SLOVAK)
     printf(" Uspesne som nicializoval seriovy port COM%d \n", port);
    #else
     printf(" The serial port COM%d was successfully initialized \n", port);
    #endif
    delay(500);
    ansi_gotoxy_clear_(12, 1);

    return(0);
}
/* ######End Suboutine: com_port_init_ ###########*/






