
/* VERZIA 19991122 */

/* ########################################################################
		*** funkcie pouzite z extenzii kompilatora BC ***
	kniznica:       |       funkcia:     |  vyriesene v:
	----------------|--------------------|--------------------
	conio.h         |       kbhit        |  linuxdos.c
			|       getch        |  linuxdos.c
	dos.h           |       delay        |  linuxdos.h
			|       outportb     |  linuxdos.h
			|       inportb      |  linuxdos.h
			|       pokeb        |
			|       peekb        |
			|       struct time  |  .
			|       settime      |  settimeofday: <sys/time.h> 
			|  ?    ctrlbrk      |
			|  ?    getvect      |
			|  ?    setvect      |
			|  ?    enable       |
			|  ?    disable      |
	signal.h        |  ?    signal       |
			|  ?    SIGABRT      |
			|  ?    SIGFPE       |
			|  ?    SIGILL       |
			|  ?    SIGSEGV      |
			|  ?    SIGTERM      |
	process.h       |       system       | nie je potrebne, na LINUXe
			|                    |  to tiez funguje, akurat,
			|                    |  samozrejme, su tu ine prikazy

*/

/* -------------------------------------------------
   --------------SPOLOCNA CAST ---------------------
   ------------------------------------------------- */

#include "linuxdos.h"

/* ###########Subroutine############
   Tato routina sluzi na flush STDIN
*/
void flush_input_(void)
{

                while (kbhit()) /* flush typahead buffer */
                    getch();

}
/* ######End Suboutine: flush_input_ ###########*/


#if defined (LINUX)
/* -------------------------------------------------
   --------------CAST PRE LINUX---------------------
   ------------------------------------------------- */

/* #define _POSIX_SOURCE  /* linux si toto zabezpeci sam */
 #include <termios.h>
 static struct termios __orig__, __new__;
 static int __peek__ = -1;

/* ###########Subroutine############
   Tato routina resetuje terminal v LINUXe (zaciatok).
    Je ju potrebne pouzit PRED pouzivani getch(), kbhit()
*/
void __keyboard_start__(void)
{
  tcgetattr(0, &__orig__);
  __new__ = __orig__;
  __new__.c_lflag &= ~ICANON;
  __new__.c_lflag &= ~ECHO;
  __new__.c_lflag &= ~ISIG;
  __new__.c_cc[VMIN] = 1;
  __new__.c_cc[VTIME] = 0;
  tcsetattr(0, TCSANOW, &__new__);
}
/* ######End Suboutine: __keyboard_start__ ###########*/


/* ###########Subroutine############
   Tato routina resetuje terminal v LINUXe (koniec).
    Je ju potrebne pouzit PO pouzivani getch(), kbhit()
*/
void __keyboard_stop__(void)
{
  tcsetattr(0,TCSANOW, &__orig__);
}
/* ######End Suboutine: __keyboard_stop__ ###########*/


/* ###########Subroutine############
   Tato routina sluzi na precitanie 1 klavesy zo STDIN bez cakania na ENTER.
    V BC pod MSDOS je priamo definovana, takze ju netreba definovat tu.
*/

int getch(void)
{

  char ch;

  if(__peek__ != -1) {
    ch = __peek__;
    __peek__ = -1;
    return ch;
  }

  read(0,&ch,1);
  return ch;
}
/* ######End Suboutine: getch ###########*/


/* ###########Subroutine############
   Tato routina na testovanie, ci bola na STDIN stalcena klavesa.
    V BC pod MSDOS je priamo definovana, takze ju netreba definovat tu.
*/
int kbhit(void)
{

  char ch;
  int nread;

  if(__peek__ != -1) return 1;
  __new__.c_cc[VMIN]=0;
  tcsetattr(0, TCSANOW, &__new__);
  nread = read(0,&ch,1);
  __new__.c_cc[VMIN]=1;
  tcsetattr(0, TCSANOW, &__new__);

  if(nread == 1) {
   __peek__ = ch;
   return 1;
  }

  return 0;
}
/* ######End Suboutine: kbhit ###########*/

#elif defined (DOS)
/* -------------------------------------------------
   --------------CAST PRE DOS-----------------------
   ------------------------------------------------- */

#endif


