/* VERZIA 19991203 */

/*
DOROBIT:
- Altitue Hold On (nastavit?)
- nastavovanie casu OS na necele casti sekund? ->
     urobene okrem volania routiny cas_nastavenie_ - argument stotiny
*/

/* ########################################################################
                *** funkcie pouzite z extenzii kompilatora BC ***
        kniznica:       |       funkcia:     |  vyriesene v:
        ----------------|--------------------|--------------------
        conio.h         |       kbhit        |  linuxdos.c
                        |       getch        |  linuxdos.c
        dos.h           |       delay        |  linuxdos.h
                        |       outportb     |  linuxdos.h
                        |       inportb      |  linuxdos.h
                        |       struct time  |
                        |       settime      |
        process.h       |       system       | nie je potrebne, na LINUXe
                        |                    |  to tiez funguje, akurat,
                        |                    |  samozrejme, su tu ine prikazy

*/

/* ########################################################################
                *** v programe su pouzite ANSI ESCAPE sekvencie ***

        preto je v DOSe mat v CONFIG.SYS napr.: device=c:\dos\ansi.sys

Esc[2J            #clears screen and sets cursor possition to 0,0
Esc[10;5H         #set cursor possition to 10th line and 5th column
Esc[10;8HEsc[K    #clears the line from the current cursor possition to the end of line
Esc[1mEsc 1 Esc[0mEsc   #emphasized text
Esc[5mEsc 5 Esc[0mEsc   #blinking text
Esc[7mEsc 7 Esc[0mEsc   #inverse text
ASCII7                  #bell

tu Esc znamena znak s dekadickou ASCII hodnotou = 27 = KEY_ESC (Escape)
tu ASCII7 znamena znak s dekadickou ASCII hodnotou = 7 = KEY_BELL (Bell)

tieto ESCAPE sekvencie sa pisu cez standardny prikaz printf na obrazovku napr:
        printf("%c[5m blinking text %c[0m", KEY_ESC, KEY_ESC);
*/

/* ---------------------Vlastne definicie------------------------------- */
#include "defines.h"

/* ---------------------Header files------------------------------------ */
#include <stdio.h>
#include <math.h>
#include <string.h>
#if defined (DOS)
 #include <dos.h>
#endif

/* ---------------------Header files------------------------------------ */
#include "subrout.h"
#include "serial.h"
#include "comport.h"
#include "cas.h"

/* ---------------------Definicie common premennych--------------------- */
FILE *oncorelog, *fopen();  /* logovaci file */
unsigned int com_portbase,  /* bazova adresa serioveho portu pre ovladanie jemnych pohybov, ftometra, etc. */
             com_port_intr; /* systemovy interrupt od serioveho portu */
#if defined (DOS)
 void interrupt ( *oldhandler)(void);  /* prerusenie */
#endif
unsigned char znakout[300];
unsigned char znakin[15];
int port_vybrany=0, logging=0;

/* */

/* ---------------------H L A V N Y    P R O G R A M-------------------- */
int main(void)

{

/* ########################################################################
                *** deklaracie subroutine(s) ***
*/

/* ########################################################################
                *** deklaracie premennych ***
*/
        int i=0;
        char key, pom[40];

         for(i=0; i<300; i++)
           znakout[i]=254;

        /* -----------  *** uvodny vypis *** ----------------------- */
         ansi_clearscreen_();
         ansi_gotoxy_clear_(20, 25);
         printf("G P S   O N C O R E   (GT/UT)\n");
         ansi_gotoxy_clear_(21, 24);
         printf("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n");
         ansi_gotoxy_clear_(22, 2);
         printf("Author: %s   Version: %s\n", AUTHOR, COMPILATION_DATE);

        /* -----------  *** vyber portu *** ------------------------ */
         ansi_gotoxy_clear_(4, 2);
         printf("Choose the COM port to which GPS receiver is connected to:\n");
         ansi_gotoxy_clear_(6, 5);
         printf("COM1: IO: 0x%X, interrupt: 0x%X, IRQ: 0x%X\n", COM1BASE, PORTINTERRUPT13, IRQ4);
         ansi_gotoxy_clear_(7, 5);
         printf("COM2: IO: 0x%X, interrupt: 0x%X, IRQ: 0x%X\n", COM2BASE, PORTINTERRUPT24, IRQ3);
         ansi_gotoxy_clear_(8, 5);
         printf("COM3: IO: 0x%X, interrupt: 0x%X, IRQ: 0x%X\n", COM3BASE, PORTINTERRUPT13, IRQ4);
         ansi_gotoxy_clear_(9, 5);
         printf("COM4: IO: 0x%X, interrupt: 0x%X, IRQ: 0x%X\n", COM4BASE, PORTINTERRUPT24, IRQ3);
         ansi_gotoxy_clear_(11, 5);
         printf("Default: COM%d\n", COM_PORT);

         do
          {
           do
            {
             ansi_gotoxy_clear_(13, 5);
             printf("Set the number of the port [1-4] => ");
             gets(pom);
            }while( !(port_vybrany=atoi(pom)) && (strlen(pom)!=0) );
          }while( (port_vybrany<0) || (port_vybrany>4) );

         do
          {
           ansi_gotoxy_clear_(14, 5);
           printf("Do you want logging (file oncore.log)? [y/N] => ");
           gets(pom);
          }while( (strlen(pom)>1) );
         if( (pom[0]==KEY_Y) || (pom[0]==KEY_y) )
          logging=1;

        /* -----------  *** inicializacia terminalu *** ------------ */
         #if defined (LINUX)
          __keyboard_start__();
         #endif

        /* -----------  *** inicializacia portu *** ---------------- */
         com_port_init_();  /* inicializuje port, nastavi vektor prerusenia */
         com_port_cisti_();
         delay(700);

        /* -----------  *** otvorenie log-file *** ----------------- */
        if(logging)
         oncorelog=fopen("oncore.log", "at");

        /* -----------  *** MENU *** ------------------------------- */
         ansi_clearscreen_();

         do
          {
           ansi_gotoxy_clear_(1, 30);
           printf("MAIN MENU\n");
           ansi_gotoxy_clear_(3, 2);
           printf("ESC = quit\n");
           ansi_gotoxy_clear_(3, 40);
           printf("R = receiver ID\n");
           ansi_gotoxy_clear_(4, 2);
           printf("T = self test\n");
           ansi_gotoxy_clear_(4, 40);
           printf("V = visible satellite\n");
           ansi_gotoxy_clear_(5, 2);
           printf("D = set to defaults\n");
           ansi_gotoxy_clear_(5, 40);
           printf("P = position/status/data\n");
           ansi_gotoxy_clear_(6, 2);
           printf("I = initial parameters settings\n");
           ansi_gotoxy_clear_(6, 40);
           printf("L = leap second pending status\n");
           ansi_gotoxy_clear_(7, 2);
           printf("O = Oncore vs. operating system: date/time\n");

           flush_input_();
           key=getch();

           switch(key)
            {
             case KEY_R:
             case KEY_r:
              {
               GPS_Oncore_receiverID_();
               ansi_clearscreen_();
               break;
              }
             case KEY_T:
             case KEY_t:
              {
               GPS_Oncore_self_test_();
               ansi_clearscreen_();
               break;
              }
             case KEY_V:
             case KEY_v:
              {
               GPS_Oncore_visible_satellite_();
               ansi_clearscreen_();
               break;
              }
             case KEY_D:
             case KEY_d:
              {
               GPS_Oncore_set_to_defaults_();
               ansi_clearscreen_();
               break;
              }
             case KEY_P:
             case KEY_p:
              {
               GPS_Oncore_position_status_data_();
               ansi_clearscreen_();
               break;
              }
             case KEY_I:
             case KEY_i:
              {
               GPS_Oncore_initial_parameters_();
               ansi_clearscreen_();
               break;
              }
             case KEY_L:
             case KEY_l:
              {
               GPS_Oncore_leap_second_();
               ansi_clearscreen_();
               break;
              }
             case KEY_O:
             case KEY_o:
              {
               GPS_Oncore_OS_date_time_();
               ansi_clearscreen_();
               break;
              }
             default:
              {
               break;
              }
            }

          }while(key!=KEY_ESC);

        /* -----------  *** zatvorenie log-file *** ---------------- */
        if(logging)
         fclose(oncorelog);

       /* -----------  *** osetrenie portu *** -------------------- */
         ansi_gotoxy_(15, 15);
         com_port_stop_();
         delay(700);

        /* -----------  *** osetrenie terminalu *** ---------------- */
         #if defined (LINUX)
          __keyboard_stop__();
         #endif

       /* -----------  *** zaverecny vypis *** -------------------- */
         ansi_clearscreen_();
         ansi_gotoxy_(15, 20);
         printf("... this is the end,\n");
         ansi_gotoxy_(16, 20);
         printf("    my only friend the end...\n");
         ansi_gotoxy_(23, 1);
         delay(700);

        return(0);
}

/* ###########Subroutine############
   Posle na port v Motorola formate N-byte-ov, ulozenych v poli znakin[],
    zrata checksum.

   Pri uspechu vracia 0, inak 1.
*/
int Mototrola_to_port_(int N)

{

       unsigned char znakcheck=0;
       int i=0;

       znakcheck = ( znakin[2] ^ znakin[3] );
       if(N>7)
        {
         for(i=4; i<(N-3); i++)
          znakcheck = ( znakcheck ^ znakin[i] );
        }

       znakin[0]     = 64;         /* @ */
       znakin[1]     = 64;         /* @ */
       znakin[(N-3)] = znakcheck;  /* checksum */
       znakin[(N-2)] = 13;         /* <CR> */
       znakin[(N-1)] = 10;         /* <LF> */

       for(i=0; i<N; i++)
        {
         if( com_port_mozno_pisat_() )
          outportb(com_portbase + TXR, znakin[i]);
        }

       return(0);

}
/* ######End Subroutine: Mototrola_to_port_ ###########*/

/* ###########Subroutine############
   Prijme z portu v Motorola formate N-byte-ov, zrata checksum,
    ulozi ich do pola znakout[].

   Pri uspechu vracia 0, inak 1.
*/
int Mototrola_from_port_(int N)

{
       unsigned char znakcheck=0;
       int i=0;

/* #############SKUSKA################# */
/* *
for(i=0; i<N; i++)
 znakout[i]=random(11)+40+i%40;
return(0);
/* #############SKUSKA################# */

       for(i=0; i<N; i++)
        {
         if( com_port_mozno_citat_() )
           znakout[i]=inportb(com_portbase + RXR);
        }

       znakcheck = ( znakout[2] ^ znakout[3] );
       if(N>7)
        {
         for(i=4; i<(N-3); i++)
          znakcheck = ( znakcheck ^ znakout[i] );
        }

       if( (znakout[0]!=64) || (znakout[1]!=64) ||
           (znakout[2]!=znakin[2]) || (znakout[3]!=znakin[3]) ||
           (znakout[(N-2)]!=13) || (znakout[(N-1)]!=10) ||
           (znakout[(N-3)]!=znakcheck) )
        return(1);    /* nastala niekde chyba */

       return(0);

}
/* ######End Subroutine: Mototrola_from_port_ ###########*/

/* ###########Subroutine############
   Vypise info o prijimaci: Receiver ID
    manual: str. 6.41
     INPUT: 7 Bytes: @@Cj<checksum><CR><LF>
     OUTPUT: 294 Bytes

   Pri uspechu vracia 0, inak 1.
*/
int GPS_Oncore_receiverID_(void)

{
       char key;
       int i;

       ansi_clearscreen_();
       ansi_gotoxy_clear_(1, 30);
       printf("RECEIVER ID\n");
       ansi_gotoxy_clear_(2, 15);
       printf("press ESC to quit, any other key to redisplay\n");

       do
        {
         znakin[2]=KEY_C;  /* C */
         znakin[3]=KEY_j;  /* j */
         if(Mototrola_to_port_(7))
          return(1);

         if(Mototrola_from_port_(294))
          {
           ansi_gotoxy_clear_(4, 1);
           printf("ERROR in data read\n");
          }
         else
          {
           ansi_gotoxy_clear_(4, 1);
           for(i=5; i<291; i++)
            putc(znakout[i], stdout);
          }

         flush_input_();
         key=getch();
        }while(key!=KEY_ESC);

       return(0);

}
/* ######End Subroutine: GPS_Oncore_receiverID_ ###########*/

/* ###########Subroutine############
   Spusti self test a vysledky napise
    manual: str. 6.42
     INPUT: 7 Bytes: @@Fa<checksum><CR><LF>
     OUTPUT: 9 Bytes

   Pri uspechu vracia 0, inak 1.
*/
int GPS_Oncore_self_test_(void)

{
       char key;
       int i;
       unsigned char byte1, byte2;

       ansi_clearscreen_();
       ansi_gotoxy_clear_(1, 30);
       printf("Self Test\n");
       ansi_gotoxy_clear_(2, 15);
       printf("press ESC to quit, any other key to run again\n");

       do
        {
         znakin[2]=KEY_F;  /* F */
         znakin[3]=KEY_a;  /* a */
         if(Mototrola_to_port_(7))
          return(1);

         if(Mototrola_from_port_(9))
          {
           ansi_gotoxy_clear_(4, 1);
           printf("ERROR in data read\n");
          }
         else
          {
           byte1=znakout[4];
           byte2=znakout[5];
           ansi_gotoxy_clear_(4, 1);
           if( (byte1 & 128) )
             printf("FAILED: antenna undercurrent \n");
           if( (byte1 & 64) )
             printf("FAILED: antenna overcurrent \n");
           if( (byte1 & 32) )
             printf("FAILED: RTC comm & time \n");
           if( (byte1 & 16) )
             printf("FAILED: temperature sensor \n");
           if( (byte1 & 8) )
             printf("FAILED: spare \n");
           if( (byte1 & 4) )
             printf("FAILED: RAM \n");
           if( (byte1 & 2) )
             printf("FAILED: ROM \n");
           if( (byte1 & 1) )
             printf("FAILED: 1 KHz presence \n");
           if( (byte2 & 128) )
             printf("FAILED: channel 8 correlation test \n");
           if( (byte2 & 64) )
             printf("FAILED: channel 7 correlation test \n");
           if( (byte2 & 32) )
             printf("FAILED: channel 6 correlation test \n");
           if( (byte2 & 16) )
             printf("FAILED: channel 5 correlation test \n");
           if( (byte2 & 8) )
             printf("FAILED: channel 4 correlation test \n");
           if( (byte2 & 4) )
             printf("FAILED: channel 3 correlation test \n");
           if( (byte2 & 2) )
             printf("FAILED: channel 2 correlation test \n");
           if( (byte2 & 1) )
             printf("FAILED: channel 1 correlation test \n");
           if( (!(byte1 & 128)) && (!(byte1 & 64))   )
             printf("antenna properly connected \n");
           if( (!(byte1 & 128)) && ((byte1 & 64))    )
             printf("antenna short \n");
           if( ((byte1 & 128))  && (!(byte1 & 64))   )
             printf("antenna open (not connected) \n");
           if( ((byte1 & 128))  && ((byte1 & 64))    )
             printf("antenna short \n");
           if( (byte1==0) && (byte2==0) )
             printf("Everything is OK \n");
          }

         flush_input_();
         key=getch();
        }while(key!=KEY_ESC);

       return(0);

}
/* ######End Subroutine: GPS_Oncore_self_test_ ###########*/

/* ###########Subroutine############
   Zisti viditelne satelity a vysledky zobrazi
    manual: str. 6.25
     INPUT: 8 Bytes: @@Bb<m><checksum><CR><LF>
            <m> - mod = 0 ... 1x
     OUTPUT: 92 Bytes

   Pri uspechu vracia 0, inak 1.
*/
int GPS_Oncore_visible_satellite_(void)

{
       char key;
       int i;
       int sat_no, sat_id, sat_doppler, sat_elev, sat_azim, sat_health;

       ansi_clearscreen_();

       do
        {

         ansi_gotoxy_clear_(1, 20);
         printf("Visible Satellite Status Message\n");
         ansi_gotoxy_clear_(2, 25);
         printf("press ESC to quit\n");

         znakin[2]=KEY_B;  /* B */
         znakin[3]=KEY_b;  /* b */
         znakin[4]=0;      /* 0-binarne */
         if(Mototrola_to_port_(8))
          return(1);

         if(Mototrola_from_port_(92))
          {
           ansi_gotoxy_clear_(4, 1);
           printf("ERROR in data read\n");
          }
         else
          {
           ansi_gotoxy_clear_(4, 1);
           sat_no=znakout[4];
           printf("Number of visible satelites: %d\n", sat_no);
           ansi_gotoxy_clear_(5, 1);
           printf(" ID  Doppler  Elev  Azimuth  Status\n");
/* #############SKUSKA################# */
/* *
sat_no=sat_no%12;
/* #############SKUSKA################# */
           for(i=0; i<12; i++)
             ansi_gotoxy_clear_((6+i), 1);
           for(i=0; i<sat_no; i++)
            {
             sat_id=znakout[(5+i*7)];
             sat_doppler=znakout[(6+i*7)];
             sat_doppler=(sat_doppler << 8);
             sat_doppler=sat_doppler+znakout[(7+i*7)];
             sat_elev=znakout[(8+i*7)];
             sat_azim=znakout[(9+i*7)];
             sat_azim=(sat_azim << 8);
             sat_azim=sat_azim+znakout[(10+i*7)];
             sat_health=znakout[(11+i*7)];
             ansi_gotoxy_clear_((6+i), 1);
             printf(" %2d    %5d    %2d    %3d", sat_id, sat_doppler, sat_elev, sat_azim);
             ansi_gotoxy_clear_((6+i), 30);
             if(sat_health==0)
              printf("healthy & not removed\n");
             if(sat_health==1)
              printf("healthy & removed\n");
             if(sat_health==2)
              printf("unhealthy & not removed\n");
             if(sat_health==3)
              printf("unhealthy & removed\n");
             if( (sat_health>3) || (sat_health<0) )
              printf("??? UNKNOWN health CODE = %d\n", sat_health);
            }
          }

         delay(DELAY_TIME);
         if( kbhit() )
          {
           key=getch();
           flush_input_();
          }

        }while(key!=KEY_ESC);

       return(0);

}
/* ######End Subroutine: GPS_Oncore_visible_satellite_ ###########*/

/* ###########Subroutine############
   Nastavi default hodnoty prijimaca
    manual: str. 6.44
     INPUT: 7 Bytes: @@Cf<checksum><CR><LF>
     OUTPUT: 7 Bytes

   Pri uspechu vracia 0, inak 1.
*/
int GPS_Oncore_set_to_defaults_(void)

{
       char key;
       int i;

       ansi_clearscreen_();
       ansi_gotoxy_clear_(1, 30);
       printf("Self To Defaults\n");
       ansi_gotoxy_clear_(2, 15);
       printf("press ESC to quit, any other key to run again\n");

       ansi_gotoxy_clear_(5, 10);
       printf("A R E   Y O U   R E A L L Y   S U R E   ?\n");

       ansi_gotoxy_clear_(7, 1);
       printf("This will erase date/time and position stored from previous meassurements.\n");
       ansi_gotoxy_clear_(8, 1);
       printf("The computation of new values can take up to several hours...\n");
       ansi_gotoxy_clear_(10, 15);
       printf("To continue press ENTER, to quit press any other key.\n");

       flush_input_();
       key=getch();
       if( key == KEY_ENTER)
        {
         ansi_gotoxy_clear_(5, 1);
         ansi_gotoxy_clear_(7, 1);
         ansi_gotoxy_clear_(8, 1);
         ansi_gotoxy_clear_(10, 1);

         do
          {
           znakin[2]=KEY_C;  /* C */
           znakin[3]=KEY_f;  /* f */
           if(Mototrola_to_port_(7))
            return(1);

           if(Mototrola_from_port_(9))
            {
             ansi_gotoxy_clear_(4, 1);
             printf("ERROR in data read\n");
            }
           else
            {
             ansi_gotoxy_clear_(4, 1);
             printf("Everything is OK \n");
             ansi_gotoxy_clear_(5, 2);
             printf("Default values set \n");
            }

           flush_input_();
           key=getch();
          }while(key!=KEY_ESC);

        }

       return(0);

}
/* ######End Subroutine: GPS_Oncore_set_to_defaults_ ###########*/

/* ###########Subroutine############
   Zisti udaje poskytovane prijimacom (datum, cas, poloha, etc.) a zobrazi ich
    manual: str. 6.19
     INPUT: 8 Bytes: @@Ea<m><checksum><CR><LF>
            <m> - mod = 0 ... 1x
     OUTPUT: 76 Bytes

   Pri uspechu vracia 0, inak 1.
*/
int GPS_Oncore_position_status_data_(void)

{
       char key;
       int i;
       int month, day, year, hour, minute, second, velocity, heading;
       long frac_sec, latitude, longitude, height;
       float pom, pomsec;
       int pomdeg, pommin, znamienko;
       float fsec, flatitude, flongitude, fheight, fvelocity, fheading;
       float fdop;
       int dop, dop_type, sat_no, sat_no_track;
       int sat_id, chan_track_mode, chan_noise, chan_status;
       int rec_status;

       ansi_clearscreen_();

       do
        {
         znakin[2]=KEY_E;  /* E */
         znakin[3]=KEY_a;  /* a */
         znakin[4]=0;      /* 0-binarne */
         if(Mototrola_to_port_(8))
          return(1);

         if(Mototrola_from_port_(76))
          {
           ansi_gotoxy_clear_(4, 1);
           printf("ERROR in data read\n");
          }
         else
          {
           ansi_gotoxy_clear_(1, 20);
           printf("Position/Status/Data Message\n");
           ansi_gotoxy_clear_(2, 10);
           printf("press ESC to quit, C for Channel Status CODE Help\n");

           month=znakout[4];
           day=znakout[5];
           year=znakout[6];
           year=(year << 8);
           year=year+znakout[7];
           ansi_gotoxy_clear_(4, 1);
           printf("Date (dd/mm/year): %2d/%2d/%4d\n", day, month, year);
           hour=znakout[8];
           minute=znakout[9];
           second=znakout[10];
           frac_sec=znakout[11];
           frac_sec=(frac_sec << 8);
           frac_sec=frac_sec+znakout[12];
           frac_sec=(frac_sec << 8);
           frac_sec=frac_sec+znakout[13];
           frac_sec=(frac_sec << 8);
           frac_sec=frac_sec+znakout[14];
           fsec=(float)second+frac_sec/1000000000.;
           ansi_gotoxy_clear_(4, 40);
           printf("Time UTC (hh:mm:sec): %2d:%2d:%08.5f\n", hour, minute, fsec);
           latitude=znakout[15];
           latitude=(latitude << 8);
           latitude=latitude+znakout[16];
           latitude=(latitude << 8);
           latitude=latitude+znakout[17];
           latitude=(latitude << 8);
           latitude=latitude+znakout[18];
           flatitude=(float)latitude/3600000.;
           pom=flatitude;
           znamienko=0;
           if(pom<0)
            znamienko=1;
           pom=fabs(pom);
           pomdeg=floor(pom);
           pommin=floor((pom-(float)pomdeg)*60.);
           pomsec=(pom-(float)pomdeg-((float)pommin)/60.)*3600.;
           ansi_gotoxy_clear_(5, 1);
           if(znamienko)
            printf("Latitude:  %14.10f deg = %3d deg %2d arcmin %8.4f arcsec SOUTH\n", flatitude, pomdeg, pommin, pomsec);
           else
            printf("Latitude:  %14.10f deg = %3d deg %2d arcmin %8.4f arcsec NORTH\n", flatitude, pomdeg, pommin, pomsec);
           longitude=znakout[19];
           longitude=(longitude << 8);
           longitude=longitude+znakout[20];
           longitude=(longitude << 8);
           longitude=longitude+znakout[21];
           longitude=(longitude << 8);
           longitude=longitude+znakout[22];
           flongitude=(float)longitude/3600000.;
           pom=flongitude;
           znamienko=0;
           if(pom<0)
            znamienko=1;
           pom=fabs(pom);
           pomdeg=floor(pom);
           pommin=floor((pom-(float)pomdeg)*60.);
           pomsec=(pom-(float)pomdeg-((float)pommin)/60.)*3600.;
           ansi_gotoxy_clear_(6, 1);
           if(znamienko)
            printf("Longitude: %14.10f deg = %3d deg %2d arcmin %8.4f arcsec WEST\n", flongitude, pomdeg, pommin, pomsec);
           else
            printf("Longitude: %14.10f deg = %3d deg %2d arcmin %8.4f arcsec EAST\n", flongitude, pomdeg, pommin, pomsec);
           height=znakout[23];
           height=(height << 8);
           height=height+znakout[24];
           height=(height << 8);
           height=height+znakout[25];
           height=(height << 8);
           height=height+znakout[26];
           fheight=(float)height/100.;
           ansi_gotoxy_clear_(7, 1);
           printf("Height above GPS reference ellipsoid (WGS84): %10.3f meters\n", fheight);
           velocity=znakout[31];
           velocity=(velocity << 8);
           velocity=velocity+znakout[32];
           fvelocity=(float)velocity/100.;
           ansi_gotoxy_clear_(8, 1);
           printf("Velocity: %10.3f m/s\n", fvelocity);
           heading=znakout[33];
           heading=(heading << 8);
           heading=heading+znakout[34];
           fheading=(float)heading/10.;
           ansi_gotoxy_clear_(8, 40);
           printf("Heading: %10.3f deg\n", fheading);

           dop=znakout[35];
           dop=(dop << 8);
           dop=dop+znakout[36];
           fdop=(float)dop/10.;
           ansi_gotoxy_clear_(9, 1);
           printf("GEOMETRY:\n");
           ansi_gotoxy_clear_(10, 1);
           printf("current DOP: %5.1f (0 = non computable, position-hold or position propagate)\n", fdop);
           dop_type=znakout[37];
           ansi_gotoxy_clear_(11, 1);
           printf("DOP type:");
           if( (dop_type & 128) )
            printf(" antenna undercurrent,");
           if( (dop_type & 64) )
            printf(" antenna overcurrent,");
           if( (dop_type & 32) )
            printf(" automatic survey mode,");
           if( (dop_type & 1) )
            printf(" HDOP (2D)");
           else
            printf(" PDOP (3D)");
           printf("\n");

           sat_no=znakout[38];
           sat_no_track=znakout[39];
           ansi_gotoxy_clear_(13, 1);
           printf("Number of visible satellites: %2d\n", sat_no);
           ansi_gotoxy_clear_(13, 40);
           printf("Number of satellites tracked: %2d\n", sat_no_track);
           ansi_gotoxy_clear_(14, 1);
           printf("Channel  Sat_ID  C/No  Tracking mode             Channel status (CODE)\n");
           for(i=0; i<8; i++)
            {
             sat_id=znakout[(40+i*4)];
             chan_track_mode=znakout[(41+i*4)];
             chan_noise=znakout[(42+i*4)];
             chan_status=znakout[(43+i*4)];
             ansi_gotoxy_clear_((15+i), 1);
             printf("     %2d      %2d   %3d \n", (i+1), sat_id, chan_noise);
             ansi_gotoxy_clear_((15+i), 24);
             if( chan_track_mode == 0 )
              printf("code search\n");
             if( chan_track_mode == 1 )
              printf("code acquire\n");
             if( chan_track_mode == 2 )
              printf("AGC set\n");
             if( chan_track_mode == 3 )
              printf("preq acquire\n");
             if( chan_track_mode == 4 )
              printf("bit sync detect\n");
             if( chan_track_mode == 5 )
              printf("message sync detect\n");
             if( chan_track_mode == 6 )
              printf("satellite time available\n");
             if( chan_track_mode == 7 )
              printf("ephemeris acquire\n");
             if( chan_track_mode == 8 )
              printf("available for position\n");
             ansi_gotoxy_clear_((15+i), 50);
             if( chan_status & 128 )
              printf("7 ");
             if( chan_status & 64 )
              printf("6 ");
             if( chan_status & 32 )
              printf("5 ");
             if( chan_status & 16 )
              printf("4 ");
             if( chan_status & 8 )
              printf("3 ");
             if( chan_status & 4 )
              printf("2 ");
             if( chan_status & 2 )
              printf("1 ");
             if( chan_status & 1 )
              printf("0 ");

            }
           rec_status=znakout[72];
           ansi_gotoxy_clear_(24, 1);
           ansi_gotoxy_clear_(23, 1);
           printf("Receiver status flag:");
           if( rec_status & 128 )
            printf(" position propagate mode,");
           if( rec_status & 64 )
            printf(" poor geometry (DOP>12),");
           if( rec_status & 32 )
            printf(" 3D fix,");
           if( rec_status & 16 )
            printf(" 2D fix,");
           if( rec_status & 8 )
            printf(" acquiring satellites/position hold,");
           if( rec_status & 4 )
            printf(" differentail fix,");
           if( rec_status & 2 )
            printf(" insufficient visible satellites (<3),");
           if( rec_status & 1 )
            printf(" bad almanac,");
          }

         if(logging)
          {
           fprintf(oncorelog, " %2d/%2d/%4d", day, month, year);
           fprintf(oncorelog, " %2d:%2d:%08.5f", hour, minute, fsec);
           fprintf(oncorelog, " Vis: %2d", sat_no);
           fprintf(oncorelog, " Tracked: %2d\n", sat_no_track);
          }

         delay(DELAY_TIME);
         if( kbhit() )
          {
           key=getch();
           flush_input_();
          }

         if( (key==KEY_C) || (key==KEY_c))
          {
           ansi_clearscreen_();
           ansi_gotoxy_clear_(1, 20);
           printf("Channel Status CODE Help\n");
           ansi_gotoxy_clear_(2, 21);
           printf("press ANY KEY to quit\n");
           ansi_gotoxy_clear_(4, 10);
           printf("CODE    MEANING\n");
           ansi_gotoxy_clear_(5, 10);
           printf("  7     using for position fix\n");
           ansi_gotoxy_clear_(6, 10);
           printf("  6     satellite momentum alert flag\n");
           ansi_gotoxy_clear_(7, 10);
           printf("  5     satellite anti-spoof flag set\n");
           ansi_gotoxy_clear_(8, 10);
           printf("  4     satellite reported unhealthy\n");
           ansi_gotoxy_clear_(9, 10);
           printf("  3     satellite reported inaccurate ( > 16m )\n");
           ansi_gotoxy_clear_(10, 10);
           printf("  2     spare\n");
           ansi_gotoxy_clear_(11, 10);
           printf("  1     using for time solution\n");
           ansi_gotoxy_clear_(12, 10);
           printf("  0     parity error\n");

           flush_input_();
           key=getch();
           ansi_clearscreen_();
           key=0;
          }

        }while(key!=KEY_ESC);

       return(0);

}
/* ######End Subroutine: GPS_Oncore_position_status_data_ ###########*/

/* ###########Subroutine############
   Nastavi pociatocne hoddnoty GMT offset = 0 a Time mode = UTC
    manual: str. 6.5  (GMT offset)
     INPUT: 10 Bytes: @@Ab<s><h><m><checksum><CR><LF>
                           s=0, h=0, m=0
     OUTPUT: 10 Bytes
    manual: str. 6.7  (Time mode)
     INPUT: 8 Bytes: @@Aw<m><checksum><CR><LF>
                          m=1 ... UTC
     OUTPUT: 8 Bytes

   Pri uspechu vracia 0, inak 1.
*/
int GPS_Oncore_initial_parameters_(void)

{
       char key;
       int i;

       ansi_clearscreen_();
       ansi_gotoxy_clear_(1, 30);
       printf("Initial Parameters Setting\n");
       ansi_gotoxy_clear_(2, 15);
       printf("press ESC to quit, any other key to run again\n");

       do
        {
         /* GMT offset */
         znakin[2]=KEY_A;  /* A */
         znakin[3]=KEY_b;  /* b */
         znakin[4]=0;      /* 0-binarne */
         znakin[5]=0;      /* 0-binarne */
         znakin[6]=0;      /* 0-binarne */
         if(Mototrola_to_port_(10))
          return(1);

         if(Mototrola_from_port_(10))
          {
           ansi_gotoxy_clear_(4, 1);
           printf("ERROR in data read\n");
          }
         else
          {
           ansi_gotoxy_clear_(4, 1);
           if( znakout[4]==0 && znakout[5]==0 && znakout[6]==0 )
            printf("GMT offset set to +00:00 (GMT time will be given): OK \n");
           else
            printf("Problems in GMT offset setting! The response was: %d %d %d\n", znakout[4], znakout[5], znakout[6]);
          }

         /* Time mode */
         znakin[2]=KEY_A;  /* A */
         znakin[3]=KEY_w;  /* w */
         znakin[4]=1;      /* 1-binarne */
         if(Mototrola_to_port_(8))
          return(1);

         if(Mototrola_from_port_(8))
          {
           ansi_gotoxy_clear_(6, 1);
           printf("ERROR in data read\n");
          }
         else
          {
           ansi_gotoxy_clear_(6, 1);
           if( znakout[4]==1 )
            printf("Time mode set UTC: OK \n");
           else
            printf("Problems in Time mode setting! The response was: %d\n", znakout[4]);
          }

         flush_input_();
         key=getch();
        }while(key!=KEY_ESC);

       return(0);

}
/* ######End Subroutine: GPS_Oncore_initial_parameters_ ###########*/

/* ###########Subroutine############
   Vypise informaciu o stave "leap second"
    manual: str. 6.27
     INPUT: 8 Bytes: @@Bj<m><checksum><CR><LF>
                          m...odpoved 1x
     OUTPUT: 8 Bytes

   Pri uspechu vracia 0, inak 1.
*/
int GPS_Oncore_leap_second_(void)

{
       char key;
       int i;

       ansi_clearscreen_();
       ansi_gotoxy_clear_(1, 30);
       printf("Leap Second Pending Status\n");
       ansi_gotoxy_clear_(2, 15);
       printf("press ESC to quit, any other key to run again\n");

       do
        {
         /* GMT offset */
         znakin[2]=KEY_B;  /* B */
         znakin[3]=KEY_j;  /* j */
         znakin[4]=0;      /* 0-binarne */
         if(Mototrola_to_port_(8))
          return(1);

         if(Mototrola_from_port_(8))
          {
           ansi_gotoxy_clear_(4, 1);
           printf("ERROR in data read\n");
          }
         else
          {
           ansi_gotoxy_clear_(4, 1);
           if( znakout[4]==0 )
            printf("No leap second pending\n");
           if( znakout[4]==1 )
            printf("Addition of one second pending\n");
           if( znakout[4]==2 )
            printf("Subtraction of one second pending\n");
           if( znakout[4]>2 )
            printf("Unknown response!\n");
          }

         flush_input_();
         key=getch();
        }while(key!=KEY_ESC);

       return(0);

}
/* ######End Subroutine: GPS_Oncore_leap_second_ ###########*/

/* ###########Subroutine############
   Vypise aktualny cas podla Oncore a podla OS
    a ponukne moznost prestavit cas OS podla Oncore
    manual: str. 6.9 : DATUM
     INPUT: 11 Bytes: @@Ac<x><x><x><x><checksum><CR><LF>
                          x=255 (posli datum)
     OUTPUT: 11 Bytes
    manual: str. 6.11 : CAS
     INPUT: 11 Bytes: @@Aa<x><x><x><checksum><CR><LF>
                          x=255 (posli cas)
     OUTPUT: 11 Bytes

   Pri uspechu vracia 0, inak 1.
*/
int GPS_Oncore_OS_date_time_(void)

{
       int Gmonth, Gday, Gyear, Ghour, Gminute, Gsecond;
       int Omonth, Oday, Oyear, Ohour, Ominute, Osecond;
       char key, sranda[5]=" .oO0";
       int i=-1, set=0, GT=0, GD=0;

       ansi_clearscreen_();
       ansi_gotoxy_clear_(1, 20);
       printf("Date/Time: Oncore vs. Operating System\n");
       ansi_gotoxy_clear_(2, 15);
       printf("press ESC to quit, S to set OS's date/time from Oncore\n");

       do
        {

         i++;
         if(i>4)
          i=0;

         GT=0; GD=0;

         /* Oncore Date */
         znakin[2]=KEY_A;  /* A */
         znakin[3]=KEY_c;  /* c */
         znakin[4]=255;      /* 255-binarne */
         znakin[5]=255;      /* 255-binarne */
         znakin[6]=255;      /* 255-binarne */
         znakin[7]=255;      /* 255-binarne */
         if(Mototrola_to_port_(11))
          return(1);

         if(Mototrola_from_port_(11))
          {
           ansi_gotoxy_clear_(4, 1);
           printf("ERROR in (DATUM) data read\n");
          }
         else
          {
           Gmonth=znakout[4];
           Gday=znakout[5];
           Gyear=znakout[6];
           Gyear=(Gyear << 8);
           Gyear=Gyear+znakout[7];
           GD=1;
          }
         /* Oncore Time */
         znakin[2]=KEY_A;  /* A */
         znakin[3]=KEY_a;  /* a */
         znakin[4]=255;      /* 255-binarne */
         znakin[5]=255;      /* 255-binarne */
         znakin[6]=255;      /* 255-binarne */
         if(Mototrola_to_port_(10))
          return(1);

         if(Mototrola_from_port_(10))
          {
           ansi_gotoxy_clear_(4, 1);
           printf("ERROR in (TIME) data read\n");
          }
         else
          {
           Ghour=znakout[4];
           Gminute=znakout[5];
           Gsecond=znakout[6];
           GT=1;
          }

         /* Ak bolo stlacene S, prestav OS cas podla Oncore */
         if(set && GD && GT)
          {
           cas_nastavenie_(&Gyear, &Gmonth, &Gday, &Ghour, &Gminute, &Gsecond, 0);
           set=0;
	   key=0;
          }
         /* OS's Date & Time */
         cas_hodnoty_(&Oyear, &Omonth, &Oday, &Ohour, &Ominute, &Osecond);


         ansi_gotoxy_clear_(10, 30);
         printf("dd/mm/year   hh:mm:ss \n");
         ansi_gotoxy_clear_(11, 10);
         printf("Operating system:   %02d/%02d/%04d   %02d:%02d:%02d \n",
                 Oday, Omonth, Oyear, Ohour, Ominute, Osecond);
         ansi_gotoxy_clear_(12, 10);
         if(GD && GT)
          printf("Oncore:             %02d/%02d/%04d   %02d:%02d:%02d \n",
                 Gday, Gmonth, Gyear, Ghour, Gminute, Gsecond);

         ansi_gotoxy_(14, 40);
         putc(sranda[i], stdout);
         ansi_gotoxy_(14, 40);

         delay(DELAY_TIME);
         if( kbhit() )
          {
           key=getch();
           flush_input_();
          }

         if( key==KEY_S || key==KEY_s )
          set=1;

        }while(key!=KEY_ESC);

       return(0);

}
/* ######End Subroutine: GPS_Oncore_OS_date_time_ ###########*/

