/* VERZIA 19991111 */
/*      OBSAHUJE vseobecne subroutiny:
                stlac_plus_minus_
                stlacena_klavesa_
                ansi_clearscreen_
                ansi_bell_
                ansi_gotoxy_
                ansi_gotoxy_clear_
*/
/*  Nasleduju potrebne HEADER FILES: /* */

#include <stdio.h>
#if defined (DOS)
 #include <conio.h>
#endif

#include "defines.h"

/* Dalsie, tu pouzite funkcie, su definovane v:
#include "linuxdos.c"

/* */

/* ###########Subroutine stlac_plus_minus_ ############
 Tato routina routina caka, pokial nie je stlacena klavesa + alebo -
  Vracia ASCII kod stlacenej klavesy.
*/
int stlac_plus_minus_(void)

{
      extern void flush_input_();

      int key, znak;

      flush_input_();
      do
      {
         key=0;
         /* ###----- stalcenie klavesy ------ */
         if(key!=KEY_PLUS)
          {
           flush_input_();
           key=getch();
          }
      }while(key != KEY_PLUS && key != KEY_MINUS);

return(key);
}
/* ######End Suboutine: stlac_plus_minus_ ###########*/

/* ###########Subroutine stlacena klavesa_ ############
 Tato routina routina caka, pokial nie je stlacena nejaka klavesa z rosahu
  kodov 32-126 a 27 t.j. "normalne "plain ASCII" + ESC.
  Vracia ASCII kod stlacenej klavesy.
*/
int stlacena_klavesa_(void)

{
      extern void flush_input_();

      int key, znak;

      flush_input_();
      do
      {
         key=0;
         /* ###----- stalcenie klavesy ------ */
         if(key!=KEY_PLUS)
          {
           flush_input_();
           key=getch();
          }
      }while((key != KEY_ESC) && ((key < 32) || (key > 126)) );

return(key);
}
/* ######End Suboutine: stlacena_klavesa_ ###########*/

/* ###########Subroutine ansi_clearscreen_ ############
 Vycisti obrazovku pomocou ANSI Esc sekvencii.
  Terminal musi byt schopny pracovat s tymito sekvenciami
   (pod DOSom driver ANSI.SYS v config.sys).
*/
void ansi_clearscreen_(void)

{
printf("%c[2J", KEY_ESC);
return;
}
/* ######End Suboutine: ansi_clearscreen_ ###########*/

/* ###########Subroutine ansi_bell_ ############
 Zapipa pomocou ANSI Esc sekvencii.
  Terminal musi byt schopny pracovat s tymito sekvenciami
   (pod DOSom driver ANSI.SYS v config.sys).
*/
void ansi_bell_(void)

{
printf("%c", KEY_BELL);
return;
}
/* ######End Suboutine: ansi_bell_ ###########*/

/* ###########Subroutine ansi_gotoxy_ ############
 Nastavi kurzor na X-ty riadok a Y-ty stlpec pomocou ANSI Esc sekvencii.
  Terminal musi byt schopny pracovat s tymito sekvenciami
   (pod DOSom driver ANSI.SYS v config.sys).
  Vstupom je X, Y
*/
void ansi_gotoxy_(int x, int y)

{
printf("%c[%d;%dH", KEY_ESC, x, y);
return;
}
/* ######End Suboutine: ansi_gotoxy_ ###########*/

/* ###########Subroutine ansi_gotoxy_clear_ ############
 Nastavi kurzor na X-ty riadok a Y-ty stlpec pomocou ANSI Esc sekvencii,
 pricom predtym X-ty riadok cely vymaze.
  Terminal musi byt schopny pracovat s tymito sekvenciami
   (pod DOSom driver ANSI.SYS v config.sys).
  Vstupom je X, Y
*/
void ansi_gotoxy_clear_(int x, int y)

{
printf("%c[%d;%dH%c[K", KEY_ESC, x, y, KEY_ESC);
return;
}
/* ######End Suboutine: ansi_gotoxy_clear_ ###########*/

