unit Enteredi;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TEnterEdit = class(TEdit)
  private
    { Private declarations }
    FOnKbEnter: TNotifyEvent;
  protected
    { Protected declarations }
  public
    { Public declarations }
    Procedure KeyPress(var Key: Char); override;
  published
    { Published declarations }
    Property OnKbEnter: TNotifyEvent read FOnKbEnter write FOnKbEnter;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Bernd', [TEnterEdit]);
end;


Procedure TEnterEdit.KeyPress(var Key: Char);
  begin
  if Key=Chr($0D) then
    if assigned(FOnKbEnter) then FOnKbEnter(self);
  inherited KeyPress(Key);
  end;

end.
