unit Keyspeed;   {Bernd Hoen, 9.7.1995}

{ Diese Unit enthlt die neue Komponente 'TKeySpeedButton'.
  Die Komponente 'TKeySpeedButton' hat gegenber der Komponente
  'TSpeedButton' die zustzliche Eigenschaft, da sie auch per
  Tastatur (ALT key) bedient werden kann.

  Die Komponente kann einfach der Komponentenpalette hinzugefgt
  werden.

  Die Eigenschaft 'AllKeysUp=True' darf nicht verndert werden.
  Die Eigenschaft 'GroupIndex=1234' darf verndert, jedoch nicht
  auf '0' gesetzt werden.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons;

type
  TKeySpeedButton = class(TSpeedButton)
  private
    { Private declarations }
  protected
    { Protected declarations }
    Procedure MouseDown(Button: TMouseButton; SHift: TShiftState;
      X, Y: Integer); override;
  public
    { Public declarations }
    Constructor Create(AOwner: TComponent); override;
    Procedure Click; override;
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Bernd', [TKeySpeedButton]);
end;

Constructor TKeySpeedButton.Create(AOwner: TComponent);
  begin
  inherited Create(AOwner);
  AllowAllUp:=True;
  GroupIndex:=1234;
  end;

Procedure TKeySpeedButton.MouseDown(Button: TMouseButton; SHift: TShiftState;
  X, Y: Integer);
  begin
  Down:=not Down;
  inherited MouseDown(Button, Shift, X, Y);
  end;

Procedure TKeySpeedButton.Click;
  begin
  Down:=not Down;
  inherited Click;
  end;

end.
