unit Dialdb;    {13.7.1995, Bernd Hoen}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus;

type
  TFrequencyDataBase = class(TForm)
    PanelDataBase: TPanel;
    Label12: TLabel;
    Records: TLabel;
    ButtonDelete: TButton;
    ButLoad: TButton;
    ButSave: TButton;
    ListBox: TListBox;
    Panel1: TPanel;
    Label10: TLabel;
    Label11: TLabel;
    ButtonDbClose: TButton;
    procedure ButtonDeleteClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBoxDblClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ButSaveClick(Sender: TObject);
    procedure ButLoadClick(Sender: TObject);
    procedure ButtonDbCloseClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    DataChanged: Boolean;
    function GetSubString(S: string):string;
  public
    { Public declarations }
    procedure SetItem(Index: Integer);
    procedure AddItem(F:Extended; S:String);
  end;

var
  FrequencyDataBase: TFrequencyDataBase;

implementation

uses
  Main;

{$R *.DFM}


function TFrequencyDataBase.GetSubString(S: string):string;
  var
    i, Len, Start, Stop: integer;
  begin
  i:=1; Len:=Length(s);
  while (i<Len) and (s[i] in [' ']) do inc(i);
  Start:=i;
  while (i<Len) and (s[i] in ['0'..'9',',']) do inc(i);
  Stop:=i;
  Result:=Copy(s, Start, Stop-Start);
  end;


{**********************************************************}
{ Nach delete-operationen in einer Listbox mu unbedingt
  "SetItem" aufgerufen werden. Dies setzt den Index auf
  einen gltigen Wert und selektiert dieses Element. }

procedure TFrequencyDataBase.SetItem(Index: Integer);
var
  MaxIndex: Integer;
begin
{List: TListBox; }
  with ListBox do
  begin
    SetFocus;
    MaxIndex := ListBox.Items.Count - 1;
    if Index = LB_ERR then Index := 0
    else if Index > MaxIndex then Index := MaxIndex;
    Selected[Index] := True;
  end;
end;
{**********************************************************}

procedure TFrequencyDataBase.AddItem(F:Extended; S:String);
{Zahl formatieren auf R:10:3 wie in dds_Chip,
 String formatieren auf S:80.
 Keine "duplicates" in die Liste eintragen.}
  var
    S1,s2,s3:string;
    i, N: Integer;
  begin
  S1:=MainForm.ddsChip.FreqStr(F);
  N:=Length(S1);
  for i:=N to 11 do
    Insert(' ', S1, 1);
  s2:=copy(S, 1, 80);
  s3:=concat(s1, '   ',s2);
  if ListBox.Items.IndexOf(S3)<0 then
    begin
    ListBox.Items.Add(S3);
    DataChanged:=True;
    end;
  Records.Caption:=IntToStr(ListBox.Items.Count);
  end;

{***************************************************************}


procedure TFrequencyDataBase.ButtonDeleteClick(Sender: TObject);
var
  OldItemIndex, j: integer;
begin
with ListBox do
  begin
  OldItemIndex:=ItemIndex;
  if SelCount=1 then
    begin
    if OldItemIndex>=0 then Items.Delete(OldItemIndex);
    end
  else
    begin {multi delete}
    for j:=Items.Count-1 downto 0 do
      if Selected[j] then
        Items.Delete(j);
    end;
  end;
SetItem(OldItemIndex);
end;

procedure TFrequencyDataBase.FormCreate(Sender: TObject);
begin
with FrequencyDataBase do
  begin
  Left    :=MainForm.DbX;
  Top     :=MainForm.DbY;
  Width   :=MainForm.DbW;
  Height  :=MainForm.DbH;
  Position:=MainForm.DbPosition;
  Visible :=MainForm.DbVisible;
  end;
ButLoadClick(Self);
end;

procedure TFrequencyDataBase.ListBoxDblClick(Sender: TObject);
var
  s: string;
  F: Extended;
begin
with ListBox do  s:=Items[ItemIndex];
with MainForm do
  F:=GetStrToFloat(GetSubString(S));
with MainForm.ddsChip do
  if (F<UserMin) or (F>UserMax) then
    SetUserMinMax(HardwareMin, HardwareMax);
with MainForm do UpdateFrequency1(F);
end;

procedure TFrequencyDataBase.FormCloseQuery(Sender: TObject;
                                            var CanClose: Boolean);
begin
MainForm.DbX:=Left;
MainForm.DbY:=Top;
MainForm.DbW:=Width;
MainForm.DbH:=Height;
if DataChanged then
  begin
  if MessageDlg('Data base has changed. Save now?',
     mtConfirmation, [mbYes,mbNo],0) = mrYes then
    ButSaveClick(Self);
  DataChanged:=False;
  end;
CanClose:=not DataChanged;
end;

procedure TFrequencyDataBase.ButSaveClick(Sender: TObject);
var
  Db: System.Text;
  i: Integer;
begin
System.Assign(Db, MainForm.DbFilename);
Rewrite(Db);
with ListBox do
  for i:=0 to Items.Count-1 do
    Writeln(Db, Items[i]);
System.Close(Db);
DataChanged:=False;

DataChanged:=False;
end;

procedure TFrequencyDataBase.ButLoadClick(Sender: TObject);
var
  Db: System.Text;
  i, N: Integer;
  S, NumberString, CommentString: String;
  Position: Byte;
begin
System.Assign(Db, MainForm.DbFilename);
try
  Reset(Db);
except
  on EInOutError do
    begin
    Rewrite(Db);
    System.Close(Db);
    Reset(Db);
    end;
end;
with ListBox do
  begin
  Clear;
  while not eof(Db) do
    begin
    Readln(Db, S);
    {extract number}
    NumberString:=GetSubString(S);
    Position:=Pos(NumberString, S);
    N:=Length(NumberString);
    for i:=N to 11 do
      Insert(' ', NumberString, 1);
    {extract comment}
    if Position<>0 then
      Delete(S, Position, N);
    i:=1;
    while (i<Length(S)) and (S[1]=' ') do
      Delete(S, 1, 1);
    CommentString:=S;
    Items.Add(NumberString + '   ' + CommentString);
    end;
  end;
System.Close(Db);
DataChanged:=False;
end;

procedure TFrequencyDataBase.ButtonDbCloseClick(Sender: TObject);
begin
Close;
end;

procedure TFrequencyDataBase.FormResize(Sender: TObject);
var
  W: Integer;
begin
W:=ButtonDelete.Left+ButtonDelete.Width+10;
if width <W then width:=W;
if height<150 then height:=150;
end;

procedure TFrequencyDataBase.FormActivate(Sender: TObject);
begin
ShowHint:=MainForm.ShowHint;
end;

end.
