unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, Spin, Menus, Dds_chip, Tabs,
  Enteredi, Entercom, KeySpeed;

const
  ScrollBarPositions = 10000;


type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Contents1: TMenuItem;
    N1: TMenuItem;
    Tools1: TMenuItem;
    PopupMenuMain: TPopupMenu;
    PopupMenuHints: TMenuItem;
    Notebook1: TNotebook;
    MainPanel: TPanel;
    Label5: TLabel;
    Label7: TLabel;
    LowerLimit: TLabel;
    UpperLimit: TLabel;
    Label15: TLabel;
    Label3: TLabel;
    ButtonSwap: TBitBtn;
    FreqScrollBar: TScrollBar;
    BandBox: TComboBox;
    TabSet1: TTabSet;
    Freq1: TEnterEdit;
    Freq0: TEnterEdit;
    PanelF0EqualF1: TPanel;
    ImageF0EqualF1: TImage;
    Panel1: TPanel;
    Label8: TLabel;
    StepBox: TEnterComboBox;
    TimerStep: TTimer;
    Label13: TLabel;
    Panel2: TPanel;
    PanelConfig: TPanel;
    RadioGroupLPT: TRadioGroup;
    DdsChip: TDdsChip;
    SpeedButtonDown: TKeySpeedButton;
    SpeedButtonUp: TKeySpeedButton;
    ButtonStepDown: TSpeedButton;
    ButtonStepUp: TSpeedButton;
    ButtonDbAdd: TButton;
    Panel3: TPanel;
    Label11: TLabel;
    Label12: TLabel;
    SpeedEdit1: TEnterEdit;
    Label18: TLabel;
    Label14: TLabel;
    SpeedEdit2: TEnterEdit;
    Label19: TLabel;
    Label16: TLabel;
    SpeedEdit3: TEnterEdit;
    Label20: TLabel;
    Label17: TLabel;
    SpeedEdit4: TEnterEdit;
    Label21: TLabel;
    RadioGroupUpDown: TRadioGroup;
    Editbands1: TMenuItem;
    Panel4: TPanel;
    Label1: TLabel;
    Label10: TLabel;
    EditQuartz: TEnterEdit;
    EditBits: TEnterEdit;
    Open1: TMenuItem;
    Label22: TLabel;
    RadioDivMul: TRadioGroup;
    EditDivider: TEnterEdit;
    Label4: TLabel;
    Label6: TLabel;
    Label9: TLabel;
    LabelClock: TLabel;
    LabelHardwareMin: TLabel;
    LabelHardwareMax: TLabel;
    ButConfigNow: TButton;
    procedure Exit1Click(Sender: TObject);
    procedure ButtonSwapClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Database1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure BandBoxExit(Sender: TObject);
    procedure FreqScrollBarScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure BandBoxKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Hints(Sender: TObject);
    procedure TabSet1Click(Sender: TObject);
    procedure EditQuartzKbEnter(Sender: TObject);
    procedure EditBitsKbEnter(Sender: TObject);
    procedure ImageF0EqualF1Click(Sender: TObject);
    procedure Freq1KbEnter(Sender: TObject);
    procedure Freq0KbEnter(Sender: TObject);
    procedure DdsChipUserMinMaxChange(Sender: TObject);
    procedure ButUpClick(Sender: TObject);
    procedure ButDownClick(Sender: TObject);
    procedure StepBoxKbEnter(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TimerStepTimer(Sender: TObject);
    procedure ButtonUpDownClick(Sender: TObject);
    procedure RadioGroupLPTClick(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure Label7Click(Sender: TObject);
    procedure Freq1Enter(Sender: TObject);
    procedure Freq1Exit(Sender: TObject);
    procedure Freq0Exit(Sender: TObject);
    procedure Freq0Enter(Sender: TObject);
    procedure ButtonStepUpClick(Sender: TObject);
    procedure ButtonStepDownClick(Sender: TObject);
    procedure Freq1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ButtonDbAddClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure RadioGroupUpDownClick(Sender: TObject);
    procedure EditBandClick(Sender: TObject);
    procedure ButConfigNowClick(Sender: TObject);
  private
    { Private declarations }
    StepSize,
    FrequencyStep: Extended;
    Stepping,
    FirstActivation: Boolean;
    SteppingMode: (SingleSweep, ContinuousRamp, ContinuousTriangle);
    OldQuartzText,
    OldBitsText,
    OldDividerText : String;
    OldRadioDivMul : Integer;
    Procedure SetScrollBarParams;
  public
    { Public declarations }
    DbPosition : TPosition;
    DbX, DbY,
    DbW, DbH   : Integer;
    DbVisible  : Boolean;
    IniFilename,
    DbFilename,
    BandFilename,
    HelpFilename: String;
    Procedure UpdateFrequency1(F: Extended);
    Procedure UpdateFrequency0(F: Extended);
    Function  SafeStrToFloat(S:String; var Value:Extended):Boolean;
    Function  SafeStrToInt(S:String; var Value:Longint):Boolean;
    Function  GetStrToFloat(S:String):Extended;
    Function  GetStrToInt(S:String):Longint;
    Procedure StopStepping;
  end;

var
  MainForm: TMainForm;




implementation

{$R *.DFM}

uses
    DialDb, DialBand, About,
    IniFiles;

{Freq1
var
  s:string;
  i:integer;
begin
DataBase.AddItem(StrToFloat(Freq1.Text), 'Freq1');
}
{Freq0
DataBase.AddItem(StrToFloat(Freq0.Text), 'Freq0');
}
(*
procedure TMainForm.SendToHardware(F0, F1 : Extended);
  var bin:longint;

   function HexString(value:longint):string;
    const   Conversion : string[16]='0123456789ABCDEF';
    var     i : integer;    s : string[8];
    begin
    s:='';
    for i:=0 to 7 do
      s:=Conversion[((value shr (i*4)) and $0000000F) +1] + s;
    HexString:=s;
    end{HexString};

  begin
  with ddsChip do
    begin
    bin:=Round( (Frequency0/Clock)*exp(ln(2)*Bits){ZweiHochBitzahl} );
    ddsChip.SendBits(0, bin , Bits);
    Freq1Hex.Caption:=HexString(bin);
    bin:=Round( (Frequency1/Clock)*exp(ln(2)*Bits){ZweiHochBitzahl} );
    ddsChip.SendBits(1, bin , Bits);
    end;
  end;
  *)

Procedure TMainForm.SetScrollBarParams;
  begin
  FreqScrollBar.SetParams(0 ,0, ScrollBarPositions);
  UpdateFrequency1(ddsChip.UserMin);
  end;

Procedure TMainForm.UpdateFrequency1(F: Extended);
  var
    Pos: Integer;
    delta: Extended;
  begin
  with ddsChip do
    begin
    Frequency1:=F;
    delta:=(UserMax-UserMin);
    Pos:=Round(ScrollBarPositions*(Frequency1-UserMin)/delta);
    end;
  With FreqScrollBar do
    begin
    if Pos>Max then Pos:=Max;
    if Pos<Min then Pos:=Min;
    Position:=Pos;
    end;
  end;

Procedure TMainForm.UpdateFrequency0(F: Extended);
  var
    Pos: Integer;
  begin
  ddsChip.Frequency0:=F;
  end;


Function TMainForm.SafeStrToFloat(S:String; var Value:Extended):Boolean;
  var
    err: integer;
  begin
  for err:=1 to Length(S) do if S[err]=',' then S[err]:='.';
  Val(S, Value, err);
  if err<>0 then
      MessageDlg('Decimal number needed', mtError, [mbOK], 0);
  end;

Function TMainForm.SafeStrToInt(S:String; var Value:Longint):Boolean;
  var
    err: integer;
  begin
  for err:=1 to Length(S) do if S[err]=',' then S[err]:='.';
  Val(S, Value, err);
  if err<>0 then
      MessageDlg('Integer number needed', mtError, [mbOK], 0);
  end;


Function TMainForm.GetStrToFloat(S:String):Extended;
  var
    Value: Extended;
  begin
  SafeStrToFloat(S, Value);
  GetStrToFloat:=Value;
  end;


Function TMainForm.GetStrToInt(S:String):Longint;
  var
    Value: Longint;
  begin
  SafeStrToInt(S, Value);
  GetStrToInt:=Value;
  end;



procedure TMainForm.Exit1Click(Sender: TObject);
begin
Close;
end;

procedure TMainForm.ButtonSwapClick(Sender: TObject);
var
  F: Extended;
begin
with ddsChip do
  begin
  F:=Frequency0;
  UpdateFrequency0(Frequency1);
  UpdateFrequency1(F);
  end;
end;

procedure TMainForm.About1Click(Sender: TObject);
begin
AboutBox.ShowModal;
end;

procedure TMainForm.Database1Click(Sender: TObject);
begin
with FrequencyDataBase do
  begin
  if WindowState=wsMinimized then WindowState:=wsNormal
  else
     if not Visible then Show;
  end;
end;


procedure TMainForm.FormCreate(Sender: TObject);
var
  L:Longint;
  F, Min, Max:Extended;
  IniFile: TIniFile;
  x,y,i: Integer;
  S: String;
begin
FirstActivation:=True;
Stepping:=False;
with RadioGroupLPT.Items do
  begin
  Add('LPT1');
  Add('LPT2');
  end;
TabSet1.TabIndex:=0;
NoteBook1.PageIndex:=0;

with ddsChip do
  begin
  Quartz:=Quartz;
  Divider:=Divider;
  Bits:=Bits;
  DivMul:=DivMul;
  end;

{-----Prepare filenames-------------------------------------}
s:=Application.ExeName;
IniFilename:=ExtractFilePath(s) + ChangeFileExt(ExtractFileName(s),   '.INI');
DbFilename :=ExtractFilePath(s) + ChangeFileExt(ExtractFileName(s),   '.DB');
BandFilename :=ExtractFilePath(s) + ChangeFileExt(ExtractFileName(s), '.BND');
HelpFilename :=ExtractFilePath(s) + ChangeFileExt(ExtractFileName(s), '.HLP');

Application.HelpFile:=HelpFilename;

{-----Read IniFile-------------------------------------}
IniFile:=TIniFile.Create(IniFilename);
{MainForm position}
RadioGroupLPT.ItemIndex:=IniFile.ReadInteger('DDSWIN','lptport', 0);
ddsChip.SelectPort(RadioGroupLPT.ItemIndex+1);
with MainForm Do
  begin
  x:=IniFile.ReadInteger('DDSWIN','mainLeft',    -1);
  y:=IniFile.ReadInteger('DDSWIN','mainTop',     -1);
  if (x<>-1) and (y<>-1) then
    begin
    Left:=x; Top:=y; Position:=poDesigned;
    end
  else
    Position:=poScreenCenter;
  end;
{DataBase position}
DbX      :=IniFile.ReadInteger('DATABASE','Left',    -1);
DbY      :=IniFile.ReadInteger('DATABASE','Top',     -1);
DbW      :=IniFile.ReadInteger('DATABASE','Width',   -1);
DbH      :=IniFile.ReadInteger('DATABASE','Height',  -1);
DbVisible:=IniFile.ReadBool   ('DATABASE','Visible', False);
if (Dbx<>-1) and (Dby<>-1) then
  DbPosition:=poDesigned
else
  DbPosition:=poScreenCenter;

{BandBox}
try
  BandBox.Items.LoadFromFile(BandFilename);
except
  on EInOutError do  ;
  else ;
end;
BandBox.Text := BandBox.Items[0];

{DDS-Chip}
ddsChip.Quartz  :=GetStrToFloat(IniFile.ReadString('CHIP','quartz', '55000,000'));
ddsChip.Divider :=GetStrToInt  (IniFile.ReadString('CHIP','divider', '1'));
ddsChip.Bits    :=GetStrToInt  (IniFile.ReadString('CHIP','bits', '32'));

i:=GetStrToInt(IniFile.ReadString('CHIP','divmul', '0'));
RadioDivMul.ItemIndex:=i;
Case i of
  0: ddsChip.DivMul:=Divide;
  1: ddsChip.DivMul:=Multiply;
  end;

Min:=GetStrToFloat(IniFile.ReadString('CHIP','userMin', '3500,000'));
Max:=GetStrToFloat(IniFile.ReadString('CHIP','userMax', '4000,000'));
ddsChip.SetUserMinMax(Min, Max);
F:=GetStrToFloat(IniFile.ReadString('CHIP','freq1', '3703,000'));
UpdateFrequency1(F);
F:=GetStrToFloat(IniFile.ReadString('CHIP','freq0', '3750,000'));
UpdateFrequency0(F);

PopupMenuHints.Checked:=IniFile.ReadBool('DDSWIN', 'showhint', True);
ShowHint:=PopupMenuHints.Checked;
{Preferences}
SpeedEdit1.Text:=IniFile.ReadString('PREFERENCES','Time1', SpeedEdit1.Text);
SpeedEdit2.Text:=IniFile.ReadString('PREFERENCES','Time2', SpeedEdit2.Text);
SpeedEdit3.Text:=IniFile.ReadString('PREFERENCES','Time3', SpeedEdit3.Text);
SpeedEdit4.Text:=IniFile.ReadString('PREFERENCES','Time4', SpeedEdit4.Text);
RadioGroupUpDown.ItemIndex:=IniFile.ReadInteger('PREFERENCES','SteppingMode', 0);

StepBox.ItemIndex:=IniFile.ReadInteger('DDSWIN','StepBoxIndex', 3);
SafeStrToFloat(StepBox.Text, F);
StepSize:=ddsChip.Limited(F, 0.001, 1000.0);

IniFile.Free;
{-----End of Read IniFile-------------------------------------}
FrequencyStep:=5.0;
end{TMainForm.FormCreate};


procedure TMainForm.Contents1Click(Sender: TObject);
const
  HelpViewer       = 'WRITE';
  HelpFileContents = 'HELP.WRI';
var
  Command,
  Path   : String[254];
  CmdStr : array [0..255] of Char;
  i      : integer;
begin
Application.HelpCommand(HELP_CONTENTS, 0);
(*
Path:=Application.ExeName;
Path:=ExtractFilePath(Path)+HelpFileContents;
if not FileExists(Path) then
  MessageDlg('Missing help file '+Path+'. See file README.TXT!',
    mtError, [mbOK], 0)
else
  begin
  Command:=HelpViewer+' '+Path;
  StrPCopy(CmdStr, Command);
  if WinExec(CmdStr, SW_SHOWNORMAL) < 32 then
    MessageDlg('Could not execute '+HelpViewer+'. See file README.TXT!',
      mtError, [mbOK], 0);
  end;
*)
end;

procedure TMainForm.BandBoxExit(Sender: TObject);
const
  cr=#$0d;
var
  s, min, max   : String;
  i, imin, imax : Longint;
  err1, err2    : Integer;
  umin, umax    : Extended;
  error:boolean;
begin
error:=false;
with BandBox do
  begin
  s:=Text;
  i:=pos('-', s);
  if i>1 then
    begin
    min:=system.copy(s, 1, i-1);
    delete(s, 1, i);
    while (Length(s)>0) and not (s[1] in ['0'..'9']) do
      delete(s,1,1);
    max:=s;
    {validate min, max}
    val(min, imin, err1);
    val(max, imax, err2);
    if (err1<>0) or (err2<>0) then
      error:=true {not a number}
    else
      begin
      {range limiting}
      with ddsChip do
        begin
        if imin<Round(int(HardwareMin)+1) then
          imin:=Round(int(HardwareMin)+1);
        if imax>Round(int(HardwareMax)-1) then
          imax:=Round(int(HardwareMax)-1);
        end;
      {range check}
      umin:=ddsChip.HardwareMin;
      umax:=ddsChip.HardwareMax;
      if (imin<umin) or (imax>umax) or (imin>=imax) then
        error:=true;
      end;
    end
  else
    error:=true;

  if not error then
    begin
    ddsChip.SetUserMinMax(imin, imax);
    SetScrollBarParams;
    BandBox.Color:=clWindow;
    end
  else
    begin
    BandBox.Color:=clRed;
    Str(Round(int(ddsChip.HardwareMin)+1), min);
    Str(Round(int(ddsChip.HardwareMax)-1), max);
    MessageDlg('Range error. Maximum range is'+cr+min+'-'+max,
                mtError, [mbOk], 0);
    end;
  end{with BandBox do};
end;

procedure TMainForm.FreqScrollBarScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
{      ddsChip:  UserMin .... UserMax
 FreqScrollBar:        0 .... ScrollBarPositions (1000)
}
var
  N: Longint;
  df,F: Extended;
begin
StepBoxKbEnter(nil); {gets StepSize}
with FreqScrollBar do
  begin
  with ddsChip do
    df:= (UserMax-UserMin)*Position/ScrollBarPositions;
  N:=Round(Int(df/StepSize));
  df:=N*StepSize;
  F:=ddsChip.UserMin+df;
  UpdateFrequency1(F);
  end;
end;

procedure TMainForm.BandBoxKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if Key=VK_RETURN then
  BandBoxExit(Sender);
end;

procedure TMainForm.Hints(Sender: TObject);
begin
ShowHint:=not ShowHint;
PopupMenuHints.Checked:=ShowHint;
end;

procedure TMainForm.TabSet1Click(Sender: TObject);
const
  ConfigurePage=1;
begin
if (NoteBook1.PageIndex<>ConfigurePage) and
       (TabSet1.TabIndex=ConfigurePage) then {entering ConfigurePage}
   begin
   OldQuartzText:=EditQuartz.Text;
   OldBitsText:=EditBits.Text;
   OldDividerText:=EditDivider.Text;
   OldRadioDivMul:=RadioDivMul.ItemIndex;
   end;
if (NoteBook1.PageIndex=ConfigurePage) and
     (TabSet1.TabIndex<>ConfigurePage) then {leaving ConfigurePage}
   begin
   EditQuartz.Text:=OldQuartzText;
   EditBits.Text:=OldBitsText;
   EditDivider.Text:=OldDividerText;
   RadioDivMul.ItemIndex:=OldRadioDivMul;
   end;
NoteBook1.PageIndex:=TabSet1.TabIndex;
end;

procedure TMainForm.EditQuartzKbEnter(Sender: TObject);
var
  Value:Extended;
begin
end;

procedure TMainForm.EditBitsKbEnter(Sender: TObject);
var
  value: Longint;
begin
end;

procedure TMainForm.ImageF0EqualF1Click(Sender: TObject);
begin
Freq1Exit(Sender);
UpdateFrequency0(ddsChip.Frequency1);
end;

procedure TMainForm.Freq1KbEnter(Sender: TObject);
var
  F: Extended;
begin
SafeStrToFloat(Freq1.Text, F);
{Possibly the user range has to be enlarged:}
with ddsChip do
  if (F<UserMin) or (F>UserMax) then
    SetUserMinMax(HardwareMin, HardwareMax);
UpdateFrequency1(F);
end;

procedure TMainForm.Freq0KbEnter(Sender: TObject);
var
  F: Extended;
begin
SafeStrToFloat(Freq0.Text, F);
{Possibly the user range has to be enlarged:}
with ddsChip do
  if (F<UserMin) or (F>UserMax) then
    SetUserMinMax(HardwareMin, HardwareMax);
UpdateFrequency0(F);
end;

procedure TMainForm.DdsChipUserMinMaxChange(Sender: TObject);
var
  Smin, Smax: String;
begin
Str(Round(ddsChip.UserMin), Smin);
Str(Round(ddsChip.UserMax), Smax);
BandBox.Text:=Smin+'-'+Smax;
SetScrollBarParams;
end;



procedure TMainForm.ButtonUpDownClick(Sender: TObject);
var
  V: Extended;
  S: String;
  StepSpeed1: Integer;
begin
if ((Sender as TSpeedButton).Name='SpeedButtonDown') and
  (SteppingMode=ContinuousRamp) then
  begin
  {A ramp must always go UP!}
  SpeedButtonDown.Down:=False;
  StopStepping;
  end
else
  begin{-----}
  Freq1.SetFocus;
  if (Sender as TSpeedButton).Down then
        begin
        StepBoxKbEnter(Sender);  {gets step size}
        if (Sender as TSpeedButton).Name='SpeedButtonUp' then
          FrequencyStep:=StepSize
        else
          FrequencyStep:=-StepSize;
        {get delay times in milliseconds from preferences panel}
        if StepSize<0.1  then S:=SpeedEdit1.Text else
        if StepSize<1.0  then S:=SpeedEdit2.Text else
        if StepSize<10.0 then S:=SpeedEdit3.Text else
        if StepSize<1e9  then S:=SpeedEdit4.Text;
        SafeStrToFloat(S, V);
        StepSpeed1:=Round(ddsChip.Limited(V, 20.0, 30000.0));
        with Freq1 do
          begin
          SetFocus;
          SelStart:=0;
          SelLength:=0;
          end;
        TimerStep.Interval:=StepSpeed1;
        TimerStep.Enabled:=True;
        Stepping:=True;
        end
  else {if (Sender as TSpeedButton).Down}
        begin
        StopStepping;
        end;
  end{-----};
end;



procedure TMainForm.ButUpClick(Sender: TObject);
var
  V: Extended;
  S: String;
  StepSpeed1: Integer;
begin
if SpeedButtonUp.Down then
  begin
  StepBoxKbEnter(Sender);  {get step size}
  FrequencyStep:=StepSize;
  {get delay times in milliseconds}
  if StepSize<0.1  then S:=SpeedEdit1.Text else
  if StepSize<1.0  then S:=SpeedEdit2.Text else
  if StepSize<10.0 then S:=SpeedEdit3.Text else
  if StepSize<1e9  then S:=SpeedEdit4.Text;
  SafeStrToFloat(S, V);
  StepSpeed1:=Round(ddsChip.Limited(V, 50.0, 30000.0));
  TimerStep.Interval:=StepSpeed1;
  TimerStep.Enabled:=True;
  end
else
  TimerStep.Enabled:=False;
end;


procedure TMainForm.ButDownClick(Sender: TObject);
begin
if SpeedButtonDown.Down then
  begin
  StepBoxKbEnter(Sender);
  FrequencyStep:=-StepSize;
  TimerStep.Enabled:=True;
  end
else
  TimerStep.Enabled:=False;
end;

procedure TMainForm.StepBoxKbEnter(Sender: TObject);
var
  F: Extended;
begin
{get step size}
SafeStrToFloat(StepBox.Text, F);
F:=ddsChip.Limited(F, 0.001, 1000.0);
StepSize:=F;
end;


procedure TMainForm.FormDestroy(Sender: TObject);
var
  IniFile: TIniFile;
begin
IniFile:=TIniFile.Create(IniFilename);

IniFile.WriteString('DDSWIN','IniFile',  IniFilename);
IniFile.WriteString('DDSWIN','DbFile',   DbFilename);
IniFile.WriteString('DDSWIN','BandFile', BandFilename);
IniFile.WriteString('DDSWIN','HelpFile', HelpFilename);

IniFile.WriteInteger('DDSWIN','LptPort', RadioGroupLPT.ItemIndex);
with MainForm Do
  begin
  IniFile.WriteInteger('DDSWIN','mainLeft',   Left);
  IniFile.WriteInteger('DDSWIN','mainTop',    Top);
  end;

{with FrequencyDataBase Do}
  begin
  IniFile.WriteInteger('DATABASE','Left',    DbX);
  IniFile.WriteInteger('DATABASE','Top',     DbY);
  IniFile.WriteInteger('DATABASE','Width',   DbW);
  IniFile.WriteInteger('DATABASE','Height',  DbH);
  IniFile.WriteBool   ('DATABASE','Visible', DbVisible);
  end;

{StepSize}
IniFile.WriteInteger('DDSWIN','StepBoxIndex', StepBox.ItemIndex);

{ddsChip}
with IniFile, ddsChip do
  begin
  WriteString('CHIP','Quartz', FreqStr(Quartz));
  WriteString('CHIP','Divider',IntToStr(Divider));

  Case ddsChip.DivMul of
  Divide  : WriteString('CHIP','divmul','0');
  Multiply: WriteString('CHIP','divmul','1');
  end;

  WriteString('CHIP','Bits',   IntToStr(Longint(Bits)));
  WriteString('CHIP','Freq1',  FreqStr(Frequency1));
  WriteString('CHIP','Freq0',  FreqStr(Frequency0));
  WriteString('CHIP','UserMin',FreqStr(UserMin));
  WriteString('CHIP','UserMax',FreqStr(UserMax));
  end;

{Preferences}
IniFile.WriteString('PREFERENCES', 'Time1', SpeedEdit1.Text);
IniFile.WriteString('PREFERENCES', 'Time2', SpeedEdit2.Text);
IniFile.WriteString('PREFERENCES', 'Time3', SpeedEdit3.Text);
IniFile.WriteString('PREFERENCES', 'Time4', SpeedEdit4.Text);
IniFile.WriteInteger('PREFERENCES','SteppingMode', RadioGroupUpDown.ItemIndex);

IniFile.WriteBool('DDSWIN', 'showhint', PopupMenuHints.Checked);

IniFile.Free;

{BandBox}
BandBox.Items.SaveToFile(BandFilename);

Application.HelpCommand(HELP_QUIT,0);
end;

procedure TMainForm.TimerStepTimer(Sender: TObject);
const
  epsilon: Extended = 0.000001;
var
  ActualFrequency,
  NewFrequency: Extended;
begin
NewFrequency:=ddsChip.Frequency1+FrequencyStep;
if (NewFrequency>ddsChip.UserMax) or (NewFrequency<ddsChip.UserMin) then
  begin
  case SteppingMode of
    SingleSweep:        StopStepping;
    ContinuousRamp:     NewFrequency:=ddsChip.UserMin;
    ContinuousTriangle: begin
                        FrequencyStep:=-FrequencyStep;
                        NewFrequency:=ddsChip.Frequency1+FrequencyStep;
                        end;
    end{case};
  end;
if (NewFrequency<=ddsChip.UserMax) and (NewFrequency>=ddsChip.UserMin) then
  if Stepping then
    UpdateFrequency1(NewFrequency);
end;

procedure TMainForm.RadioGroupLPTClick(Sender: TObject);
begin
ddsChip.SelectPort(RadioGroupLPT.ItemIndex+1);
end;


procedure TMainForm.Label5Click(Sender: TObject);
begin
Freq1.SetFocus;
Freq1.SelectAll;
end;

procedure TMainForm.Label7Click(Sender: TObject);
begin
Freq0.SetFocus;
Freq0.SelectAll;
end;

procedure TMainForm.Freq1Enter(Sender: TObject);
begin
StopStepping;
Freq1.Color:=clYellow;
end;

procedure TMainForm.Freq1Exit(Sender: TObject);
begin
StopStepping;
Freq1.Color:=clWindow;
Freq1KbEnter(Sender);
end;

procedure TMainForm.Freq0Exit(Sender: TObject);
begin
Freq0.Color:=clWindow;
Freq0KbEnter(Sender);
end;

procedure TMainForm.Freq0Enter(Sender: TObject);
begin
Freq0.Color:=clYellow;
end;

procedure TMainForm.ButtonStepDownClick(Sender: TObject);
begin
StopStepping;
UpdateFrequency1(ddsChip.Frequency1 - StepSize);
with Freq1 do
  begin
  SetFocus;
  SelStart:=0;
  SelLength:=0;
  end;
end;

procedure TMainForm.ButtonStepUpClick(Sender: TObject);
begin
StopStepping;
UpdateFrequency1(ddsChip.Frequency1 + StepSize);
with Freq1 do
  begin
  SetFocus;
  SelStart:=0;
  SelLength:=0;
  end;
end;

Procedure TMainForm.StopStepping;
begin
if Stepping then
  begin
  TimerStep.Enabled:=False;
  SpeedButtonDown.Down:=False;
  SpeedButtonUp.Down:=False;
  Stepping:=False;
  end;
end;

procedure TMainForm.Freq1Click(Sender: TObject);
begin
StopStepping;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if(Key=VK_F2) then
  UpdateFrequency0(ddsChip.Frequency1);
end;

procedure TMainForm.ButtonDbAddClick(Sender: TObject);
var
  Comment: string;
begin
Comment:='';
if InputQuery('Please enter a description','', Comment) then
  FrequencyDataBase.AddItem(ddsChip.Frequency1, Comment);
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
if FirstActivation then
  begin
  end;
FirstActivation:=False;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
MainForm.DbVisible:=FrequencyDataBase.Visible;
CanClose:=FrequencyDataBase.CloseQuery;
end;

procedure TMainForm.RadioGroupUpDownClick(Sender: TObject);
begin
case RadioGroupUpDown.ItemIndex of
  0: SteppingMode:=SingleSweep;
  1: SteppingMode:=ContinuousRamp;
  2: SteppingMode:=ContinuousTriangle
  else
    SteppingMode:=SingleSweep;
  end;
end;

procedure TMainForm.EditBandClick(Sender: TObject);
var
  N, i, mr: Integer;
begin
{Fill FormEditBands.Memo1 with band-strings}
FormEditBands.Memo1.Lines.Clear;
N:=MainForm.BandBox.Items.Count;
for i:=0 to N-1 do
  FormEditBands.Memo1.Lines.Add(BandBox.Items[i]);
mr:=FormEditBands.ShowModal;
if mr=mrOK then
  begin
  BandBox.Items.Clear;
  N:=FormEditBands.Memo1.Lines.Count;
  for i:=0 to N-1 do
    BandBox.Items.Add(FormEditBands.Memo1.Lines[i]);
  BandBox.ItemIndex:=0;
  end;
end;

procedure TMainForm.ButConfigNowClick(Sender: TObject);
var
  LValue:Longint;
  FValue:Extended;
begin
SafeStrToFloat(EditQuartz.Text, FValue);  ddsChip.Quartz:=FValue;
SafeStrToInt  (EditBits.Text, LValue);    ddsChip.Bits:=LValue;

case RadioDivMul.ItemIndex of
  0: ddsChip.DivMul:=Divide;
  1: ddsChip.DivMul:=Multiply;
  end;

SafeStrToInt  (EditDivider.Text, LValue);
if not (LValue in [1..128]) then
  MessageDlg('Number must be in the range 1..128', mtError, [mbOK], 0);
ddsChip.Divider:=LValue;

OldQuartzText :=EditQuartz.Text;
OldBitsText   :=EditBits.Text;
OldDividerText:=EditDivider.Text;
OldRadioDivMul:=RadioDivMul.ItemIndex;
end;

end.
