' NU2MGA30.BAS - NU2MEGA ver. 3.0 11/22/96 - Ted Antanaitis WA7ZZB

' NU2MGA30.BAS and NU2MGB30.BAS are two chained QBasic programs which extract
' geographic data from the USGS 1:2,000,000 Scale Optional Format CDrom
' mastered 7/95 and create APRS compatible maps. Both programs must reside in
' the same directory and be the same version (3.0).
' To run, type: qbasic/r nu2mga30, at the DOS prompt.


DECLARE SUB UNBLOCK (fi$, fo$)
DECLARE SUB HELP ()
DECLARE SUB init (mapf AS STRING, datf AS STRING, fldr AS STRING, workfldr AS STRING)
DECLARE SUB extr (a%, fldr$, workfldr$)
DECLARE SUB gethandles (filecnt%, f$, Fopre$)
DECLARE SUB clrunblk (a%, workfldr$, onepass%)

COMMON SHARED lat0!, long0!, latmax!, longmax!, ppdy!, ppdx!, mapf$, datf$, b%
COMMON SHARED latmin!, longmin!, version$, ALLpts%, Hfac!, fldr$, workfldr$
COMMON SHARED starttime$, onepass%
version$ = "Version 3.0"
starttime$ = TIME$
CALL init(mapf$, datf$, fldr$, workfldr$)
PRINT
PRINT "The CD ROM contains up to 6 major categories of map features as follows:"
PRINT
PRINT "  1  ROADS                - Included in all APRS maps"
PRINT "  2  Water Features       - Lots of points."
PRINT "  3  Political Boundaries - County lines.  Lots of points"
PRINT "  4  Administrative       - Park and military boarders"
PRINT "  5  Cultural features    - Airports"
PRINT "  6  Railroads            - Railroads"
PRINT
onepass% = 0
resp$ = "M"
INPUT "Single or Multiple Catagories (S/M) [M]"; resp$
IF resp$ = "s" OR resp$ = "S" THEN
agn3:
    PRINT : INPUT "Which SINGLE catagory"; a$
    a! = VAL(a$)
    IF a! < 1 OR a! > 6 THEN
        PRINT a$; " is an improper input, try again!"
        GOTO agn3
    END IF
    onepass% = a!
    a% = a!
END IF
IF onepass% = 0 THEN
    PRINT "As a minimum, NU2MGA30 will always use category 1, and additional"
    PRINT "categories up to the final category you select."
    PRINT
    INPUT "Select the maximum number of categories (6)"; a$
    IF a$ = "" THEN a! = 2 ELSE a! = 1 + VAL(a$)
    IF a! < 2 THEN a! = 2
    IF a! > 7 THEN a! = 7
    a% = a!
END IF
resp$ = "N"
PRINT
PRINT "If the CDROM files for *THIS* state and *ALL* catagories selected have been"
PRINT "extracted, in a previous run of NU2MGA30, to the temporary working directory"
PRINT "you have specified, then bypassing this function will save considerable"
PRINT "execution time."
PRINT
PRINT "Are these files already in " + workfldr$ + " (Y/N) [N]";
INPUT ; resp$
IF (resp$ = "Y" OR resp$ = "y") THEN
    IF a% = 2 THEN b% = 4
    IF a% = 3 THEN b% = 6
    IF a% > 3 THEN b% = a% + 4
    GOTO byp
END IF
CALL extr(a%, fldr$, workfldr$)

REM Program name: CONV100b.BAS <-- ** OLD PROGRAM NAME **

REM This program takes the converted NEW format USGS cd rom 1 TO 2MEG DLG
REM "Optional Format" output and converts it into the same format as the OLD
REM 1 to 2,000,000 Graphic Format output which APRS MAPFIX can read.

DIM x(3000) AS LONG
DIM y(3000) AS LONG     'Largest number of x/y line pairs expected.
DIM origx(3000) AS LONG
DIM origy(3000) AS LONG

'Dimension integer variables for speed in extraction loop
DIM tyflag AS INTEGER
DIM id AS INTEGER
DIM k AS INTEGER
DIM i AS INTEGER
DIM txt$(6, 5)
txt$(1, 1) = "Water Bodies (color 11)"      'Output as WB
txt$(1, 2) = "Rivers and streams (color 3)" 'Output as ST

txt$(2, 1) = "AIRPORTS"                     'Output as MT

txt$(3, 1) = "1) Limited access highways"    'All output as RD
txt$(3, 2) = "2) Principal highways"
txt$(3, 3) = "3) Other through highways"
txt$(3, 4) = "4) Other roads"

txt$(4, 1) = "BOUNDARIES"                    'Output as BD

txt$(5, 1) = "MANMADE FEATURES"              'Output as MS

txt$(6, 1) = "RAILROADS"                     'Output as RR

'Create table of latitude radii to allow conversion of UTM x,y data to LAT/LON
'Data taken from Elements of Cartography - Third Edition - Arthur H. Robinson
'page 377, Table G.3 for latitudes between 20D and 52D

DIM radius(33) AS DOUBLE
FOR i = 0 TO 32
    READ radius(i)
NEXT i

DATA 10253177,10145579,10037540,9929080,9820218,9710969,9601361,9491409
DATA 9381139,9270576,9159738,9048648,8937337,8825827,8714150,8602328
DATA 8490392,8378377,8266312,8154228,8042163,7930152,7818231,7706444
DATA 7594828,7483426,7372288,7261459,7150987,7040925,6931333,6822264
DATA 6713780

'Latitude is calculated from distance of point from North Pole in meters
DEF fnlat (x, y)
    STATIC k
    r1# = SQR(x ^ 2 + (9929080 - y) ^ 2) '9,929,080 meters NP to 23D LAT
    k = 1
    WHILE k <= 32
        IF r1# >= radius(k) THEN
            'table lookup & linear interpoation between degrees of latitude
            fnlat = k + 20 - (r1# - radius(k)) / (radius(k - 1) - radius(k))
            k = 33
        END IF
    k = k + 1
    WEND
END DEF


'Longitude is calculated using formulas given in "Map Projections - A Working
'Manual, USGS Professional Paper 1395, John P. Snyder, 1987"
DEF fnlon (x, y)
    STATIC theta AS DOUBLE
    theta = (57.29577951# * ATN(x / (9929079.6# - y))) / .6029035
    fnlon = 96 - theta
END DEF

SCREEN 9
IF onepass% > 1 THEN
    'IF onepass = 2 THEN tyflag = 4 ELSE tyflag = onepass% + 3
    filecnt% = onepass%
ELSE
    filecnt% = 1
END IF
b% = 0
top:
 id = 0 'Line ID counter
 IF tyflag = 0 THEN
    'Increment TYflag for each loop to make different files for each category
    'Files are named like BA4HYDxx or BA4RDSxx or BA4MTFxx (misc Transprtn)
    'Where the xx are numbers
    Fopre$ = LEFT$(Fopre$, 4)
    CALL gethandles(filecnt%, f$, Fopre$)
END IF
 tyflag = tyflag + 1
 OPEN f$ FOR INPUT AS #3
    LINE INPUT #3, a$   'Throw away first line
    LINE INPUT #3, a$   'Get map name and source date from second line
      unit$ = LEFT$(a$, 40)
      sourcedate$ = MID$(a$, 42, 10)
 PRINT "Corner coordinates:"
 DO WHILE NOT EOF(3)
    LINE INPUT #3, a$    'Look for Quadrant calibration data
    b$ = LEFT$(a$, 2)
    IF b$ = "SW" THEN
       swlat = VAL(MID$(a$, 8, 11))
       swlon = ABS(VAL(MID$(a$, 20, 11)))
       swx = VAL(MID$(a$, 38, 11))
       swy = VAL(MID$(a$, 50, 11))
       PRINT "SW: "; swlat, swlon, swx, swy
    ELSEIF b$ = "NW" THEN
       nwlat = VAL(MID$(a$, 8, 11))
       nwlon = ABS(VAL(MID$(a$, 20, 11)))
       nwx = VAL(MID$(a$, 38, 11))
       nwy = VAL(MID$(a$, 50, 11))
       PRINT "NW: "; nwlat, nwlon, nwx, nwy
    ELSEIF b$ = "NE" THEN
       nelat = VAL(MID$(a$, 8, 11))
       nelon = ABS(VAL(MID$(a$, 20, 11)))
       nex = VAL(MID$(a$, 38, 11))
       ney = VAL(MID$(a$, 50, 11))
       PRINT "NE: "; nelat, nelon, nex, ney
    ELSEIF b$ = "SE" THEN
       selat = VAL(MID$(a$, 8, 11))
       selon = ABS(VAL(MID$(a$, 20, 11)))
       sex = VAL(MID$(a$, 38, 11))
       sey = VAL(MID$(a$, 50, 11))
       PRINT "SE: "; selat, selon, sex, sey
    END IF
    IF b$ = "SE" THEN EXIT DO
 LOOP

 'Determine type of map so proper line type will be extracted.
 tynum = 0' type map files we are reading.
 TY$ = "" ' TYpe file name to be output (WB, ST, CF, or RD)
 PRINT
 PRINT unit$; "  date of source material: "; sourcedate$
 PRINT
 DO WHILE NOT EOF(3)
    LINE INPUT #3, a$
    IF LEFT$(a$, 5) = "HYDRO" THEN
                 tynum = 1: Endflag = 2
                      IF tyflag = 1 THEN TY$ = "WB" ELSE TY$ = "ST"
    END IF
    IF LEFT$(a$, 4) = "PIPE" THEN tynum = 2: Endflag = 1: TY$ = "MT"'AIRPORTS
                      'Named CF to match cultural features in 2,000,000 format
    IF LEFT$(a$, 5) = "ROADS" THEN tynum = 3: Endflag = 4: TY$ = "RD"
    IF LEFT$(a$, 5) = "BOUND" THEN tynum = 4: Endflag = 1: TY$ = "BD"
    IF LEFT$(a$, 5) = "MANMA" THEN tynum = 5: Endflag = 1: TY$ = "MS"
    IF LEFT$(a$, 5) = "RAILR" THEN tynum = 6: Endflag = 1: TY$ = "RR"
    IF LEFT$(a$, 1) = "N" THEN EXIT DO ' Found start of node data
    PRINT LEFT$(a$, 20)
LOOP

convert:

'Calculate longitude error at all four reference corners

    lat = fnlat(nex, ney)
    nelonerr = fnlon(nex, ney) - nelon
    lat = fnlat(sex, sey)
    selonerr = fnlon(sex, sey) - selon
    lat = fnlat(nwx, nwy)
    nwlonerr = fnlon(nwx, nwy) - nwlon
    lat = fnlat(swx, swy)
    swlonerr = fnlon(swx, swy) - swlon

'Calculate correction factors

   baselat = selat: baselon = selon
   londelta = swlon - selon: latdelta = nelat - selat
   westlonvar = swlonerr - nwlonerr
   eastlonvar = selonerr - nelonerr
   basex = sex: basey = sey
  
   PRINT

 gotflag = 0
 IF tynum = 3 THEN num$ = MID$(STR$(tyflag), 2) ELSE num$ = ""
 fo$ = Fopre$ + num$ + TY$ + ".dat"
 OPEN fo$ FOR OUTPUT AS #4
 b% = b% + 1
 PRINT
 PRINT "Now doing "; txt$(tynum, tyflag)
 PRINT "Converting data: "; f$; " --> "; fo$
 PRINT

 PRINT "Skipping NODE data looking for LINE data....";

 DO WHILE NOT EOF(3)
    LINE INPUT #3, a$
    b$ = LEFT$(a$, 1)
    IF b$ = "L" THEN  'We found the start of line segment data
       IF gotflag = 0 THEN
          gotflag = 1: PRINT "GOT IT.  Now doing lines...": PRINT
          PRINT "LineID:#pairs..."
       END IF
       ln% = VAL(MID$(a$, 2, 5))
       linenumb = ln%
       pairs = VAL(MID$(a$, 43, 6))
       attrib = VAL(MID$(a$, 49, 6))
     
          'Get the line with x/y data
          k = 0   'This is the pointer to move through the line of data
          LINE INPUT #3, a$
          FOR i = 1 TO pairs
              k = k + 1
              z = 24 * (k - 1)
              origx(i) = VAL(MID$(a$, z + 2, 12))
              origy(i) = VAL(MID$(a$, z + 14, 12))
              'There is a maximum of 3 pairs of x/y coordinates on a line.
              'If there are more than 3 pairs get another line.
              IF k = 3 AND pairs > i THEN k = 0: LINE INPUT #3, a$
          NEXT i
          
          IF attrib > 0 THEN          'Recover attributes (i.e. road type, etc)
             LINE INPUT #3, a$
             major$ = MID$(a$, 3, 5)
             minor$ = MID$(a$, 10, 4)
             m = VAL(major$)
             n = VAL(minor$)
          ELSE
             major$ = ""
             minor$ = ""
             m = 0
             n = 0
          END IF
         
          doit = 0
          
          IF tynum = 1 THEN     ' Water
             IF tyflag = 1 AND m = 50 AND (n = 200 OR n = 202) THEN doit = 1
             IF tyflag = 1 AND m = 50 AND (n = 605 OR n = 606) THEN doit = 1
             IF tyflag = 2 AND m = 50 AND n = 412 THEN doit = 1
             IF tyflag = 2 AND m = 50 AND (n = 606 OR n = 606) THEN doit = 1
             IF tyflag = 2 AND attrib = 0 THEN doit = 1
          ELSEIF tynum = 2 THEN ' Airports
             IF tyflag = 1 AND m = 190 AND n = 403 THEN doit = 1
          ELSEIF tynum = 3 THEN            'Roads
             IF m = 170 THEN
                IF tyflag = 1 THEN
                   IF n = 201 THEN doit = 1 'Limited access highways
                   IF n = 609 THEN doit = 1 'Toll roads
                ELSEIF tyflag = 2 THEN
                   IF n = 205 THEN doit = 1 'Principal highways
                   IF n = 206 THEN doit = 1 'Bypass routes
                ELSEIF tyflag = 3 THEN
                   IF n = 209 THEN doit = 1 'Other thru highways
                   IF n = 616 THEN doit = 1 'Alternate routes
                   IF n = 617 THEN doit = 1 'Business routes
                   IF n = 622 THEN doit = 1 'Truck routes
                ELSEIF tyflag = 4 THEN
                   IF n = 210 THEN doit = 1 'Other routes
                END IF
             END IF
          ELSEIF tynum = 4 THEN doit = 1               'Boundaries
          ELSEIF tynum = 5 THEN                  'Manmade features
             IF attrib = 0 THEN doit = 1         'Draw lines w/o attributes
          ELSEIF tynum = 6 THEN                  'Railroads
             IF m = 180 AND n = 201 THEN doit = 1
          END IF
          IF doit THEN

          'Check if reversing the order is needed so that the JOIN command
          'in MAPFIX will work. (Checking if last points x/y same as first point
          'in this segment.)
          reverse = 1
          IF id >= 2 THEN
                 IF origx(1) = lastx AND origy(1) = lasty THEN
                    PRINT "*"; : lc = lc + 1
                    FOR i = 1 TO pairs
                        x(i) = origx(i)
                        y(i) = origy(i)
                    NEXT i
                    reverse = 0
                 END IF
          END IF
        
          IF reverse THEN
             'Reverse the order - last set of coordinates becomes first set.
             'Otherwise map segments will not be properly joined.
             FOR i = 0 TO pairs
                 x(i + 1) = origx(pairs - i)
                 y(i + 1) = origy(pairs - i)
             NEXT i
          END IF
        
          'Print header for line
          id = id + 1' Increment the line identifier
          rank = VAL(MID$(minor$, 2, 2))
          firstattrib = VAL(LEFT$(major$, 5))
          submajor = VAL(LEFT$(minor$, 2))
       
          'Convert the 1 to 100,000 scale attributes to those used by 1 to 2,000,000.
          'This is so the highway colors plot correctly.
   IF m = 170 THEN
      IF n = 201 OR n = 609 THEN rank = 1: att$ = " ":
      IF n = 205 OR n = 206 THEN rank = 19: att$ = " ":
      IF n = 209 OR n = 616 OR n = 617 OR n = 622 THEN rank = 23: att$ = " ":
      IF attrib > 1 THEN
         secondm = VAL(MID$(a$, 15, 5))
         minor$ = MID$(a$, 21, 5)
         IF secondm = 172 THEN att$ = "I-"
         IF secondm = 173 THEN att$ = "US"
         IF secondm = 174 THEN att$ = "WA"
      END IF
   END IF
   IF tyflag = 4 THEN rank = 23: att$ = " ":
          PRINT RTRIM$(STR$(linenumb)); ";"; LTRIM$(STR$(pairs)); : lc = lc + 1
          PRINT #4, USING "#######"; id;
          PRINT #4, USING "##"; rank;
          PRINT #4, USING "######"; pairs;
            'PRINT #4, USING "###"; firstattrib;
            'PRINT #4, USING "##"; submajor
          'Following prints Hwy type and number, i.e. US101
          PRINT #4, USING "\\###"; att$; VAL(minor$);

          'Convert from x/y meters to decimal lat/long
         
          FOR i = 1 TO pairs

          'Calculate latitude and longitude of point

              lat = fnlat(x(i), y(i))
              lon = fnlon(x(i), y(i))

          'Calculate corrected longitude

              dlon = lon - baselon
              dlat = lat - baselat
              lonfac = dlon / londelta
              latfac = dlat / latdelta
              wlonerr = (1.5 * westlonvar * latfac - swlonerr) * lonfac
              elonerr = (1.5 * eastlonvar * latfac - selonerr) * (1 - lonfac)
              'lon = lon + (elonerr + wlonerr)

          'Convert decimal lat/long to lat/long in degrees, minutes, and seconds.
             
              latdeg = INT(lat)
              latminf = (lat - latdeg) * 60
              latminint = INT(latminf)
              latsec = CINT((latminf - latminint) * 60)
              IF latsec = 60 THEN
                latsec = 0
                latminint = latminint + 1
              END IF
              IF latminint = 60 THEN
                latminint = 0
                latdeg = latdeg + 1
              END IF
              londeg = INT(lon)
              lonmin = (lon - londeg) * 60
              lonminint = INT(lonmin)
              lonsec = CINT((lonmin - lonminint) * 60)
              IF lonsec = 60 THEN
                lonsec = 0
                lonminint = lonminint + 1
              END IF
              IF lonminint = 60 THEN
                lonminint = 0
                londeg = londeg + 1
              END IF
              PRINT #4, USING "##"; latdeg; : IF latdeg < 30 THEN PRINT "******"; latdeg
              PRINT #4, USING "##"; latminint;
              PRINT #4, USING "##N"; latsec;
              PRINT #4, USING "###"; londeg;
              PRINT #4, USING "##"; lonminint;
              PRINT #4, USING "##W"; lonsec;
              PRINT #4, USING "#####"; i; ' sequence counter (counts up to the number of pairs).
          NEXT i
      
          'Save the last x/y for checking later on
         
          lastx = x(i - 1)
          lasty = y(i - 1)
          END IF' matches doit
    END IF ' This is from the IF statement which checked for an "L"
    LOOP
 CLOSE #3
 CLOSE #4
 PRINT
 PRINT "Finished!  OUTPUT IS IN FILE NAMED: "; fo$
 PRINT
 IF tyflag < Endflag THEN GOTO top
 filecnt% = filecnt% + 1
 IF filecnt% < a% THEN tyflag = 0: GOTO top
 CALL clrunblk(a%, workfldr$, onepass%)

byp:

 CHAIN "NU2MGB30"
 SYSTEM
END

'Put the error routine here
Errorfix:

SUB buildlist (ln%)
'  el% = 1 + ln% \ 16
'  bit = ln% MOD 16
'  SELECT CASE bit
'    CASE 0: bit% = &H1
'    CASE 1: bit% = &H2
'    CASE 2: bit% = &H4
'    CASE 3: bit% = &H8
'    CASE 4: bit% = &H10
'    CASE 5: bit% = &H20
'    CASE 6: bit% = &H40
'    CASE 7: bit% = &H80
'    CASE 8: bit% = &H100
'    CASE 9: bit% = &H200
'    CASE 10: bit% = &H400
'    CASE 11: bit% = &H800
'    CASE 12: bit% = &H1000
'    CASE 13: bit% = &H2000
'    CASE 14: bit% = &H4000
'    CASE 15: bit% = &H8000
'  END SELECT
'  lnel(el%) = lnel(el%) OR bit%
END SUB

SUB checklist (ln%)
'  el% = 1 + ln% \ 16
'  bit = ln% MOD 16
'  ln% = 0
'  SELECT CASE bit
'    CASE 0: IF (lnel(el%) AND &H1) THEN ln% = 1
'    CASE 1: IF (lnel(el%) AND &H2) THEN ln% = 1
'    CASE 2: IF (lnel(el%) AND &H4) THEN ln% = 1
'    CASE 3: IF (lnel(el%) AND &H8) THEN ln% = 1
'    CASE 4: IF (lnel(el%) AND &H10) THEN ln% = 1
'    CASE 5: IF (lnel(el%) AND &H20) THEN ln% = 1
'    CASE 6: IF (lnel(el%) AND &H40) THEN ln% = 1
'    CASE 7: IF (lnel(el%) AND &H80) THEN ln% = 1
'    CASE 8: IF (lnel(el%) AND &H100) THEN ln% = 1
'    CASE 9: IF (lnel(el%) AND &H200) THEN ln% = 1
'    CASE 10: IF (lnel(el%) AND &H400) THEN ln% = 1
'    CASE 11: IF (lnel(el%) AND &H800) THEN ln% = 1
'    CASE 12: IF (lnel(el%) AND &H1000) THEN ln% = 1
'    CASE 13: IF (lnel(el%) AND &H2000) THEN ln% = 1
'    CASE 14: IF (lnel(el%) AND &H4000) THEN ln% = 1
'    CASE 15: IF (lnel(el%) AND &H8000) THEN ln% = 1
'  END SELECT
END SUB

DEFSTR A-Z
SUB clrunblk (a%, workfldr, onepass%)

IF onepass% = 0 THEN
    FOR i% = 1 TO a% - 1
    SELECT CASE i%
    CASE 1: suffix = "rd"
    CASE 2: suffix = "hy"
    CASE 3: suffix = "bd"
    CASE 4: suffix = "ms"
    CASE 5: suffix = "mt"
    CASE 6: suffix = "rr"
    END SELECT
    fo = workfldr + suffix + ".dlg"
    PRINT "Deleting file "; fo; " ...";
    KILL fo
    PRINT "done!"
    NEXT
ELSE
    SELECT CASE onepass%
    CASE 1: suffix = "rd"
    CASE 2: suffix = "hy"
    CASE 3: suffix = "bd"
    CASE 4: suffix = "ms"
    CASE 5: suffix = "mt"
    CASE 6: suffix = "rr"
    END SELECT
    fo = workfldr + suffix + ".dlg"
    PRINT "Deleting file "; fo; " ...";
    KILL fo
    PRINT "done!"
END IF
END SUB

SUB extr (a%, fldr$, workfldr$)
PRINT
PRINT "EXTRACTING CD FILES"
PRINT
FOR i% = 1 TO a% - 1
    IF onepass% THEN i% = onepass%
    SELECT CASE i%
        CASE 1: suffix = "rd"
        CASE 2: suffix = "hy"
        CASE 3: suffix = "bd"
        CASE 4: suffix = "ms"
        CASE 5: suffix = "mt"
        CASE 6: suffix = "rr"
    END SELECT
    fi = fldr + suffix + ".do"
    fo = workfldr + suffix + ".dlg"
    PRINT "Converting "; fi; " --> "; fo; " ...";
    CALL UNBLOCK(fi, fo)
    PRINT "done!"
    IF onepass% THEN i% = a% - 1
NEXT
PRINT
END SUB

SUB gethandles (filecnt%, f$, Fopre$)

SELECT CASE filecnt%
CASE 1: suffix = "rd"
CASE 2: suffix = "hy"
CASE 3: suffix = "bd"
CASE 4: suffix = "ms"
CASE 5: suffix = "mt"
CASE 6: suffix = "rr"
END SELECT
f$ = workfldr + suffix + ".dlg"
Fopre$ = workfldr

END SUB

SUB HELP
DEFSTR A-Z
PRINT "WHAT TO DO WITH THE TooLarge MAP PRODUCED BY THIS PROGRAM:"
PRINT
PRINT "[Note: Current versions of MAPFIX now use 'pull-down menus' to select"
PRINT " various operations rather than alt-xxxx commands mentioned below. All"
PRINT " functions described below CAN be executed with the new MAPFIX. Refer"
PRINT " to the HELP page in MAPFIX to ascertain the appropriate new command.]"
PRINT
PRINT
PRINT "Load MAPFIX and use the alt-JOIN command once.  Next use the alt-SMOOTH command"
PRINT "twice (or so) to remove additional points.  I run alt-SMOOTH twice at 1.1 and"
PRINT "twice at 1.2.  Beyond that, there is the danger of shortcutting long smooth"
PRINT "curves in roads, etc.  Once you get down to about 3500 or so points, the last"
PRINT "500 are best eliminated MANUALLY!  If you cant get below about 3600, then"
PRINT "either re-run MAKEMAP with a smaller area, or use the alt-TRIM command to"
PRINT "trim off excess area outside the alt-RANGE box."

PRINT
PRINT "Hit R to reset the MAP pointer to the first point in the file and zoom into"
PRINT "about the 8 mile range.  Hit the +/- keys to cycle through each and every point"
PRINT "in the map and alt-DELETE any unnecessary points.  Use the (G) GO command"
PRINT "to keep RE-CENTERING the map on the current MAPPOINT or use the Ctrl-A to"
PRINT "toggle on AUTO-CENTERING.  Continue with the + key through the entire map to"
PRINT "be sure you have looked at each and EVERY point.  This may take about an hour"
PRINT "but can get rid of hundreds of unnecessary points!   There are lots of wasted"
PRINT "and duplicate points in the following areas:"
PRINT
PRINT "    COUNTY LINES!  Who cares about the detail crooks and crannies!"
PRINT "    INTERSTATES    Often, BOTH lanes are duplicated and identical!)"
PRINT "    STREAMS        Who cares about every crook and bend..."
PRINT "    RAILROADS      You may want to leave em out, or alt-KILL 'em with MAPFIX"
PRINT
PRINT "Don't stop at exactly 2999 points, however.  Go on down to about 2950 to"
PRINT "leave a little room for adding 'personal' roads later.."
PRINT
PRINT "Use the ctrl-R command during the process to turn off the RE-DRAW function."
PRINT "This makes the alt-DELETE process much faster.  SPACE bar will re-draw"
PRINT "the map and turn RE-DRAW back on.  Similarly, hitting the END key will take"
PRINT "you back to the map center and will toggle off AUTO-CENTERING."
PRINT
PRINT
INPUT "Hit ENTER to continue..."; a$

END SUB

SUB init (mapf$, datf$, fldr$, workfldr$)

REM DIM SHARED lat0!, long0!, latmax!, longmax!, ppdy!, ppdx!
REM DIM SHARED latmin!, longmin!, ALLpts%, Hfac!
CLS
PRINT "INTRODUCTION AND COMMENTS:        "; version$
PRINT
PRINT "This program is a combination of programs originally written by W7KKE,"
PRINT "KB4XF, and WB4APR. It was modified by WA7ZZB to extract APRS map points"
PRINT "directly from the NEW format 1:2MEG CD-ROM. It is a hands-off, total map "
PRINT "making process. It extracts the DLG data from the CD-ROM, unblocks the files,"
PRINT "converts the data to the old 1:2MEG CD-ROM format, and then extracts all"
PRINT "points within a given range of a given lat/long point and saves them in an"
PRINT "APRS compatible file named XXXXX.DAT."
PRINT
PRINT "Then it uses a brute-force reduction technique that scans the total file and"
PRINT "only keeps every Nth point.   As long as N is on the order of 2 or 3, this is"
PRINT "not much of a problem, since the USGS data base has at least 100 points to"
PRINT "the inch at the original map scale.  The map is then saved as XXXXX.MAP."
PRINT
PRINT "To minimize this truncation, WB4APR modifed this program to permit "
PRINT "twice the nominal 3000 limit during the first reduction process.  By also"
PRINT "limiting the initial number of points by choosing a smaller area (30 miles"
PRINT "or so (in the East) the result is a quite adequate map which can then be"
PRINT "loaded into MAPFIX where you may then use the more intelligent MAPFIX"
PRINT "alt-SMOOTH command and other techniques to eliminate more points down to the"
PRINT "nominal 3000 point limit."
PRINT
INPUT "Hit ENTER to proceed... OR hit H for more HELP"; a$
WIDTH 80, 43
PALETTE 6, 6

IF UCASE$(a$) = "H" THEN CALL HELP
CLS
workfhdr$ = ""
PRINT "Enter pathname to an existing directory for temporary working"
INPUT "files if other than present directory (e.g., C:\MAPMAKIN\DLG\) "; workfldr
IF RIGHT$(workfldr, 1) <> "\" THEN workfldr = workfldr + "\"
r = workfldr + "work_tst.tmp"

' test to see if valid path

OPEN r FOR OUTPUT AS #3
IF Fault% = 75 THEN
        PRINT "** UNABLE TO OPEN TEMPORARY WORKING FILE **"
        CLOSE
        STOP
END IF
CLOSE #3: KILL r
PRINT
PRINT "The Digital Line Graph CD is divided into the following states."
PRINT
PRINT " AL - AR - AZ - CA - CO - CT - DE - FL - GA - HI"
PRINT " IA - ID - IL - IN - KS - KY - LA - MA - MD - ME"
PRINT " MI - MN - MO - MS - MT - NC - ND - NE - NH - NJ"
PRINT " NM - NV - NY - OH - OK - OR - PA - RI - SC - SD"
PRINT " TN - TX - UT - VA - VT - WA - WI - WV - WY"
PRINT
PRINT : INPUT "Enter state "; sectc$
PRINT
PRINT : INPUT "Enter letter designation for CD ROM drive ", d$
sectc$ = RIGHT$(sectc$, 2)
fldr = LEFT$(d$, 1) + ":\data\dlg\" + sectc$ + "\" + sectc$ + "2mil"
workfldr = workfldr + sectc$ + "2M"
PRINT
PRINT "File name leader is "; fldr
PRINT "Working files leader is "; workfldr
PRINT : INPUT "Enter a file name for results (.map) will be added "; mapf
PRINT : INPUT "Enter latitude of map center in degrees,minutes (DD,MM) "; lat0!, latm!
PRINT : INPUT "Enter longitude of map center in degrees,minutes (DDD,MM) "; long0!, longm!
lat0! = lat0! + latm! / 60
long0! = long0! + longm! / 60
PRINT
PRINT "Now select the map size.  In order to get about the right number of points"
PRINT "Select 30 to 36 miles for anywhere East of the Mississippi.  Maybe 50 miles"
PRINT "in the rural farm areas, and possibly 70 miles in the VERY sparse states."
PRINT
PRINT "You may go larger to get a larger map, and then spend lots more time using"
PRINT "MAPFIX to remove un-needed points."
PRINT : INPUT "Enter map radius in miles ", mradm!
PRINT : INPUT "Skip every other point in the Waterways and Borders (y/n) (Y)"; a$
IF UCASE$(a$) <> "N" THEN ALLpts% = 0 ELSE ALLpts% = -1
datf = mapf + ".dat"
mapf = mapf + ".map"
rady! = mradm! / 60
radx! = 4 * mradm! / (COS(3.1416 * lat0! / 180) * 3 * 60)' Screen aspect ratio
latmax! = lat0! + rady!
latmin! = lat0! - rady!
longmax! = long0! + radx!
longmin! = long0! - radx!
ppdy! = INT(.5 + (525! / (rady!))) 'had been 350/(2*rady)  I just made it 3X
ppdx! = INT(.5 + (960! / (radx!))) 'had been 640/(2*radx)
Hfac! = ppdx! / ppdy!
OPEN datf FOR OUTPUT AS #2
PRINT #2, USING "###.####_,"; latmax!
PRINT #2, USING "###.####_,"; longmax!
PRINT #2, USING "#####.##_,"; ppdy!
PRINT #2, USING "###.####_,"; lat0!
PRINT #2, USING "###.####_,"; long0!
PRINT #2, USING "###.####_,"; mradm!
PRINT #2, "0,resrved"
PRINT #2, "comments "

END SUB

DEFSNG A-Z
SUB UNBLOCK (fi$, fo$)

DIM a AS STRING * 80

OPEN fi$ FOR RANDOM ACCESS READ AS #1 LEN = 80
OPEN fo$ FOR OUTPUT ACCESS WRITE AS #3

x = 1

DO
   GET #1, x, a$
   y = 1
   IF LEN(a$) = 0 GOTO agn2:
agn1:
   p = INSTR(y, a$, CHR$(10))
   IF p <> 0 THEN
      PRINT #3, MID$(a$, y, p - y)
      c = c + p - y
      y = p + 1
      IF y > 80 GOTO agn2 ELSE GOTO agn1:
   ELSE
         PRINT #3, MID$(a$, y, 81 - y);
   END IF
agn2:
x = x + 1
LOOP UNTIL EOF(1)
CLOSE #1, #3
END SUB

