' NU2MGB30.BAS - NU2MEGB ver. 3.0 11/22/96 - Ted Antanaitis WA7ZZB

' NU2MGA30.BAS and NU2MGB30.BAS are two chained QBasic programs which extract
' geographic data from the USGS 1:2,000,000 Scale Optional Format CDrom
' mastered 7/95 and create APRS compatible maps. Both programs must reside in
' the same directory and be the same version (3.0).
' To run, type: qbasic/run nu2mga30, at the DOS prompt.

DECLARE SUB fbook (finx%, f AS STRING, fldr AS STRING, bcolor%, suffix AS STRING)
DECLARE SUB test (rcno&, rstop&, testflg%, finx%, attrb%)
DECLARE SUB redraw (cmaxrec&, datf AS STRING)

DEFSTR A-Z

COMMON SHARED lat0!, long0!, latmax!, longmax!, ppdy!, ppdx!, mapf$, datf$, b%
COMMON SHARED latmin!, longmin!, version$, ALLpts%, Hfac!, fldr$, workfldr$
COMMON SHARED starttime$, onepass%

SCREEN 9
npts& = 1
finx% = 1
nseg% = 0
oldx! = 999
oldy! = 999
CLS
ON ERROR GOTO Errortrap
IF onepass% > 0 THEN
  IF onepass% = 1 THEN
     finx% = 1
     b% = 4
  ELSEIF onepass% = 2 THEN
     finx% = 5
     b% = 6
  ELSE
     finx% = onepass% + 4
     b% = finx% + 1
  END IF
END IF
WHILE finx% < b% + 1
Again: Fault% = 0
  CALL fbook(finx%, f, workfldr, bcolor%, suffix)
  OPEN f FOR RANDOM AS #1 LEN = 20
  IF Fault% = 75 THEN finx% = finx% + 1: GOTO Again
  labnr% = 0
  minrec% = 1000
  maxrec% = 0
  rcno& = 1
  startflg% = -1
  tstart = TIME$
  FIELD #1, 7 AS lno, 2 AS atc, 6 AS np, 5 AS att
  DO WHILE NOT EOF(1)
    LOCATE 1, 1
    PRINT suffix; rcno&
    GET 1, rcno&
    nrec% = VAL(np)
    aatc% = VAL(atc)
    aatt% = VAL(att) - 29000
    IF aatt% < 0 THEN aatt% = 0
    attrb% = 100 * aatt% + aatc%
    rstop& = rcno& + nrec%
    rcno& = rcno& + 1
    FIELD #1, 2 AS lad, 2 AS lam, 3 AS las, 3 AS lod, 2 AS lom, 2 AS los, 6 AS d$
    CALL test(rcno&, rstop&, testflg%, finx%, attrb%)
    LOCATE 1, 1
    PRINT SPACE$(12);
    IF testflg% THEN
      IF nrec% < minrec% AND nrec% <> 0 THEN minrec% = nrec%
      IF nrec% > maxrec% THEN maxrec% = nrec%
      DO WHILE rcno& <= rstop&
        GET 1, rcno&
        alat! = VAL(lad) + VAL(lam) / 60 + VAL(las) / 3600
        along! = VAL(lod) + VAL(lom) / 60 + VAL(los) / 3600
        REM Test to see if this point is on map
        LOCATE 1, 1
        REM PRINT alat!; along!; aatc%;
        OK% = 0
        IF (alat! <= latmax!) AND (alat! >= latmin!) THEN
           IF (along! <= longmax!) AND (along! >= longmin!) THEN
              OK% = -1
           END IF
        END IF
        IF OK% THEN
           x! = INT(.5 + (longmax! - along!) * ppdy!): IF x! = 0 THEN x! = 1
           y! = INT(.5 + (latmax! - alat!) * ppdy!)
         ' Test for continuation of last line segment
           IF (x! = oldx!) AND (oldy! = y!) THEN startflg% = 0
           oldx! = x!
           oldy! = y!
           npts& = npts& + 1
           IF startflg% THEN
              icolor% = bcolor%
              IF finx% = 1 THEN
                 SELECT CASE aatc%
                 CASE 1 TO 13: icolor% = 10
                 REM CASE 2 OR 6: icolor% = 12
                 CASE 14 TO 19: icolor% = 12
                 CASE 20 TO 23: icolor% = 4
                 CASE ELSE: icolor% = 7
                 END SELECT
              END IF
              IF finx% = 3 THEN
                 IF attrb% = 3095 THEN icolor% = 9' Intercoastal waterway
              END IF
              PSET (x! * Hfac! / 3, y! / 3), icolor%
              PRINT #2, "   0,   0"
              labnr% = labnr% + 1
              lab = LEFT$(suffix, 1) + LTRIM$(STR$(labnr%))
              PRINT #2, USING "##_,\    \"; icolor%; lab
              PRINT #2, USING "####_,####"; x!; y!
              ix% = INT(Hfac! * 80 * x! / (3 * 640)) + 1
              iy% = INT(43 * y! / (3 * 350)) + 1
              IF ix% > 75 THEN ix% = 75
              IF iy% > 43 THEN iy% = 43
              LOCATE iy%, ix%
              PRINT lab;
              nseg% = nseg% + 1
              startflg% = 0
           ELSE
              IF ALLpts% THEN
                 SkipPT% = 0
              ELSEIF suffix = "st" OR suffix = "wb" OR suffix = "pb" OR suffix = "ab" THEN
                 SkipPT% = NOT SkipPT%
              ELSE SkipPT% = 0
              END IF
              IF NOT SkipPT% THEN 'Skip every other point for WB,ST,AB and PB
                 LINE -(x! * Hfac! / 3, y! / 3), icolor%
                 PRINT #2, USING "####_,####"; x!; y!
              ELSE npts& = npts& - 1
              END IF
           END IF
        ELSE
           startflg% = -1
        END IF
        rcno& = rcno& + 1
      LOOP
      startflg% = -1
    ELSE
      rcno& = rstop& + 1
    END IF
  LOOP
  tstop = TIME$
  PRINT tstart; " "; tstop; minrec%; maxrec%
  finx% = finx% + 1
  cmaxrec& = LOF(2) \ 11
  CLOSE 1
  CLOSE 2
  LOCATE 1, 1
  PRINT "make notes for manual deletion/merge. Hit key to continue";
  REM DO WHILE INKEY$ = "": LOOP
  CALL redraw(cmaxrec&, datf)
  OPEN datf FOR APPEND AS #2
WEND
CLOSE 1
REM  Map extraction complete now thin map to reduce number of pts to 6000
Thin% = INT(npts& \ (6000 - 2 * nseg% - 7)) + 1
LOCATE 1, 1: PRINT "Total points:"; npts&
LOCATE 1, 22: PRINT "You will have to keep every"; Thin%; "rd point to stay under 5000..."
IF Thin% > 2 THEN
   Thin% = 2
   LOCATE 2, 1: PRINT "This is greater than 2 and may round off too many points.  You may select a"
   INPUT "this number or use the default factor of 2.  Divide points by how many (2)"; Thin$
   IF Thin$ <> "" THEN Thin% = VAL(Thin$) ELSE Thin% = 2
   PRINT "Final # of pts will be"; npts& / Thin%
END IF
nrecm& = LOF(2) \ 11
CLOSE 2
' re-open as a random file
OPEN datf FOR RANDOM AS #2 LEN = 11
OPEN mapf FOR RANDOM AS #1 LEN = 11
FIELD 1, 11 AS stuff
FIELD 2, 11 AS instuff
'copy first seven lines to output file
FOR I% = 1 TO 8 'was 7
    GET 2, I%
    LSET stuff = instuff
    PUT 1, I%
NEXT I%
xtest% = 0
rstart& = 8 'was 7
DO WHILE rstart& < nrecm&
   WHILE NOT xtest%
      GET 2, rstart&
      rstart& = rstart& + 1
      IF (LEFT$(instuff, 9) = "   0,   0") THEN xtest% = -1
      IF rstart& > nrecm& THEN
         xtest% = -1
         rstart& = nrecm&
      END IF
   WEND
   xtest% = 0
   rstop& = rstart&
   WHILE NOT xtest%
      rstop& = rstop& + 1
      GET 2, rstop& + 1
      IF (LEFT$(instuff, 9) = "   0,   0") THEN xtest% = -1
      IF rstop& > nrecm& THEN
         rstop& = nrecm&
         xtest% = -1
      END IF
   WEND
   'Copy every thin(t)h record from input to output file
   'If line segment has less than n points then skip,
   ' but making sure first and last points the same
   ' for both long and short segment
   N% = (rstop& - rstart&) / Thin% + 1
   rcno& = rstart&
   IF N% > 2 THEN   'Forget short segments
      LSET stuff = "   0,   0" + CHR$(&HD) + CHR$(&HA)
      PUT 1
      GET 2, rcno&
      LSET stuff = instuff 'Color and segment label
      PUT 1
      rcno& = rcno& + 1
      wflg% = -1
      DO WHILE wflg%
         IF rcno& < rstop& THEN
            GET 2, rcno&
            LSET stuff = instuff
            PUT 1
         ELSE
            GET 2, rstop&
            LSET stuff = instuff
            PUT 1
            wflg% = 0
         END IF
         x% = VAL(instuff)
         y% = VAL(MID$(instuff, 6, 4))
         PRESET (x% * Hfac! / 3, y% / 3), 15
         rcno& = rcno& + Thin%
      LOOP
   END IF
   rcno& = rstop& + 1
   rstart& = rcno&
   xtest% = 0
LOOP
CLOSE
endtime$ = TIME$
LOCATE 43, 1: INPUT "Map is complete... Hit ENTER to continue..."; a$
CLS
PRINT : PRINT
PRINT "Now your completed map is in file: "; mapf
PRINT : PRINT
PRINT "Map conversion starting time: "; starttime$
PRINT "             completion time: "; endtime$
PRINT
a$ = "N"
INPUT "Make another MAP? (Y/N) [N]"; a$
IF (a$ = "Y" OR a$ = "y") THEN CHAIN "NU2MGA30"
PRINT : PRINT
'CALL HELP
SYSTEM

Errortrap: Fault% = ERR
           IF ERR = 75 THEN RESUME NEXT
END

DEFSNG A-Z

DEFSTR A-Z
SUB fbook (finx%, f, workfldr, bcolor%, suffix)
SELECT CASE finx%
CASE 1: suffix = "1rd": bcolor% = 10
CASE 2: suffix = "2rd": bcolor% = 12
CASE 3: suffix = "3rd": bcolor% = 4
CASE 4: suffix = "4rd": bcolor% = 7
CASE 5: suffix = "wb": bcolor% = 11
CASE 6: suffix = "st": bcolor% = 3
CASE 7: suffix = "bd": bcolor% = 6
CASE 8: suffix = "ms": bcolor% = 2
CASE 9: suffix = "mt": bcolor% = 9
CASE 10: suffix = "rr": bcolor% = 8
END SELECT
f = workfldr + suffix + ".dat"
END SUB

SUB redraw (cmaxrec&, datf) STATIC
nrec& = 8
CLS
OPEN datf FOR RANDOM AS #2 LEN = 11
FIELD 2, 11 AS stuff
WHILE nrec& < cmaxrec&
GET 2, nrec&
  IF stuff = "   0,   0" + CHR$(&HD) + CHR$(&HA) THEN
     GET 2, nrec& + 1
     clr% = VAL(stuff)
     nrec& = nrec& + 2
     GET 2, nrec&
     x% = VAL(stuff)
     y% = VAL(RIGHT$(stuff, 6)) 'had been 5
     PSET (x% * Hfac! / 3, y% / 3), clr%
     nrec& = nrec& + 1
  ELSE
     x% = VAL(stuff)
     y% = VAL(RIGHT$(stuff, 6)) 'had been 5
     LINE -(x% * Hfac! / 3, y% / 3), clr%
     nrec& = nrec& + 1
   END IF
WEND
CLOSE 2
LOCATE 1, 58: PRINT "CD pts so far:"; cmaxrec&
END SUB

SUB test (rcno&, rstop&, testflg%, finx%, attrb%)
'COMMON SHARED lat0!, long0!, latmax!, longmax!, ppdy!, ppdx!
'COMMON SHARED latmin!, longmin!
' Test last point to see if it is on map
FIELD #1, 2 AS lad, 2 AS lam, 3 AS las, 3 AS lod, 2 AS lom, 2 AS los, 6 AS d$
GET 1, rstop&
alat! = VAL(lad) + VAL(lam) / 60 + VAL(las) / 3600
along! = VAL(lod) + VAL(lom) / 60 + VAL(los) / 3600
testflg% = 0
IF (alat! <= latmax!) AND (alat! >= latmin!) THEN
  IF (along! <= longmax!) AND (along! >= longmin!) THEN
     testflg% = -1
  END IF
END IF
' Test midpoint to see if it falls on the map
recmid& = (rstop& + rcno&) \ 2
GET 1, recmid&
alat! = VAL(lad) + VAL(lam) / 60 + VAL(las) / 3600
along! = VAL(lod) + VAL(lom) / 60 + VAL(los) / 3600
IF (alat! <= latmax!) AND (alat! >= latmin!) THEN
  IF (along! <= longmax!) AND (along! >= longmin!) THEN
     testflg% = -1
  END IF
END IF
' Test first point to see if it is  on map
GET 1, rcno&
alat! = VAL(lad) + VAL(lam) / 60 + VAL(las) / 3600
along! = VAL(lod) + VAL(lom) / 60 + VAL(los) / 3600
IF (alat! <= latmax!) AND (alat! >= latmin!) THEN
  IF (along! <= longmax!) AND (along! >= longmin!) THEN
     testflg% = -1
  END IF
END IF
'This limits stream data to eliminate small lakes
' and river centerlines
IF finx% = 2 THEN
  IF attrb% = 3002 THEN testflg% = 0
  IF attrb% > 3030 AND attr% < 3070 THEN testflg% = 0
  REM IF attrb% = 3095 THEN testflg% = 0' Intercoastal waterway
END IF

END SUB

