
#include <stdio.h>
/*
#define DEBUG
*/
int parity30,parity29;
char bufr[80];
char flip[64]={
	0,32,16,48,8,40,24,56,4,36,20,52,12,44,28,60,
	2,34,18,50,10,42,26,58,6,38,22,54,14,46,30,62,
	1,33,17,49,9,41,25,57,5,37,21,53,13,45,29,61,
	3,35,19,51,11,43,27,59,7,39,23,55,15,47,31,63
};

unsigned long getnextword(FILE *);
unsigned long extractbits(unsigned long *, int);
int doparity(unsigned long);

main(int argc,char *argv[]) {
	int i,j,k,nwords,sf,prchi;
	unsigned long word, work;
	signed char a;
	FILE *fp;
	float prc,prcc;

	fp=fopen(argv[1],"rb");
	if(fp==NULL) {puts("READ FILE OPEN ERROR");exit(1);}
	parity29=0;parity30=0;
	while(!feof(fp)) {
	   i=getc(fp);
	   if(i != 0x66 && i!= 0x59) continue; /* look for sync byte */
	   if(i==0x59) {
	      if(parity30!=1) puts("Parity recalc");
	      parity30=1;  /* word must be inverted */
	   }
	   puts("\nfound sync byte");
	   ungetc(i,fp); /* push back char to input */
/*
	FIRST WORD OF HEADER
*/
	   word=getnextword(fp);
	   j=doparity(word);
	   k=word & 0x3f;
	   if(j != k) {
	      parity29=1;
	      puts("Parity recalc");
	      j=doparity(word);
	   }
	   if(j != k) puts("PARITY ERROR");
	   extractbits(&word,2);
	   i=extractbits(&word,8);
	   printf("Header byte is %02X\n",i);
	   if(i!=0x66) {puts("BAD HEADER");continue;}
	   i=extractbits(&word,6);
	   printf("Record Type is %d\n",i);
	   i=extractbits(&word,10);
	   printf("Station ID is %d\n",i);
	   i=extractbits(&word,6);
#ifdef DEBUG
	   printf("Parity Byte is %02X\n",i);
#endif
	   parity30=i&1;
	   parity29=(i & 2)>>1;
/*
	SECOND WORD OF HEADER
*/
	   word=getnextword(fp);
	   j=doparity(word);
	   k=word & 0x3f;
	   if(j != k) puts("PARITY ERROR");
	   extractbits(&word,2);
	   i=extractbits(&word,13);
	   printf("Z-Count is %f\n",i*0.6);
	   i=extractbits(&word,3);
	   printf("Sequence Number %d\n",i);
	   i=extractbits(&word,5);
	   printf("Word Count %d\n",i);
	   nwords=i;
	   i=extractbits(&word,3);
	   printf("Health bits %d\n",i);
	   i=extractbits(&word,6);
#ifdef DEBUG
	   printf("Parity Byte is %02X\n",i);
#endif
	   parity30=i&1;
	   parity29=(i & 2)>>1;
/*
	NOW PROCESS THE DATA RECORDS
*/
loop:
/*
	WORD 3, 8, 13
*/
	   if(nwords-- <= 0) continue;
	   word=getnextword(fp);
	   j=doparity(word);
	   k=word & 0x3f;
	   if(j != k) puts("PARITY ERROR");
	   extractbits(&word,2);
	   sf=extractbits(&word,1);
#ifdef DEBUG
	   printf("\nScale Factor is %d",sf);
#endif
	   j=extractbits(&word,2);
	   i=extractbits(&word,5);
	   printf("Sat ID %d",i);
	   printf("  UDRE %d",j);
	   i=extractbits(&word,16);
	   prc=i*0.02;if(sf) prc=i*0.32;
	   printf("  PRC  %f M",prc);
	   i=extractbits(&word,6);
#ifdef DEBUG
	   printf("Parity Byte is %02X\n",i);
#endif
	   parity30=i&1;
	   parity29=(i & 2)>>1;
/*
	WORD 4, 9, 14
*/
	   if(nwords-- <= 0) continue;
	   word=getnextword(fp);
	   j=doparity(word);
	   k=word & 0x3f;
	   if(j != k) puts("PARITY ERROR");
	   extractbits(&word,2);
	   a=extractbits(&word,8);
	   prcc = a * 0.002; if(sf) prcc = a * 0.032;
	   printf("  PRCC = %f m/sec",prcc);
	   i=extractbits(&word,8);
	   printf("  IODE  %d\n",i);
	   sf=extractbits(&word,1);
#ifdef DEBUG
	   printf("\nScale Factor is %d\n",sf);
#endif
	   j=extractbits(&word,2);
	   i=extractbits(&word,5);
	   printf("\nSat ID %d",i);
	   printf("  UDRE %d",j);
	   i=extractbits(&word,6);
#ifdef DEBUG
	   printf("Parity Byte is %02X\n",i);
#endif
	   parity30=i&1;
	   parity29=(i & 2)>>1;

/*
	WORD 5, 10, 15
*/
	   if(nwords-- <= 0) continue;
	   word=getnextword(fp);
	   j=doparity(word);
	   k=word & 0x3f;
	   if(j != k) puts("PARITY ERROR");
	   extractbits(&word,2);
	   i=extractbits(&word,16);
	   prc=i*0.02;if(sf) prc=i*0.32;
	   printf("  PRC  %f M",prc);
	   a=extractbits(&word,8);
	   prcc = a * 0.002; if(sf) prcc = a * 0.032;
	   printf("  PRCC = %f m/sec",prcc);
	   i=extractbits(&word,6);
#ifdef DEBUG
	   printf("Parity Byte is %02X\n",i);
#endif
	   parity30=i&1;
	   parity29=(i & 2)>>1;

/*
	WORD 6, 11, 16
*/
	   if(nwords-- <= 0) continue;
	   word=getnextword(fp);
	   j=doparity(word);
	   k=word & 0x3f;
	   if(j != k) puts("PARITY ERROR");
	   extractbits(&word,2);
	   i=extractbits(&word,8);
	   printf("  IODE  %d\n",i);
	   sf=extractbits(&word,1);
#ifdef DEBUG
	   printf("\nScale Factor is %d\n",sf);
#endif
	   j=extractbits(&word,2);
	   i=extractbits(&word,5);
	   printf("Sat ID %d",i);
	   printf("  UDRE %d",j);
	   prchi=extractbits(&word,8);
	   i=extractbits(&word,6);
#ifdef DEBUG
	   printf("Parity Byte is %02X\n",i);
#endif
	   parity30=i&1;
	   parity29=(i & 2)>>1;

/*
	WORD 7, 12, 17
*/
	   if(nwords-- <= 0) continue;
	   word=getnextword(fp);
	   j=doparity(word);
	   k=word & 0x3f;
	   if(j != k) puts("PARITY ERROR");
	   extractbits(&word,2);
	   i=extractbits(&word,8);
	   i |= (prchi<<8);
	   prc=i*0.02;if(sf) prc=i*0.32;
	   printf("  PRC  %f M",prc);
	   a=extractbits(&word,8);
	   prcc = a * 0.002; if(sf) prcc = a * 0.032;
	   printf("  PRCC = %f m/sec",prcc);
	   i=extractbits(&word,8);
	   printf("  IODE  %d\n",i);
	   i=extractbits(&word,6);
#ifdef DEBUG
	   printf("Parity Byte is %02X\n",i);
#endif
	   parity30=i&1;
	   parity29=(i & 2)>>1;

	   goto loop;



	}
}

unsigned long getnextword(FILE *fp) {
	int i,j,k;
	unsigned long work;

again:
	work=0;
	for(k=0;k<5;++k) {
	   i=getc(fp);
	   j=(i & 0xC0) >> 6;  /*  data word has 01 in upper bits */
	   if(j != 1) goto again;
#ifdef DEBUG
	   printf("READ DATA BYTE = %02X",i);
#endif
	   i = flip[i & 0x3f];
#ifdef DEBUG
	   printf("   BITS FLIPPED = %02X\n",i);
#endif
	   work <<= 6; work |= i; /* reverse bit order */
	}
	if(parity30) work ^= 0x3fffffc0L; /* flip bits */
#ifdef DEBUG
	printf("getnextword  %08lX  \n",work);
#endif
	return(work);
}

unsigned long extractbits(unsigned long *word, int bits) {
	int i,j,k;
	unsigned long work;

	work=0;
	for(k=0;k<bits;++k) {
	   work <<= 1;
	   if(*word & 0X80000000L) work |= 1;
	   *word <<= 1;
	}
	return(work);
}

int doparity(unsigned long word) {
	int d25,d26,d27,d28,d29,d30;
	int parity;

	d25=d26=d27=d28=d29=d30=0;
	d25= parity29 ^ getbit(word,0) ^ getbit(word,1) ^ getbit(word,2) ^
	     getbit(word,4) ^ getbit(word,5) ^ getbit(word,9) ^ getbit(word,10) ^
	     getbit(word,11) ^ getbit(word,12) ^ getbit(word,13) ^ getbit(word,16) ^
	     getbit(word,17) ^ getbit(word,19) ^ getbit(word,22);
	d26= parity30 ^ getbit(word,1) ^ getbit(word,2) ^ getbit(word,3) ^
	     getbit(word,5) ^ getbit(word,6) ^ getbit(word,10) ^ getbit(word,11) ^
	     getbit(word,12) ^ getbit(word,13) ^ getbit(word,14) ^ getbit(word,17) ^
	     getbit(word,18) ^ getbit(word,20) ^ getbit(word,23);
	d27= parity29 ^ getbit(word,0) ^ getbit(word,2) ^ getbit(word,3) ^
	     getbit(word,4) ^ getbit(word,6) ^ getbit(word,7) ^ getbit(word,11) ^
	     getbit(word,12) ^ getbit(word,13) ^ getbit(word,14) ^ getbit(word,15) ^
	     getbit(word,18) ^ getbit(word,19) ^ getbit(word,21);
	d28= parity30 ^ getbit(word,1) ^ getbit(word,3) ^ getbit(word,4) ^
	     getbit(word,5) ^ getbit(word,7) ^ getbit(word,8) ^ getbit(word,12) ^
	     getbit(word,13) ^ getbit(word,14) ^ getbit(word,15) ^ getbit(word,16) ^
	     getbit(word,19) ^ getbit(word,20) ^ getbit(word,22);
	d29= parity30 ^ getbit(word,0) ^ getbit(word,2) ^ getbit(word,4) ^
	     getbit(word,5) ^ getbit(word,6) ^ getbit(word,8) ^ getbit(word,9) ^
	     getbit(word,13) ^ getbit(word,14) ^ getbit(word,15) ^ getbit(word,16) ^
	     getbit(word,17) ^ getbit(word,20) ^ getbit(word,21) ^ getbit(word,23);
	d30= parity29 ^ getbit(word,2) ^ getbit(word,4) ^ getbit(word,5) ^
	     getbit(word,7) ^ getbit(word,8) ^ getbit(word,9) ^ getbit(word,10) ^
	     getbit(word,12) ^ getbit(word,14) ^ getbit(word,18) ^ getbit(word,21) ^
	     getbit(word,22) ^ getbit(word,23);
	parity=(((((((((d25<<1)+d26)<<1)+d27)<<1)+d28)<<1)+d29)<<1)+d30;
#ifdef DEBUG
	printf("CALC PARITY IS %02X\n",parity);
#endif
	return(parity);
}

getbit(unsigned long word,int bit) {
	int i;
	i = (word>>(29-bit)) & 1;
	return(i);
}