#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Approximate Air Coil Inductance Calculator, airind.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $turns = $FORM{'turns'};

my $dia = $FORM{'dia'};
my $dia_val = $FORM{'dia_val'};

my $len = $FORM{'len'};
my $len_val = $FORM{'len_val'};

# Clean up user input data
#
$turns =~ tr/0-9.//csd;

if (!$turns) {
  $turns = 3; # 3 turns
}

$dia =~ tr/0-9.//csd;

if (!$dia) {
  $dia = 5; $dia_val = "millimeters"; # 5 millimeters diameter
}

$len =~ tr/0-9.//csd;

if (!$len) {
  $len = 10; $len_val = "millimeters"; # 10 milliemeters long
}

# Start calculations
#

# Diameter
#
if ($dia_val eq "inches") {
  $dia = $dia * 25.4; # in to mm
}
elsif ($dia_val eq "centimeters") {
  $dia = $dia * 10; # cm to mm
}

# Length
#
if ($len_val eq "inches") {
  $len = $len * 25.4; # in to mm
}
elsif ($len_val eq "centimeters") {
  $len = $len * 10; # cm to mm
}

$ind = 0.001 * $dia * ($turns ** 2) / ( $len / $dia + 0.44 );

$ind_ex = 0.000628 * $dia * ($turns ** 2) * (log(1 + 1.57 * $dia / $len) + 1 / (2.3 + 3.2 * $len / $dia + 1.76 * (($len / $dia) ** 2)));

# Make all pretty
#
$turns = sprintf "%.1f", $turns;

$dia_in = sprintf "%.3f", $dia / 25.4;
$dia = sprintf "%.3f", $dia;

$len_in = sprintf "%.3f", $len / 25.4;
$len = sprintf "%.3f", $len;

$ind_uh = sprintf "%.6f", $ind;
$ind_ex_uh = sprintf "%.6f", $ind_ex;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Approximate Air Coil Inductance Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Approximate Air Coil Inductance Calculator Results</h2>

<p><em>The results are valid only for one layer, tightly wound, air core coils without gaps between the turns.</em></p></center>

<hr noshade>
<pre>
  $b Number of coil turns : $e$turns
           $b Coil length : $e$dia$b mm ($e$dia_in$b inches) $e
         $b Coil diameter : $e$len$b mm ($e$len_in$b inches) $e
<br>
  $p Approximate inductance : $e$ind_uh$p &micro;H $e
$p 0.1% accurate inductance : $e$ind_ex_uh$p &micro;H $e
<br>
</pre>

<hr noshade size="5">

<blockquote>
<p><b><u>Methods of Increasing Inductor Q</u></b></p>

<ul>
<li>Use a larger diameter wire.&nbsp;&nbsp;This decreases the AC and DC resistance of the windings.</li>

<li>Spread the windings apart.&nbsp;&nbsp;Air has a lower dielectric constant than most insulators.&nbsp;&nbsp;Thus, an air gap between the windings decreases the interwinding capacitance.</li>

<li>Increase the permeability of the flux linkage path.&nbsp;&nbsp;This is most often done by winding the inductor around a magnetic core material, such as iron or ferrite.&nbsp;&nbsp;A coil made in this manner will also consist of fewer turns for a given inductance.</li>
</ul>
</blockquote>

<p><a href="http://www.datasync.com/~ignatz/electro/teslacoil/wirechart.html">Dimensions, Weight and Resistance of Solid Round Copper Wire</a></p>

<table width="100%" border="1">
<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>Size<br>AWG</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>Diamater (inches)<br>bare wire</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>TPI<br>Turns per inch</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>Area Circular<br> <u>mils</u></strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>LBS per<br>1000 FT</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>FT per<br> LB</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>OHMS PER<br> 1000 FT</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>OHMS PER<br> pound</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>18</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0403</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>24.81389</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1620</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>4.916</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>203.40</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>6.386</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1.299</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>19</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0359</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>27.85515</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1290</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>3.901</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>256.30</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>8.047</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>2.063</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>20</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0320</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>31.25000</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1020</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>3.100</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>322.60</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>10.13</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>3.268</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>21</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0285</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>35.08771</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>812</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>2.459</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>406.70</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>12.77</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>5.193</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>22</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0253</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>39.52569</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>640</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1.938</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>516.10</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>16.20</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>8.363</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>23</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0226</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>44.24778</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>511</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1.546</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>646.80</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>20.31</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1313</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>24</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0201</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>49.75124</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>404</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1.223</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>817.70</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>25.67</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>20.99</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>25</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0179</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>55.86592</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>320</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.9699</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1031</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>32.37</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>33.37</strong></font></center><td>

</tr>
<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>26</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0159</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>62.89308</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>253</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.7652</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1307</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>41.02</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>53.61</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>27</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0142</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>70.42253</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>202</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.6104</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>1638</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>51.44</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>84.27</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>28</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0126</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>79.36507</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>159</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.4806</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>2081</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>65.33</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>135.90</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>29</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0113</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>88.49557</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>128</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.3865</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>2587</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>81.22</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>210.10</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>30</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0100</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>100.0000</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>100</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.3027</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>3304</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>103.7</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>342.60</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>31</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0089</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>112.3595</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>79.2</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.2398</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>4171</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>130.90</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>546.1</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>32</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0080</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>125.0000</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>64.0</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.1937</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>5162</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>162.10</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>836.50</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>33</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0071</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>140.8450</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong>50.40</font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong>.5126</font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong>6553</font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong>205.70</font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong>1348</font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong>34</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.0063</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>158.7301</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>39.7</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>.1201</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>8324</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>216.3</strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong>21.75</strong></font></center><td>
</tr>

<tr>
<td><center><font face="arial" size="2" color="#000000"><strong></strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong></font></center><td>
<td><center><font face="arial" size="2" color="#000000"><strong></strong></font></center><td>
</tr>
</table>

<font face="arial" size="2" color="#000000"><em>Resistance values based on copper of 100% conductivity at 68 deg F (20 deg C) reference: NEMA standerds MW 100, tables 1-1, 1-2 and 1-3</em></font>


<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
