#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## -->  Pi & Tee Network Resistive Attenuation Calculator, att_pad.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;
$pic = "pics/att_pad.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $att = $FORM{'att'};

my $imp = $FORM{'imp'};

# Clean up user input data
#
$att =~ tr/0-9.//csd;

if (!$att) {
  $att = 3; # 3 dB
}

$imp =~ tr/0-9.//csd;

if (!$imp) {
  $imp = 50; # 50 ohms
}

# Start calculations
#

# Pi style
#
$pi_r1 = ($imp * ((10 ** ($att / 20)) + 1)) / (1 - (10 ** ($att / 20)));
$pi_r1 = abs $pi_r1;

$pi_r2 = ((((2 * $imp) ** 2) * $pi_r1) / (($pi_r1 ** 2) - ($imp ** 2))) / 2;

# T style
#
$t_r1 = ($imp * ((10 ** ($att / 20)) - 1)) / ((10 ** ($att / 20)) + 1);
$t_r2 = (($imp ** 2) - ($t_r1 ** 2)) / (2 * $t_r1);

# Make all pretty
#
$imp = sprintf "%.3f", $imp;

$att = sprintf "%.3f", $att;

$pi_r1 = sprintf "%.3f", $pi_r1;
$pi_r2 = sprintf "%.3f", $pi_r2;

$t_r1 = sprintf "%.3f", $t_r1;
$t_r2 = sprintf "%.3f", $t_r2;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Pi &amp; Tee Network Resistive Attenuation Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Pi &amp; Tee Network Resistive  Attenuation Calculator Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[att pad]"></center>

<pre>
           $b Attenuation : $e$att$b dB $e
$b Input/output impedance : $e$imp$b ohms $e
<br>
           $p Pi style R1 : $e$pi_r1$p ohms $e
           $p Pi style R2 : $e$pi_r2$p ohms $e
<br>
          $p Tee style R1 : $e$t_r1$p ohms $e
	  $p Tee style R2 : $e$t_r2$p ohms $e
</pre>

<hr noshade size="5">

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
