#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Master Lock Combination Calculator, master.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $third = $FORM{'third'};

# Clean up user input data
#
$third =~ tr/0-9.//csd;

if (!$third || $third > 40) {
  $third = 25;
}

# Start calculations
#

sub bynumber { $a <=> $b }

$i = $third;

while ($i <= 40 && $i >= 1) {
  push (@array, $i); 
  $i = $i - 4;
}  

$i = $third;

while ($i <= 40 && $i >= 1) {
  $i = $i + 4;
  if ($i <= 40 && $i >= 1) {
    push (@array, $i); 
  }  
}  

@sorted = sort bynumber @array;

# Draw me a web page
#

print "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 3.2//EN\">".
      "<html>".
      "<head>".
      "<title>Master Lock Combination Calculator Results</title>".
      "</head>".
      "<body bgcolor=\"#D3D3D3\" text=\"#000000\" link=\"blue\">".
      "<center>".
      "<h2>Master Lock Combination Calculator Results</h2>".
      "</center>".
      "<hr noshade>".
      "<p><b><u>Possible Combination To Try</u></b></p>".
      "<pre>";

@first = @sorted;
for (@sorted){
  push(@second, abs($_ - 2));
};

$k=1;
for $x (@first){
  for $y (@second){
    printf ("%3s:&nbsp;&nbsp;<b>%2s&nbsp;&nbsp;%2s&nbsp;&nbsp;%2s</b><br>", $k, $x, $y, $third);
    $k++;
  }
}
print "</pre>".
      "<p><u>Example combinations</u></p>".
      "<pre>".
      "10 24 18<br>".
      "13  3 25<br>".
      "12 30 20<br>".
      "</pre>".
      "</body>".
      "</html>";
