#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> RF Pi Network Designer, pinet.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;
$pic = "pics/pinet.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $rs = $FORM{'rs'};

my $rl = $FORM{'rl'};

my $q = $FORM{'q'};

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

# Clean up user input data
#
$rs =~ tr/0-9.//csd;

if (!$rs) {
  $rs = 50; # 50 ohms
}

$rl =~ tr/0-9.//csd;

if (!$rl) {
  $rl = 300; # 300 ohms
} 

$q =~ tr/0-9.//csd;

if (!$q) {
  $q = 5; # low Q
} 

$frq =~ tr/0-9.//csd;
$frq_val =~ tr/a-zA-Z//csd;

if (!$frq) {
  $frq = 146; $frq_val = "MHz"; # 146 MHz
}

# Start calculations
#

# Frequncy
#
if ($frq_val eq "kHz") {
  $frq = $frq / 1000; # khz to mhz
}

# Start calculations
#
$k = sqrt ($rl / $rs);
$C1 = (159000 * $k * $q) / (($k + 1) * $frq * $rl);
$C2 = $k * $C1; 
$L1 = (25300 * ($C1 + $C2)) / ($C1 * $C2 * ($frq ** 2));

# Make all pretty
#
$q = sprintf "%.3f", $q;
$rs = sprintf "%.3f", $rs;
$rl = sprintf "%.3f", $rl;

$frq = sprintf "%s", $frq;

$c1pf = sprintf "%.4f", $C1;
$c2pf = sprintf "%.4f", $C2;

$l1uh = sprintf "%.4f", $L1;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>RF Pi Network Designer Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>RF Pi Network Designer Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[pinet]"></center>

<pre>
   $b Source impedance : $e$rs$b ohms $e
     $b Load impedance : $e$rl$b ohms $e
$b Operating frequency : $e$frq$b MHz $e
<br>
          $p Circuit Q : $e$q
                 $p L1 : $e$l1uh$p &micro;H $e
                 $p C1 : $e$c1pf$p pF $e
                 $p C2 : $e$c2pf$p pF $e
</pre>

<hr noshade size="5">

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
