#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> PLL 3rd Order Passive Loop Filter Calculator, pll_filter.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2002 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $pic = "pics/pll_filter.png";
my $form = "./pll_filter.cgi";

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>PLL 3rd Order Passive Loop Filter Calculator</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<font face="Verdana, Arial, Helvetica">
<center>
<h2><u>PLL 3rd Order Passive Loop Filter Calculator</u></h2>

<p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p>

<hr noshade>
<img src="$pic" alt="[pll_filter]">
</center>

<hr noshade>
<form action="$form" method="post">
<table border="0">

<tr>
<td><b>Maximum output frequency from the VCO&nbsp;&nbsp;</b>
<input type="text" name="frq" size="10" value="">
<select name="frq_val">
<option selected>MHz</option>
<option>GHz</option>
</select></td>
</tr>

<tr>
<td><b>Desired bandwidth of the PLL&nbsp;&nbsp;</b>
<input type="text" name="loop" size="10" value="">
<select name="loop_val">
<option selected>Hz</option>
<option>kHz</option>
</select></td>
</tr>

<tr>
<td><b>Reference frequency of the loop&nbsp;&nbsp;</b>
<input type="text" name="ref" size="10" value="">
<select name="ref_val">
<option selected>Hz</option>
<option>kHz</option>
</select></td>
</tr>

<tr>
<td><b>Desired phase margin of the PLL (30 - 70)&nbsp;&nbsp;</b>
<input type="text" name="phase" size="4" value="45">&nbsp;&nbsp;degrees
</td>
</tr>

<tr>
<td><b>VCO tuning voltage constant&nbsp;&nbsp;</b>
<input type="text" name="vco_tune" size="5" value="">&nbsp;&nbsp;MHz/Volt
</td>
</tr>

<tr>
<td><b>Phase detector/charge pump constant&nbsp;&nbsp;</b>
<input type="text" name="pump" size="4" value="4">&nbsp;&nbsp;mA/2*pi*rad
</td>
</tr>

<tr>
<td><b>Desired attenuation from the low pass filter&nbsp;&nbsp;</b>
<input type="text" name="att" size="4" value="20">&nbsp;&nbsp;dB
</td>
</tr>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">

<blockquote>
<em>Experimental, based on application notes and equations from <a href="http://www.intersil.com">Intersil</a> and <a href="http://www.national.com">National</a>.</em>
</blockquote>
</font>
</body>
</html>
EOF
