#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Voltage to Power Conversion Calculator, voltage.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $imp = $FORM{'imp'};

my $volt = $FORM{'volt'};
my $volt_val = $FORM{'volt_val'};

# Clean up user input data
#
$imp =~ tr/0-9.//csd;

if (!$imp) {
  $imp = 50; # 50 ohms
}

$volt =~ tr/0-9.-//csd;
$volt_val =~ tr/a-zA-Z-//csd;

if (!$volt) {
  $volt = 7; $volt_val = "RMS"; # 7 volts RMS
}

# Start calculations
#

# Reflector diameter
#
if ($volt_val eq "Peak") {
  $vrms = $volt * (1 / sqrt 2); # peak to RMS
}
elsif ($volt_val eq "Peak-to-Peak") {
  $vrms = $volt * (1 / (2 * sqrt 2)); # peak-to-peak to RMS
}
elsif ($volt_val eq "Average") {
  $vrms = $volt * (pi / (2 * (sqrt 2))); # average to RMS
}
else {
  $vrms = $volt; # RMS to RMS
}

# Volts Peak-to-Peak
#
$vpp = $vrms * (2 * (sqrt 2));

# Volts Average
#
$av = $vrms * (2 * (sqrt 2) / pi);

# Volts Peak
#
$vp = $vrms * sqrt 2;

# dBmV
#
$dbmv = 20 * (log10 ($vrms / 0.001));

# Watts
#
$pwr = ($vrms ** 2) / $imp;

# dBm
#
$dbm = 10 * (log10 ($pwr / 0.001));

# Make all pretty
#
$imp = sprintf "%.3f", $imp;

$vrms = sprintf "%.6f", $vrms;
$vpp = sprintf "%.6f", $vpp;
$vp = sprintf "%.6f", $vp;
$av = sprintf "%.6f", $av;
$dbmv = sprintf "%.6f", $dbmv;
$pwr = sprintf "%.6f", $pwr;
$dbm = sprintf "%.6f", $dbm;

$date = scalar gmtime;

# Draw me a web page
#
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Voltage to Power Conversion Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Voltage to Power Conversion Calculator Results</h2>
</center>

<hr noshade>
<pre>
           $p Impedance : $e$imp$p ohms $e
<br>
         $p Voltage RMS : $e$vrms$p Vrms $e
$p Voltage peak-to-peak : $e$vpp$p Vp-p $e
        $p Voltage peak : $e$vp$p Vp $e
     $p Voltage average : $e$av$p Vav $e
<br>
       $p dB millivolts : $e$dbmv$p dBmV $e
               $p Power : $e$pwr$p Watts $e
       $p dB milliwatts : $e$dbm$p dBm $e
</pre>

<hr noshade size="5">

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
