#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Lumped Component Wilkinson Splitter / Combiner Designer, wilk.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;
$pic = "pics/wilk.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $imp = $FORM{'imp'};

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

# Clean up user input data
#
$imp =~ tr/0-9.//csd;

if (!$imp) {
  $imp = 50; # 50 ohms
}

$frq =~ tr/0-9.//csd;
$frq_val =~ tr/a-zA-Z//csd;

if (!$frq) {
  $frq = 146; $frq_val = "MHz"; # 146 MHz
}

# Start calculations
#

# Frequncy
#
if ($frq_val =~ /mhz/i) {
  $frq = $frq * 1000000; # mhz to hz
}
elsif ($frq_val =~ /khz/i) {
  $frq = $frq * 1000; # khz to hz
}

# Start calculations
#
$xc1 = $imp / sqrt 2;
$xl = $xc2 = (sqrt 2) * $imp;

$c1 = 1 / (2 * pi * $frq * $xc1);
$c2 = 1 / (2 * pi * $frq * $xc2);
$l = $xl / (2 * pi * $frq);

# Make all pretty
#
$r = sprintf "%.3f", $imp * 2;

$imp = sprintf "%.3f", $imp;

$c1pf = sprintf "%.4f", $c1 * 1000000000000;
$c1uf = sprintf "%.6f", $c1 * 1000000;
$c2pf = sprintf "%.4f", $c2 * 1000000000000;
$c2uf = sprintf "%.6f", $c2 * 1000000;

$luh = sprintf "%.4f", $l * 1000000;
$lnh = sprintf "%.4f", $l * 1000000000;

$frq_khz = sprintf "%.3f", $frq / 1000;
$frq_mhz = sprintf "%.3f", $frq / 1000000;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Lumped Component Wilkinson Splitter / Combiner Designer Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Lumped Component Wilkinson Splitter / Combiner Designer Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[wilkinson]"></center>

<pre>
$b Input/output impedance : $e$imp$b ohms $e
   $b Operating frequency : $e$frq_mhz$b MHz ($e$frq_khz$b kHz) $e
<br>
                     $p R : $e$r$p ohms $e
		     $p L : $e$luh$p &micro;H ($e$lnh$p nH) $e
                    $p C1 : $e$c1pf$p pF ($e$c1uf$p &micro;F) $e
                    $p C2 : $e$c2pf$p pF ($e$c2uf$p &micro;F) $e
</pre>

<hr noshade size="5">

<blockquote>
This design is not recommended for high frequency (&gt; 400 MHz) use.
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
