#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Knife Edge Diffraction Loss Calculator, knife.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

my $pic = "pics/knife_edge.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

my $ht = $FORM{'height'};
my $ht_val = $FORM{'height_val'};

my $a_dis = $FORM{'a_dis'};
my $a_dis_val = $FORM{'a_dis_val'};

# Clean up user input data
#
$frq =~ tr/0-9.//csd;
$frq_val =~ tr/a-zA-Z//csd;

if (!$frq) {
  $frq = 2450; $frq_val = "MHz"; # 2450 MHz
}

$ht =~ tr/0-9//csd;
$ht_val =~ tr/a-zA-Z//csd;

if (!$ht) {
  $ht = 500; $ht_val = "meters" # 500 meters
}

$a_dis =~ tr/0-9.//csd;
$a_dis_val =~ tr/a-z//csd;

if (!$a_dis) {
  $a_dis = 10; $a_dis_val = "kilometers"; # 10 kilometers
}

# Site A distance in kilometers
#
if ($a_dis_val =~ /miles/i) {
  $a_dis = $a_dis * 1.609344; # mi to km
}

# Frequency in MHz
#
if ($frq_val =~ /ghz/i) {
  $frq = $frq * 1000; # GHz to MHz
}

# Knife edge height in meters
#
if ($ht_val =~ /feet/i) {
  $ht = $ht * 0.3048; # ft to m
}

# Start calculations
#
$db = (20 * log10 (($ht * (sqrt ($frq / $a_dis))))) - 38.8;

# Make all pretty
#
$db = sprintf "%.3f", $db;

$frq = sprintf "%.3f", $frq;

$a_dis_mi = sprintf "%.3f", $a_dis * 0.62137119;
$a_dis = sprintf "%.3f", $a_dis;

$ht_ft = sprintf "%.3f", $ht * 3.2808399;
$ht = sprintf "%.3f", $ht;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Knife Edge Diffraction Loss Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Knife Edge Diffraction Loss Calculator Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[knife edge]"></center>

<hr noshade>
<pre>
        $b Operating frequency : $e$frq$b MHz $e
       $b Distance from site A : $e$a_dis$b kilometers ($e$a_dis_mi$b miles) $e
    $b Elevation of knife edge : $e$ht$b meters ($e$ht_ft$b feet) $e
</pre>

<pre>
$p Knife edge diffraction loss : $e$db$p dB $e
</pre>

<hr noshade size="5">

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
