#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Antenna Tilt Calculator, tilt.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
select STDOUT;
$| = 1;

my $pic = "pics/tilt.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $ht_a = $FORM{'ht_a'};
my $ht_a_val = $FORM{'ht_a_val'};
my $elv_a = $FORM{'elv_a'};
my $elv_a_val = $FORM{'elv_a_val'};

my $ht_b = $FORM{'ht_b'};
my $ht_b_val = $FORM{'ht_b_val'};
my $elv_b = $FORM{'elv_b'};
my $elv_b_val = $FORM{'elv_b_val'};

my $dis = $FORM{'dis'};
my $dis_val = $FORM{'dis_val'};

my $k = $FORM{'k'};

# Clean up user input data
#
$ht_a =~ tr/0-9.//csd;
$ht_a_val =~ tr/a-z//csd;
$elv_a =~ tr/0-9.//csd;
$elv_a_val =~ tr/a-z//csd;

if (!$ht_a) {
  $ht_a = 8; $ht_a_val = "meters"; # 8 meters high
}

if (!$elv_a) {
  $elv_a = 100; $elv_a_val = "meters"; # 100 meters above sea level
}

$ht_b =~ tr/0-9.//csd;
$ht_b_val =~ tr/a-z//csd;
$elv_b =~ tr/0-9.//csd;
$elv_b_val =~ tr/a-z//csd;

if (!$ht_b) {
  $ht_b = 15; $ht_b_val = "meters"; # 15 meters high
}

if (!$elv_b) {
  $elv_b = 100; $elv_b_val = "meters"; # 100 meters above sea level
}

$dis =~ tr/0-9.//csd;
$dis_val =~ tr/a-z//csd;

if (!$dis) {
  $dis = 2; $dis_val = "kilometers"; # 2 km
}

$k =~ tr/0-9.//csd;

if (!$k) {
  $k = 1.33; # K factor (effective Earth radius)
}

# Start calculations
#

# Antenna / ground elevation heights
#
if ($ht_a_val =~ /meters/i) {
  $ht_a = $ht_a * 3.2808399; # m to ft
}

if ($elv_a_val =~ /meters/i) {
  $elv_a = $elv_a * 3.2808399; # m to ft
}

$total_a = $ht_a + $elv_a; # antenna height plus ground elevation

if ($ht_b_val =~ /meters/i) {
  $ht_b = $ht_b * 3.2808399; # m to ft
}

if ($elv_b_val =~ /meters/i) {
  $elv_b = $elv_b * 3.2808399; # m to ft
}

$total_b = $ht_b + $elv_b; # antenna height plus ground elevation

# Distance
#
if ($dis_val =~ /kilometers/i) {
  $dis = $dis * 0.62137119; # km to mi
}
elsif ($dis_val =~ /^meters/i) {
  $dis = $dis / 1609.344; # m to mi
}
elsif ($dis_val =~ /feet/i) {
  $dis = $dis / 5280; # ft to mi
}

$tilt_ab = 57.2957795 * (($total_b - $total_a) / (5280 * $dis) - ($dis / (7290 * $k)));
$tilt_ba = 57.2957795 * (($total_a - $total_b) / (5280 * $dis) - ($dis / (7290 * $k)));

($tilt_ab =~ m/^-/) ? ($dir_ab = "downward") : ($dir_ab = "upward");
($tilt_ba =~ m/^-/) ? ($dir_ba = "downward") : ($dir_ba = "upward");

# Make all pretty
#
$ht_a_m = sprintf "%.3f", $ht_a * 0.3048;
$ht_a = sprintf "%.3f", $ht_a;
$ht_b_m = sprintf "%.3f", $ht_b * 0.3048;
$ht_b = sprintf "%.3f", $ht_b;

$elv_a_m = sprintf "%.3f", $elv_a * 0.3048;
$elv_a = sprintf "%.3f", $elv_a;
$elv_b_m = sprintf "%.3f", $elv_b * 0.3048;
$elv_b = sprintf "%.3f", $elv_b;

$total_a_m = sprintf "%.3f", $total_a * 0.3048;
$total_a = sprintf "%.3f", $total_a;
$total_b_m = sprintf "%.3f", $total_b * 0.3048;
$total_b = sprintf "%.3f", $total_b;

$tilt_ab_r = sprintf "%.3f", $tilt_ab / 57.29578;
$tilt_ab = sprintf "%.3f", $tilt_ab;
$tilt_ba_r = sprintf "%.3f", $tilt_ba / 57.29578;
$tilt_ba = sprintf "%.3f", $tilt_ba;

$dis_km = sprintf "%.3f", $dis * 1.609344;
$dis = sprintf "%.3f", $dis;

$k = sprintf "%.3f", $k;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Antenna Tilt Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center><h2>Antenna Tilt Calculator Results</h2></center>

<hr noshade>
<center><img src="$pic" alt="[tilt]"></center>

<hr noshade>
<pre>
   $b Height of antenna A (AGL) : $e$ht_a_m$b meters ($e$ht_a$b feet) $e
$b Ground elevation at A (AMSL) : $e$elv_a_m$b meters ($e$elv_a$b feet) $e
   $b Antenna A total elevation : $e$total_a_m$b meters ($e$total_a$b feet) $e
<br>
   $b Height of antenna B (AGL) : $e$ht_b_m$b meters ($e$ht_b$b feet) $e
$b Ground elevation at A (AMSL) : $e$elv_b_m$b meters ($e$elv_b$b feet) $e
   $b Antenna B total elevation : $e$total_b_m$b meters ($e$total_b$b feet) $e
<br>
                    $b K factor : $e$k
         $b Total path distance : $e$dis_km$b kilometers ($e$dis$b miles) $e
</pre>

<pre>
         $p Antenna A to B tilt : $e$tilt_ab$p degrees ($e$tilt_ab_r$p radians) ($e$dir_ab$p tilt) $e
         $p Antenna B to A tilt : $e$tilt_ba$p degrees ($e$tilt_ba_r$p radians) ($e$dir_ba$p tilt) $e
</pre>

<hr noshade size="5">

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
