{---------------------------------------------------------------------------}
{                PSA super duper 250 Hz CW filter	                    }
{      Demo software accompanying the QEX xxx   1994 article:		    }
{      "Using a Programmable PC Sound Card for Amateur Radio"               }
{                  (c) Johan Forrer, KC7WW				    }
{		     26553 Priceview Drive                                  }
{                    Monroe, OR 97456					    }
{---------------------------------------------------------------------------}
{									    }
{               Assembly instructions:                                      }  
{		----------------------					    }
{                 >spasm21 cw250.dsp	      		                    }
{									    }
{ ------------------------------------------------------------------------- }

{   DSP hardware addresses used by user's application                       }
.const dmal_1848	=0x3060;
.const dmar_1848	=0x3068;

{ Note: delay lines use circular addressing                                 }
{         9- 16 requires a " 16=0x0010" boundary                            }
{ length 17- 32 requires a " 32=0x0020" boundary                            }
{        33- 64 requires a " 64=0x0040" boundary                            }
{        65-128 requires a "128=0x0080" boundary                            }
{       129-256 requires a "256=0x0100" boundary                            }
 
{ Define space for the FIR bandpass filter delay line			    }
.const BPFI		=0x3800;	{ 3800 ->  Input bandpass 	    }

.const bpf_out		=0x3900;	{ Ouput of FIR filter               }
{---------------------------------------------------------------------------}
{ This is the user's DSP application code. It's part of the AD1848 ISR      }
{ It should be kept as efficient as possible.                               }
{---------------------------------------------------------------------------}
0x0100  sound_prt:
	ena sec_reg;			{ use alternate registers }
	
{ The way we have the audio jack connected, only the left line              }
{ channel will carry a signal. 						    }
{ Input data is saved in a circular buffer.                                 }

	ar=dm(bpf_out);			{ pick up oldest value }
	dm(dmal_1848)=ar;
	dm(dmar_1848)=ar;		{ this also resets interrupt }

	ar=dm(dmal_1848);		{ using only left input channel }
	dm(i1,m1)=ar;
	ar=dm(dmar_1848);		{ read right input but discard it }

	call bandpass;			{ call bandpass routine }

	dis sec_reg;			{ use normal registers }
	rti;

{--FIR FILTER---------------------------------------------------------------}
{ 									    }
{ This FIR filter was designed using the window method. The window used     }
{ was a KAISER-BESSEL type, filter length is 127 taps.                      }						    
{ Sampling frequency is          5512.500 Hz				    }
{ Lower cut-off frequency is      375.000 Hz				    }
{ Upper cut-off frequency is      525.000 Hz				    }
{ -------------------------Filter coefficients----------------------------- }
dc:	0xFFFD00; {    -3}
	0xFFF900; {    -7}
	0xFFF700; {    -9}
	0xFFF600; {   -10}
	0xFFFA00; {    -6}
	0x000200; {     2}
	0x000D00; {    13}
	0x001800; {    24}
	0x001F00; {    31}
	0x001E00; {    30}
	0x001300; {    19}
	0xFFFF00; {    -1}
	0xFFE600; {   -26}
	0xFFD100; {   -47}
	0xFFC600; {   -58}
	0xFFCA00; {   -54}
	0xFFDF00; {   -33}
	0xFFFE00; {    -2}
	0x001F00; {    31}
	0x003700; {    55}
	0x004000; {    64}
	0x003600; {    54}
	0x001F00; {    31}
	0x000400; {     4}
	0xFFF200; {   -14}
	0xFFEF00; {   -17}
	0xFFFB00; {    -5}
	0x000E00; {    14}
	0x001800; {    24}
	0x000A00; {    10}
	0xFFE000; {   -32}
	0xFF9F00; {   -97}
	0xFF5F00; {  -161}
	0xFF3D00; {  -195}
	0xFF5800; {  -168}
	0xFFBE00; {   -66}
	0x006400; {   100}
	0x012300; {   291}
	0x01C000; {   448}
	0x01FB00; {   507}
	0x01A700; {   423}
	0x00BA00; {   186}
	0xFF5F00; {  -161}      
	0xFDEB00; {  -533}      
	0xFCCC00; {  -820}      
	0xFC6900; {  -919}      
	0xFD0000; {  -768}      
	0xFE8B00; {  -373}      
	0x00B800; {   184}
	0x02F900; {   761}
	0x04AA00; {  1194}
	0x053E00; {  1342}
	0x046F00; {  1135}
	0x025500; {   597}
	0xFF6D00; {  -147}
	0xFC7800; {  -904}
	0xFA4700; { -1465}
	0xF98100; { -1663}
	0xFA6E00; { -1426}
	0xFCDF00; {  -801}
	0x003800; {    56}
	0x039600; {   918}
	0x060F00; {  1551}
	0x06F700; {  1783}
	0x060F00; {  1551}
	0x039600; {   918}
	0x003800; {    56}
	0xFCDF00; {  -801}
	0xFA6E00; { -1426}
	0xF98100; { -1663}
	0xFA4700; { -1465}
	0xFC7800; {  -904}
	0xFF6D00; {  -147}
	0x025500; {   597}
	0x046F00; {  1135}
	0x053E00; {  1342}
	0x04AA00; {  1194}
	0x02F900; {   761}
	0x00B800; {   184}
	0xFE8B00; {  -373}
	0xFD0000; {  -768}
	0xFC6900; {  -919}
	0xFCCC00; {  -820}
	0xFDEB00; {  -533}
	0xFF5F00; {  -161}
	0x00BA00; {   186}
	0x01A700; {   423}
	0x01FB00; {   507}
	0x01C000; {   448}
	0x012300; {   291}
	0x006400; {   100}
	0xFFBE00; {   -66}
	0xFF5800; {  -168}
	0xFF3D00; {  -195}
        0xFF5F00; {  -161}
	0xFF9F00; {   -97}
	0xFFE000; {   -32}
	0x000A00; {    10}
	0x001800; {    24}
	0x000E00; {    14}
	0xFFFB00; {    -5}
	0xFFEF00; {   -17}
	0xFFF200; {   -14}
	0x000400; {     4}
	0x001F00; {    31}
	0x003600; {    54}
	0x004000; {    64}
	0x003700; {    55}
	0x001F00; {    31}
	0xFFFE00; {    -2}
	0xFFDF00; {   -33}
	0xFFCA00; {   -54}
	0xFFC600; {   -58}
	0xFFD100; {   -47}
	0xFFE600; {   -26}
	0xFFFF00; {    -1}
	0x001300; {    19}
	0x001E00; {    30}
	0x001F00; {    31}
	0x001800; {    24}
	0x000D00; {    13}
	0x000200; {     2}
	0xFFFA00; {    -6}
	0xFFF600; {   -10}
	0xFFF700; {    -9}
	0xFFF900; {    -7}
	0xFFFD00; {    -3}
{ --------------------------------------------------------------------------}
bandpass:	  
	i4=dc;				{ point to coefficients }
	mr=0, mx0=dm(i1,m1), my0=pm(i4,m5);
	cntr=126;			{ length - 1 }
	do sopbp until ce;
sopbp:	mr=mr+mx0*my0(ss), mx0=dm(i1,m1), my0=pm(i4,m5);
	mr=mr+mx0*my0(rnd);
	if mv sat mr;
	dm(bpf_out)=mr1;
	rts;
{ --------------END OF USER APPLICATION-------------------------------------}
