//
//AGWMONITOR.CPP @ SV2AGW 2000
//
#include <winsock2.h>
#include <windows.h>
#include "monitordsktp.h"
#include "agwmonitor.h"
#include "constant.h"
#include "agwwin.h"
/*
This is an example program that may help you deal with agwpe TCPIP interface
It is a program that displays monitoring frames
It is written quite dirty, but such a way that is easy for anyone to understand it.
You can compile it using (probably) any compiler (Borland,Microsoft).

Have in mind that interesting stuff is in the file monitorsocket.
All other files have not many remarks.


*/


char IniFile[MAX_PATH];
HWND InitApplication(HINSTANCE hInstance, int cmdShow);

//**********      CODE     **********************

int WINAPI WinMain    (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
HWND MainWin;
       MainWin=InitApplication(hInst,cmdShow);
       if (!MainWin)
        {
          OutputDebugString("INI FAILED");
            return FALSE;               // Exits if unable to initialize
        }

        //construct the path for the ini file
        GetCurrentDirectory(MAX_PATH,IniFile);lstrcat(IniFile,"\\AGWMON.INI");

        PostMessage(MainWin,INITIALIZE,0,0);

        // The main message loop
        MSG  msg;
        int status;
        while ((status = ::GetMessage (&msg, 0, 0, 0)) != 0)
        {
            if (status == -1)
              {
               WSACleanup();
                return -1;
              }

            ::TranslateMessage (&msg);
            ::DispatchMessage (&msg);
        }
       WSACleanup();
       return msg.wParam;

    return 0;
}
//******************************************************************************
// main window Procedure
LRESULT CALLBACK MainWndProc
    (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
int x;
    // Pointer to Controller is stored in Window
            HINSTANCE hi=0;
    MonitorDsktp  * pCtrl = (MonitorDsktp *)( GetWindowLong(hwnd,GWL_USERDATA));
    switch (message)
    {
    case WM_CREATE:
              if (pCtrl) break;
            OutputDebugString("MAINWNDPROC->WMCREATE" );
            hi=(HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE	);
            if (hi==0) OutputDebugString("HINSTANCE FAILED");
            pCtrl = new MonitorDsktp  (hwnd,
                                      "AGWmonitor",
                                      hi
                                      );
            SetWindowLong(hwnd,GWL_USERDATA, (long) pCtrl);
                   pCtrl->SetupWindow (hwnd);
        return 0;
    case WM_COMMAND:
        					 x=pCtrl->Command (LOWORD (wParam));
                     if (!x) return(0);
                     break;
        case WM_VSCROLL:
                       OutputDebugString("WMVSCROLL");

            				pCtrl->Terminal->ScrollTTYVert( hwnd, LOWORD( wParam ), HIWORD( wParam ) ) ;
    							return 0L;
        case WM_HSCROLL:
                       OutputDebugString("WMHSCROLL");
            				pCtrl->Terminal->ScrollTTYHorz( hwnd, LOWORD( wParam ), HIWORD( wParam ) ) ;
    							return 0L;
        case WM_SIZE:
                       OutputDebugString("WMSIZE");
            				pCtrl->Terminal->SizeTTY(hwnd, LOWORD(lParam), HIWORD(lParam));
    							break;;
        case WM_PAINT:
                       OutputDebugString("WMPAINT");
            				pCtrl->Terminal->PaintTTY(hwnd);
    							return 0L;
        case WM_SETFOCUS:
                       OutputDebugString("WMSETFOCUS");
             				pCtrl->Terminal->SetTTYFocus( hwnd ) ;
    							return 0L;
        case WM_KILLFOCUS:
                       OutputDebugString("WMKILLFOCUS");
            				pCtrl->Terminal->KillTTYFocus( hwnd ) ;
             				return 0L;
        case WM_MOUSEACTIVATE:
                       OutputDebugString("WMMOUSE");
            				pCtrl->Terminal->SetTTYFocus(hwnd);
            				return MA_ACTIVATE;


           case WM_DESTROY:
				            SetWindowLong(hwnd,GWL_USERDATA, 0);
					        delete pCtrl;
				        PostQuitMessage(0);
				        return 0;
    }

 return ::DefWindowProc (hwnd, message, wParam, lParam);
}
//*****************************************************************************
HWND InitApplication(HINSTANCE hInstance, int cmdShow)
{

//Register classes and crate the main window
	WORD wVersionRequested = 2;
	WSADATA wsaData;
	int nRet;

    HWND    hwnd=NULL; // Main window handle.

    WNDCLASSEX wc;




    wc.cbSize        = sizeof(wc);
	wc.hIconSm       = LoadImage(hInstance,		// Load small icon image
	                             "AGWMONITOR",
	                             IMAGE_ICON,
	                             16, 16,
	                             0);
    wc.style         = CS_HREDRAW | CS_VREDRAW; // Class style(s).
    wc.lpfnWndProc   = (WNDPROC)MainWndProc;        // Window Procedure
    wc.cbClsExtra    = 0;                       // No per-class extra data.
    wc.cbWndExtra    = 0;                       // No per-window extra data.
    wc.hInstance     = hInstance;               // Owner of this class
    wc.hIcon         = LoadIcon(hInstance, "AGWMONITOR"); // Icon name from .RC
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW); // Cursor
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1); // Default color
    wc.lpszMenuName  = "AGWMONITOR";               // Menu name from .RC
    wc.lpszClassName = "AGWmonitor";               // Name to register as

    // Register the window class and return FALSE if unsuccesful.

    if (!RegisterClassEx(&wc))
    {
        if (!RegisterClass((LPWNDCLASS)&wc.style))
           return hwnd;
    }
    //

//start winsock library
	nRet = WSAStartup(wVersionRequested, &wsaData);
	if (nRet)
	{
		OutputDebugString("NO WINSOCK LIBRARY!");
		WSACleanup();
		return(hwnd);
	}

	//
	// Check WinSock version
	//
	if (wsaData.wVersion != wVersionRequested)
	{
		OutputDebugString("WinSock version not supported");
		WSACleanup();
		return(hwnd);
	}




    // Create a main window for this application instance.
    hwnd = CreateWindow("AGWmonitor",           // See RegisterClass() call.
                        "AGWMonitor",             // Text for window title bar.
                        WS_OVERLAPPEDWINDOW, // Window style.
                        CW_USEDEFAULT, 0,    // Use default positioning
                        CW_USEDEFAULT, 0,    // Use default size
                        NULL,                // Overlapped has no parent.
                        NULL,                // Use the window class menu.
                        hInstance,           
                        NULL);               

    // If window could not be created, return "failure"
    if (!hwnd)        return hwnd;
OutputDebugString("OK INIT");
    //
    // **TODO** Call module specific instance initialization functions here.
    //

    // Make the window visible; update its client area; and return "success"
    ShowWindow(hwnd, cmdShow); // Show the window
    UpdateWindow(hwnd);         // Sends WM_PAINT message


    return hwnd;
}



