//
//Terminal window with scrollback buffer
// @ SV2AGW 2000
//
/*
This is the terminal painting functions. They actually read the Screen buffer and
display the contents on the screen. The functions are from the Microsoft example
mtty.

-----------------------------------------------------------------------------
    This is a part of the Microsoft Source Code Samples.
    Copyright (C) 1995 Microsoft Corporation.
    All rights reserved.







*/


#include <winsock2.h>
#include "AGWTERMINALcanvas.h"
#define min(a, b)  (((a) < (b)) ? (a) : (b))
#define max(a, b)  (((a) > (b)) ? (a) : (b))


AGWTerminalCanvas::AGWTerminalCanvas(int Rows,int Cols)
{
MAXROWS=Rows;
MAXCOLS=Cols;
Screen=new char[MAXROWS*MAXCOLS+10];
if (!Screen) OutputDebugString("No SCREEN");
FillMemory(Screen,MAXROWS*MAXCOLS,' ');
hTTYFont=0;
    //
    // initialize generial TTY info
    //
xSize=0;
ySize=0;
xScroll=0;
yScroll=0;
xOffset=0;
yOffset=0;
nColumn=0;
xChar=0;
yChar=0;
nCharPos=0;
fAutowrap=FALSE;
fNewLine=TRUE;
wCursorState= CS_HIDE ;
nRow       = MAXROWS - 1 ;

//
// setup default font information
//
lfTTYFont.lfHeight =         24 ;
lfTTYFont.lfWidth =          0 ;
lfTTYFont.lfEscapement =     0 ;
lfTTYFont.lfOrientation =    0 ;
lfTTYFont.lfWeight =         0 ;
lfTTYFont.lfItalic =         0 ;
lfTTYFont.lfUnderline =      0 ;
lfTTYFont.lfStrikeOut =      0 ;
lfTTYFont.lfCharSet =        OEM_CHARSET ;
lfTTYFont.lfOutPrecision =   OUT_DEFAULT_PRECIS ;
lfTTYFont.lfClipPrecision =  CLIP_DEFAULT_PRECIS ;
lfTTYFont.lfQuality =        DEFAULT_QUALITY ;
lfTTYFont.lfPitchAndFamily = FIXED_PITCH | FF_MODERN ;
lstrcpy( lfTTYFont.lfFaceName, "FixedSys" ) ;
    InitNewFont( lfTTYFont, RGB(0,0,0));
}

//-----------------------------------------------------------------------------
void AGWTerminalCanvas::InitNewFont(LOGFONT LogFont, COLORREF rgbColor)
{
    TEXTMETRIC tm;
    HDC        hDC;

    //
    // if old one exists, then I should delete it
    //
    if (hTTYFont)     DeleteObject(hTTYFont);

    lfTTYFont = LogFont;
    hTTYFont= CreateFontIndirect(&lfTTYFont);
    rgbFGColor = rgbColor;

    hDC = GetDC( HWND() ) ;
    SelectObject( hDC, hTTYFont ) ;
    GetTextMetrics( hDC, &tm ) ;
    ReleaseDC( HWND(), hDC ) ;

    //
    // character width and height
    //
    xChar = tm.tmAveCharWidth  ;
    yChar = tm.tmHeight + tm.tmExternalLeading ;

    xOffset = 0 ;
    yOffset = yChar * nRow;
}

//****************************************************

BOOL AGWTerminalCanvas::ScrollTTYVert(HWND hWnd,WORD wScrollCmd, WORD wScrollPos )
{
   int  nScrollAmt ;

   switch (wScrollCmd)
   {
      case SB_TOP:
         				nScrollAmt = -yOffset;
         				break ;
      case SB_BOTTOM:
         				nScrollAmt = yScroll - yOffset ;
         				break ;
      case SB_PAGEUP:
         				nScrollAmt = -ySize ;
         				break ;
      case SB_PAGEDOWN:
       					nScrollAmt = ySize;
                     break ;
      case SB_LINEUP:
         				nScrollAmt = -yChar ;
         				break ;
      case SB_LINEDOWN:
         				nScrollAmt = yChar ;
         				break ;
      case SB_THUMBPOSITION:
         						nScrollAmt = wScrollPos - yOffset ;
         						break ;
      default:
         			return ( FALSE ) ;
   }

   if ((yOffset + nScrollAmt) > yScroll)  nScrollAmt =yScroll - yOffset;

   if ((yOffset + nScrollAmt) < 0)  nScrollAmt = -yOffset ;
   ScrollWindowEx( hWnd, 0, -nScrollAmt, NULL, NULL, NULL, NULL, SW_INVALIDATE | SW_ERASE) ;
   yOffset = yOffset + nScrollAmt ;
   SetScrollPos( hWnd, SB_VERT, yOffset, TRUE ) ;
   return ( TRUE ) ;

} // end of ScrollTTYVert()

//---------------------------------------------------------------------------
BOOL AGWTerminalCanvas::ScrollTTYHorz(HWND hWnd, WORD wScrollCmd, WORD wScrollPos )
{
   int  nScrollAmt ;

   switch (wScrollCmd)
   {
      case SB_TOP:
         nScrollAmt = -xOffset ;
         break ;

      case SB_BOTTOM:
         nScrollAmt = xScroll- xOffset ;
         break ;

      case SB_PAGEUP:
         nScrollAmt = -xSize ;
         break ;

      case SB_PAGEDOWN:
         nScrollAmt = xSize ;
         break ;

      case SB_LINEUP:
         nScrollAmt = -xChar ;
         break ;

      case SB_LINEDOWN:
         nScrollAmt = xChar ;
         break ;

      case SB_THUMBPOSITION:
         nScrollAmt = wScrollPos - xOffset ;
         break ;

      default:
         return ( FALSE ) ;
   }
   if ((xOffset + nScrollAmt) > xScroll)  nScrollAmt = xScroll - xOffset ;
   if ((xOffset + nScrollAmt) < 0)     nScrollAmt = -xOffset ;
   ScrollWindowEx( hWnd, -nScrollAmt, 0, NULL, NULL, NULL, NULL, SW_INVALIDATE | SW_ERASE) ;
   xOffset  += nScrollAmt ;
   SetScrollPos( hWnd, SB_HORZ, xOffset, TRUE ) ;

   return ( TRUE ) ;

} // end of ScrollTTYHorz()

BOOL AGWTerminalCanvas::PaintTTY( HWND hWnd )
{
   PAINTSTRUCT  ps ;
   HFONT        hOldFont ;
   RECT         rect ;
   HDC          hDC ;
   int          nRow, nCol, nEndRow, nEndCol;
   int          nCount, nHorzPos, nVertPos ;

   hDC = BeginPaint( hWnd, &ps ) ;
   hOldFont = SelectObject( hDC, hTTYFont ) ;
   SetTextColor( hDC, rgbFGColor ) ;
   SetBkColor( hDC, GetSysColor( COLOR_WINDOW ) ) ;
   rect = ps.rcPaint ;
   nRow =   min( MAXROWS - 1, max( 0, (rect.top +yOffset) / yChar ) ) ;
   nEndRow =min( MAXROWS - 1, ((rect.bottom + yOffset - 1) / yChar ) ) ;
   nCol =   min( MAXCOLS - 1, max( 0, (rect.left + xOffset) / xChar ) ) ;
   nEndCol =min( MAXCOLS - 1,((rect.right + xOffset - 1) / xChar ) ) ;
   nCount = nEndCol - nCol + 1 ;
   for (; nRow <= nEndRow; nRow++)
   {
      nVertPos = (nRow * yChar) - yOffset ;
      nHorzPos = (nCol * xChar) - xOffset ;
      rect.top = nVertPos ;
      rect.bottom = nVertPos + yChar ;
      rect.left = nHorzPos ;
      rect.right = nHorzPos + xChar* nCount ;
      SetBkMode( hDC, OPAQUE ) ;
      ExtTextOut( hDC, nHorzPos, nVertPos, ETO_OPAQUE | ETO_CLIPPED, &rect,
                  (LPSTR)( Screen+ nRow * MAXCOLS + nCol ),
                  nCount, NULL ) ;
   }
   SelectObject( hDC, hOldFont ) ;
   EndPaint( hWnd, &ps ) ;
   MoveTTYCursor(  ) ;
   return ( TRUE ) ;

} // end of PaintTTY()

//---------------------------------------------------------------------------
BOOL AGWTerminalCanvas::MoveTTYCursor( void )
{
   if (wCursorState & CS_SHOW)
      SetCaretPos((nColumn * xChar)-xOffset,(nRow * yChar) -yOffset) ;
   return ( TRUE ) ;

} // end of MoveTTYCursor()

//---------------------------------------------------------------------------
BOOL AGWTerminalCanvas::SetTTYFocus( HWND hWnd )
{
   if (wCursorState != CS_SHOW)
   {
      CreateCaret( hWnd, NULL, xChar, yChar ) ;
      ShowCaret( hWnd ) ;
      wCursorState = CS_SHOW ;
   }
   MoveTTYCursor( ) ;
   return ( TRUE ) ;

} // end of SetTTYFocus()
//---------------------------------------------------------------------------
BOOL AGWTerminalCanvas::KillTTYFocus( HWND hWnd )
{
   if (wCursorState != CS_HIDE)
   {
      HideCaret( hWnd ) ;
      DestroyCaret() ;
      wCursorState = CS_HIDE ;
   }
   return ( TRUE ) ;

} // end of KillTTYFocus()
//---------------------------------------------------------------------------
BOOL AGWTerminalCanvas::SizeTTY( HWND hWnd, WORD wWidth, WORD wHeight )
{
   int nScrollAmt ;
   //
   // adjust vert settings
   //
   ySize = (int) wHeight ;
   yScroll = max( 0, (MAXROWS * yChar) -ySize ) ;
   nScrollAmt = min( yScroll, yOffset ) -yOffset ;
   ScrollWindow( HWND(), 0, -nScrollAmt, NULL, NULL ) ;

   yOffset = yOffset + nScrollAmt ;
   SetScrollPos( hWnd, SB_VERT, yOffset, FALSE ) ;
   SetScrollRange( hWnd, SB_VERT, 0, yScroll, TRUE ) ;

   //
   // adjust horz settings
   //
//   xSize = (int) wHeight ;
   xSize = (int) wWidth ;
   xScroll = max( 0, (MAXCOLS * xChar) -xSize ) ;
   nScrollAmt = min( xScroll, xOffset) -xOffset ;
   ScrollWindow( hWnd, nScrollAmt, 0, NULL, NULL );
   xOffset = xOffset + nScrollAmt ;
   SetScrollRange( hWnd, SB_HORZ, 0,xScroll, FALSE ) ;
   SetScrollPos( hWnd, SB_HORZ, xOffset, TRUE ) ;

   InvalidateRect( hWnd, NULL, FALSE ) ;   // redraw entire window

   return ( TRUE ) ;

} // end of SizeTTY()

//***********************************************************
void AGWTerminalCanvas::InsertData(HWND Hwnd,LPSTR Data,int DataLen)
{
    RECT rect;

    /*
        update screen buffer with new buffer
        need to do a character by character check
        for special characters
    */
    int i;

    for ( i = 0 ; i < DataLen; i++)
    {
        switch (Data[ i ])
        {

            case ASCII_CR:                 // Carriage Return
            case ASCII_LF:                 // Line Feed
                				nColumn = 0 ;
                if (nRow++ == MAXROWS - 1)
                {
                OutputDebugString("MOVEMEMORY");
                    MoveMemory(Screen,Screen + MAXCOLS,(MAXROWS - 1) * MAXCOLS ) ;
                    FillMemory((Screen + (MAXROWS - 1) * MAXCOLS),MAXCOLS,  ' ' ) ;
                    InvalidateRect(Hwnd , NULL, FALSE ) ;
                    nRow-- ;
                }
                break ;

            default:                       // standard character
                Screen[nRow * MAXCOLS + nColumn] = Data[ i ];

                rect.left = (nColumn * xChar) -xOffset ;
                rect.right = rect.left + xChar ;
                rect.top = (nRow* yChar) -yOffset ;
                rect.bottom = rect.top + yChar ;
                InvalidateRect( Hwnd, &rect, FALSE ) ;

                //
                // Line wrap
                //
                if (nColumn < MAXCOLS-1 )  nColumn++ ;
                else if (fAutowrap)  InsertData(Hwnd, "\r\n", 2 ) ;

                break;
        }
    }

    MoveTTYCursor();
    return;
}
//***********************************************************




