#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> 3-Pole Butterworth Characteristic Bandpass Filter, 3pole.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

$pic = "pics/3pole.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $imp = $FORM{'imp'};

my $center = $FORM{'center'};
my $center_val = $FORM{'center_val'};

my $db = $FORM{'db'};
my $db_val = $FORM{'db_val'};

# Clean up user input data
#
$imp =~ tr/0-9.//csd;

if (!$imp) {
  $imp = 50; # 50 ohms
}

$center =~ tr/0-9.-//csd;
$center_val =~ tr/a-zA-Z-//csd;

if (!$center) {
  $center = 7.15; $center_val = "MHz"; # 7.15 MHz
}

$db =~ tr/0-9.-//csd;
$db_val =~ tr/a-zA-Z-//csd;

if (!$db) {
  $db = 0.36; $db_val = "MHz"; # 0.36 MHz
}

# Start calculations
#
if ($center_val eq "kHz") {
  $center = $center / 1000; # kHz to MHz
}

if ($db_val eq "kHz") {
  $db = $db / 1000; # kHz to MHz
}

# Calculate bandstop frequencies
#
$flim1 = ($db / 2) + $center;
$flim2 = abs (($db / 2) - $center);
$fo = sqrt($flim1 * $flim2);

# Calculate the component values
#
$L = 2 * ($imp * (1 / ((2 * pi) * $db)));
$C = (1 / $imp) * (1 / ((2 * pi) * $db));
$L1 = 1 / (((2 * pi * $fo) ** 2) * $C);
$C1 = 1 / (((2 * pi * $fo) ** 2) * $L);
$Q = $fo / $db;

# Make all pretty
#
$db = sprintf "%.3f", $db;
$center = sprintf "%.3f", $center;

$imp = sprintf "%.3f", $imp;
$Q = sprintf "%.3f", $Q;
$L = sprintf "%.6f", $L;
$L_n = sprintf "%.3f", $L * 1000;
$L1 = sprintf "%.6f", $L1;
$L1_n = sprintf "%.3f", $L1 * 1000;
$C = sprintf "%.6f", $C;
$C_p = sprintf "%.3f", $C * 1000000;;
$C1 = sprintf "%.9f", $C1;
$C1_p = sprintf "%.3f", $C1 * 1000000;

$date = scalar gmtime;

# Draw me a web page
#
$p = "<font color=\"purple\">";
$b = "<font color=\"blue\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>3-Pole Butterworth Characteristic Bandpass Filter Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>3-Pole Butterworth Characteristic Bandpass Filter Calculator Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[3pole]"></center>
<hr noshade>

<hr noshade>
<pre>
              $p Filter Q : $e$Q
             $p Bandwidth : $e$db$p MHz $e
      $p Center frequency : $e$center$p MHz $e
$p Input/Output impedance : $e$imp$p ohms $e
<br>
                $b L1, L3 : $e$L1$b &micro;H ($e$L1_n$b nH) $e
                    $b L2 : $e$L$b &micro;H ($e$L_n$b nH) $e
<br>
                $b C1, C3 : $e$C$b &micro;F ($e$C_p$b pF) $e
                    $b C2 : $e$C1$b &micro;F ($e$C1_p$b pF) $e
</pre>

<hr noshade size="5">
<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
