#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> United States Frequency Allocations 30 - 3000 MHz, US_freqs.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

# Clean up user input data
#
$frq =~ tr/0-9.//csd;
$frq_val =~ tr/a-zA-Z//csd;

if (!$frq) {
  $frq = 146; $frq_val = "MHz"; # 146 MHz
}

# Start calculations
#
if ($frq_val =~ /GHz/i) {
  $frq = $frq * 1000;
}

if ($frq > 3000.00 || $frq < 30.00) {
  $message = "Frequency must be between 30 and 3000 MHz"
}

$n = "\n";
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

sub G {
  "\n$b<b>Government Exclusive:</b>$e\n\n";
}
sub NG {
  "\n$b<b>Non-Government Exclusive:</b>$e\n\n";
}
sub S {
  "\n$b<b>Government/Non-Government Shared:</b>$e\n\n";
}
sub AeroM {
  "Aeronautical Mobile\n";
}
sub AeroS {
  "Aeronautical Satellite\n";
}
sub AeroR {
  "Aeronautical Radionavigation\n";
}
sub Ham {
  "Amateur Radio\n";
}
sub HamS {
  "Amateur Radio Satellite\n";
}
sub Broad {
  "Broadcasting\n";
}
sub BroadS {
  "Broadcasting Satellite\n";
}
sub EES {
  "Earth Exploration Satellite\n";
}
sub Fixed {
  "Fixed\n";
}
sub FixedS {
  "Fixed Satellite\n";
}
sub MarR {
  "Maritime Radionavigation\n";
}
sub Meter {
  "Meteorological Aids\n";
}
sub MeterS {
  "Meteorological Aids Satellite\n";
}
sub Mobile {
  "Mobile\n";
}
sub MobileS {
  "Mobile Satellite\n";
}
sub RadioA {
  "Radio Astronomy\n";
}
sub RadioD {
  "Radiodetermination Satellite\n";
}
sub RadioL {
  "Radiolocation\n";
}
sub RadioLS {
  "Radiolocation Satellite\n";
}
sub RadioN {
  "Radionavigation\n";
}
sub RadioNS {
  "Radionavigation Satellite\n";
}
sub Space {
  "Space Operation\n";
}
sub SpaceR {
  "Space Research\n";
}
sub Time {
  "Standard Frequency and Time Signal\n";
}
sub TimeS {
  "Standard Frequency and Time Signal Satellite\n";
}
sub LandM {
  "Land Mobile\n";
}
sub LandMS {
  "Land Mobile Satellite\n";
}
sub MariM {
  "Maritime Mobile\n";
}
sub MariMS {
  "Maritime Mobile Satellite\n";
}

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>United States Frequency Allocations 30 - 3000 MHz Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>United States Frequency Allocations 30 - 3000 MHz Results</h2>
</center>

<hr noshade>
<pre>

$p Frequency : $e$frq$p MHz $e &nbsp;&nbsp; $message
<br>
EOF

if ($frqs >= 30.00 && $frq <= 30.56) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 30.56 && $frq <= 32.00) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 32.00 && $frq <= 33.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 33.00 && $frq <= 34.00) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 34.00 && $frq <= 35.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 35.00 && $frq <= 36.00) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 36.00 && $frq <= 37.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 37.00 && $frq <= 37.50) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 37.50 && $frq <= 38.00) {
  print &S,&RadioA,&RadioN,&NG,&LandM,$n;
}

elsif ($frq >= 38.00 && $frq <= 38.25) {
  print &S,&RadioA,&G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 38.25 && $frq <= 39.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 39.00 && $frq <= 40.00) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 40.00 && $frq <= 42.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 42.00 && $frq <= 46.60) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 46.60 && $frq <= 47.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 47.00 && $frq <= 49.60) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 49.60 && $frq <= 50.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 50.00 && $frq <= 54.00) {
  print &NG,&Ham,$n;
}

elsif ($frq >= 54.00 && $frq <= 72.00) {
  print &NG,&Broad,$n;
}

elsif ($frq >= 72.00 && $frq <= 73.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 73.00 && $frq <= 74.60) {
  print &S,&RadioA,$n;
}

elsif ($frq >= 74.60 && $frq <= 74.80) {
  print &S,&Fixed,&Mobile,$n;
}

elsif ($frq >= 74.80 && $frq <= 75.20) {
  print &S,&AeroR,$n;
}

elsif ($frq >= 75.20 && $frq <= 75.40) {
  print &S,&Fixed,&Mobile,$n;
}

elsif ($frq >= 75.40 && $frq <= 76.00) {
  print &NG,&Fixed,&Mobile,$n;
}

elsif ($frq >= 76.00 && $frq <= 108.00) {
  print &NG,&Broad,$n;
}

elsif ($frq >= 108.00 && $frq <= 117.975) {
  print &S,&AeroR,$n;
}

elsif ($frq >= 117.975 && $frq <= 121.9375) {
  print &S,&AeroM,$n;
}

elsif ($frq >= 121.9375 && $frq <= 123.0875) {
  print &NG,&AeroM,$n;
}

elsif ($frq >= 123.0875 && $frq <= 123.5875) {
  print &S,&AeroM,$n;
}

elsif ($frq >= 123.5875 && $frq <= 128.8125) {
  print &S,&AeroM,$n;
}

elsif ($frq >= 128.8125 && $frq <= 132.0125) {
  print &NG,&AeroM,$n;
}

elsif ($frq >= 132.0125 && $frq <= 136.00) {
  print &S,&AeroM,$n;
}

elsif ($frq >= 136.00 && $frq <= 137.00) {
  print &S,&SpaceR,&MeterS,&Space,&G,&AeroM,$n;
}

elsif ($frq >= 137.00 && $frq <= 138.00) {
  print &S,&MobileS,&SpaceR,&Space,&MeterS,$n;
}

elsif ($frq >= 138.00 && $frq <= 144.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 144.00 && $frq <= 146.00) {
  print &NG,&Ham,&HamS,$n;
}

elsif ($frq >= 146.00 && $frq <= 148.00) {
  print &NG,&Ham,$n;
}

elsif ($frq >= 148.00 && $frq <= 149.90) {
  print &S,&MobileS,&G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 149.90 && $frq <= 150.05) {
  print &S,&RadioNS,&MobileS,$n;
}

elsif ($frq >= 150.05 && $frq <= 156.2475) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 156.2475 && $frq <= 157.0375) {
  print &NG,&MariM,$n;
}

elsif ($frq >= 157.0375 && $frq <= 157.1875) {
  print &G,&MariM,$n;
}

elsif ($frq >= 157.1875 && $frq <= 157.45) {
  print &NG,&MariM,$n;
}

elsif ($frq >= 157.45 && $frq <= 161.575) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 161.575 && $frq <= 161.625) {
  print &NG,&MariM,$n;
}

elsif ($frq >= 161.625 && $frq <= 161.775) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 161.775 && $frq <= 162.0125) {
  print &NG,&MariM,$n;
}

elsif ($frq >= 162.0125 && $frq <= 173.20) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 173.2 && $frq <= 173.4) {
  print &NG,&Fixed,&LandM,$n;
}

elsif ($frq >= 173.40 && $frq <= 174.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 174.00 && $frq <= 216.00) {
  print &NG,&Broad,$n;
}

elsif ($frq >= 216.00 && $frq <= 220.00) {
  print &S,&MariM,&AeroM,&Fixed,&LandM,&G,&RadioL,&NG,&Ham,$n;
}

elsif ($frq >= 220.00 && $frq <= 222.00) {
  print &S,&LandM,&G,&RadioL,$n;
}

elsif ($frq >= 222.00 && $frq <= 225.00) {
  print &NG,&Ham,&G,&RadioL,$n;
}

elsif ($frq >= 225.00 && $frq <= 235.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 235.00 && $frq <= 326.60) {
  print &G,&Fixed,&MobileS,&Mobile,$n;
}

elsif ($frq >= 326.60 && $frq <= 335.40) {
  print &S,&AeroR,$n;
}

elsif ($frq >= 335.40 && $frq <= 399.90) {
  print &G,&Fixed,&MobileS,&Mobile,$n;
}

elsif ($frq >= 399.90 && $frq <= 400.05) {
  print &S,&RadioNS,&MobileS,$n;
}

elsif ($frq >= 400.05 && $frq <= 400.15) {
  print &S,&TimeS,$n;
}

elsif ($frq >= 400.15 && $frq <= 401.00) {
  print &S,&Meter,&MobileS,&SpaceR,&Space,&G,&MeterS,$n;
}

elsif ($frq >= 401.00 && $frq <= 402.00) {
  print &S,&Meter,&Space,&MeterS,&EES,$n;
}

elsif ($frq >= 402.00 && $frq <= 403.00) {
  print &S,&Meter,&MeterS,&EES,$n;
}

elsif ($frq >= 403.00 && $frq <= 406.00) {
  print &S,&Meter,$n;
}

elsif ($frq >= 406.00 && $frq <= 406.10) {
  print &S,&MobileS,$n;
}

elsif ($frq >= 406.10 && $frq <= 410.00) {
  print &S,&RadioA,&G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 410.00 && $frq <= 420.00) {
  print &G,&Fixed,&Mobile,&SpaceR,$n;
}

elsif ($frq >= 420.00 && $frq <= 450.00) {
  print &G,&RadioL,&NG,&Ham,$n;
}

elsif ($frq >= 450.00 && $frq <= 460.00) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 460.00 && $frq <= 470.00) {
  print &NG,&LandM,&G,&MeterS,$n;
}

elsif ($frq >= 470.00 && $frq <= 512.00) {
  print &NG,&LandM,&Broad,$n;
}

elsif ($frq >= 512.00 && $frq <= 608.00) {
  print &NG,&Broad,$n;
}

elsif ($frq >= 608.00 && $frq <= 614.00) {
  print &S,&RadioA,$n;
}

elsif ($frq >= 614.00 && $frq <= 806.00) {
  print &NG,&Broad,$n;
}

elsif ($frq >= 806.00 && $frq <= 902.00) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 902.00 && $frq <= 928.00) {
  print &G,&RadioL,&NG,&Ham,$n;
}

elsif ($frq >= 928.00 && $frq <= 929.00) {
  print &NG,&Fixed,$n;
}

elsif ($frq >= 929.00 && $frq <= 932.00) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 932.00 && $frq <= 935.00) {
  print &S,&Fixed,$n;
}

elsif ($frq >= 935.00 && $frq <= 940.00) {
  print &NG,&LandM,$n;
}

elsif ($frq >= 940.00 && $frq <= 941.00) {
  print &NG,&Mobile,$n;
}

elsif ($frq >= 941.00 && $frq <= 944.00) {
  print &S,&Fixed,$n;
}

elsif ($frq >= 944.00 && $frq <= 960.00) {
  print &NG,&Fixed,$n;
}

elsif ($frq >= 960.00 && $frq <= 1215.00) {
  print &S,&AeroR,$n;
}

elsif ($frq >= 1215.00 && $frq <= 1240.00) {
  print &G,&RadioNS,&RadioL,$n;
}

elsif ($frq >= 1240.00 && $frq <= 1300.00) {
  print &G,&RadioL,&NG,&Ham,$n;
}

elsif ($frq >= 1300.00 && $frq <= 1350.00) {
  print &S,&AeroR,&G,&RadioL,$n;
}

elsif ($frq >= 1350.00 && $frq <= 1400.00) {
  print &G,&Fixed,&Mobile,&RadioL,$n;
}

elsif ($frq >= 1400.00 && $frq <= 1427.00) {
  print &S,&RadioA,&EES,&SpaceR,$n;
}

elsif ($frq >= 1427.00 && $frq <= 1429.00) {
  print &S,&Space,&G,&Fixed,&Mobile,&NG,&LandM,$n;
}

elsif ($frq >= 1429.00 && $frq <= 1435.00) {
  print &G,&Fixed,&Mobile,&NG,&Fixed,&LandM,$n;
}

elsif ($frq >= 1435.00 && $frq <= 1530.00) {
  print &S,&Mobile,$n;
}

elsif ($frq >= 1530.00 && $frq <= 1535.00) {
  print &S,&MariMS,&MobileS,&Mobile,$n;
}

elsif ($frq >= 1535.00 && $frq <= 1544.00) {
  print &S,&MariMS,&MobileS,$n;
}

elsif ($frq >= 1544.00 && $frq <= 1545.00) {
  print &S,&MobileS,$n;
}

elsif ($frq >= 1545.00 && $frq <= 1558.50) {
  print &S,&AeroM,&MobileS,$n;
}

elsif ($frq >= 1558.50 && $frq <= 1559.00) {
  print &S,&AeroM,$n;
}

elsif ($frq >= 1559.00 && $frq <= 1610.00) {
  print &S,&AeroR,&RadioNS,$n;
}

elsif ($frq >= 1610.00 && $frq <= 1610.60) {
  print &S,&AeroR,&RadioD,&MobileS,$n;
}

elsif ($frq >= 1610.60 && $frq <= 1613.80) {
  print &S,&AeroR,&RadioD,&MobileS,&RadioA,$n;
}

elsif ($frq >= 1613.80 && $frq <= 1626.50) {
  print &S,&AeroR,&RadioD,&MobileS,$n;
}

elsif ($frq >= 1626.50 && $frq <= 1645.50) {
  print &S,&MariMS,&MobileS,$n;
}

elsif ($frq >= 1645.50 && $frq <= 1646.50) {
  print &S,&MobileS,$n;
}

elsif ($frq >= 1646.50 && $frq <= 1660.00) {
  print &S,&AeroS,&MobileS,$n;
}

elsif ($frq >= 1660.00 && $frq <= 1660.50) {
  print &S,&RadioA,&AeroS,$n;
}

elsif ($frq >= 1660.50 && $frq <= 1668.40) {
  print &S,&RadioA,&SpaceR,$n;
}

elsif ($frq >= 1668.40 && $frq <= 1670.00) {
  print &S,&RadioA,&Meter,$n;
}

elsif ($frq >= 1670.00 && $frq <= 1700.00) {
  print &S,&Meter,&MeterS,$n;
}

elsif ($frq >= 1700.00 && $frq <= 1710.00) {
  print &S,&Meter,&G,&Fixed,&NG,&Fixed,$n;
}

elsif ($frq >= 1710.00 && $frq <= 1850.00) {
  print &G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 1850.00 && $frq <= 1990.00) {
  print &NG,&Fixed,$n;
}

elsif ($frq >= 1990.00 && $frq <= 2150.00) {
  print &NG,&Fixed,&Mobile,$n;
}

elsif ($frq >= 2150.00 && $frq <= 2160.00) {
  print &NG,&Fixed,$n;
}

elsif ($frq >= 2160.00 && $frq <= 2200.00) {
  print &NG,&Fixed,&Mobile,$n;
}

elsif ($frq >= 2200.00 && $frq <= 2290.00) {
  print &G,&Fixed,&Mobile,&SpaceR,&Space,&EES,$n;
}

elsif ($frq >= 2290.00 && $frq <= 2300.00) {
  print &S,&SpaceR,&G,&Fixed,&Mobile,$n;
}

elsif ($frq >= 2300.00 && $frq <= 2310.00) {
  print &NG,&Ham,$n;
}

elsif ($frq >= 2310.00 && $frq <= 2360.00) {
  print &S,&Mobile,&RadioL,&G,&Fixed,&NG,&BroadS,$n;
}

elsif ($frq >= 2360.00 && $frq <= 2390.00) {
  print &S,&Mobile,&G,&RadioL,&Fixed,$n;
}

elsif ($frq >= 2390.00 && $frq <= 2417.00) {
  print &NG,&Ham,$n;
}

elsif ($frq >= 2417.00 && $frq <= 2450.00) {
  print &G,&RadioL,&NG,&Ham,$n;
}

elsif ($frq >= 2450.00 && $frq <= 2483.50) {
  print &NG,&Fixed,&Mobile,&RadioL,$n;
}

elsif ($frq >= 2483.50 && $frq <= 2500.00) {
  print &S,&EES,&MobileS,$n;
}

elsif ($frq >= 2500.00 && $frq <= 2655.00) {
  print &NG,&BroadS,&Fixed,$n;
}

elsif ($frq >= 2655.00 && $frq <= 2690.00) {
  print &S,&EES,&RadioA,&SpaceR,&NG,&BroadS,&Fixed,$n;
}

elsif ($frq >= 2690.00 && $frq <= 2700.00) {
  print &S,&RadioA,&SpaceR,&EES,$n;
}

elsif ($frq >= 2700.00 && $frq <= 2900.00) {
  print &G,&AeroR,&Meter,&RadioL,$n;
}

elsif ($frq >= 2900.00 && $frq <= 3000.00) {
  print &S,&MarR,&RadioL,$n;
}

print "<hr noshade size=\"5\"></pre></body></html>";
