#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Calculating Phase Line Length, phase.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $vf = $FORM{'vf'};

my $len = $FORM{'len'};
my $len_val = $FORM{'len_val'};

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

# Clean up user input data
#
$vf =~ tr/0-9.//csd;

if (!$vf) {
  $vf = 0.853; # LMR-400 velocity factor
}

$len =~ tr/0-9.//csd;
$len_val =~ tr/a-z//csd;

if (!$len) {
  $len = 10; $len_val = "feet"; # 10 feet long
}

$frq =~ tr/0-9.//csd;
$frq_val =~ tr/a-zA-Z//csd;

if (!$frq) {
  $frq = 146; $frq_val = "MHz"; # 146.0 MHz
}

# Start calculations
#

# approximate phase line length
#
if ($len_val eq "feet") {
  $len = $len * 12; # ft to in
}
elsif ($len_val eq "centimeters") {
  $len = $len / 2.54; # cm to in
}
elsif ($len_val eq "meters") {
  $len = $len / 0.0254; # m to in 
}

# Frequency
#
if ($frq_val eq "kHz") {
  $frq = $frq / 1000; # kHz to MHz
}
elsif ($frq_val eq "GHz") {
  $frq = $frq * 1000; # GHz to MHz
}

# Start calculations
#

# Free space half wavelength, inches
#
$half = (11802.8 / $frq) / 2;

# Half wavelength in coax
#
$half_coax = $half * $vf;

# Half wavelengths in the approximate line length
#
$total = sprintf "%.f\n", $len / $half_coax;
$total1 = $total + 1;

# New phase line length
#
$phase = $total * $half_coax;
$phase1 = $total1 * $half_coax;

# Make all pretty
#
$vf = sprintf "%.3f", $vf;

$half_coax_cm = sprintf "%.3f", $half_coax * 2.54;
$half_coax = sprintf "%.3f", $half_coax;

$len_cm = sprintf "%.3f", $len * 2.54;
$len = sprintf "%.3f", $len;

$phase_cm = sprintf "%.3f", $phase * 2.54;
$phase = sprintf "%.3f", $phase;

$phase1_cm = sprintf "%.3f", $phase1 * 2.54;
$phase1 = sprintf "%.3f", $phase1;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Calculating Phase Line Length</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Calculating Phase Line Length</h2>
</center>

<hr noshade>
<pre>
        $b Operating frequency : $e$frq $b$frq_val $e
    $b cable's velocity factor : $e$vf
$b Requested phase line length : $e$len$b inches ($e$len_cm$b centimeters) $e
    $b Half wavelength in coax : $e$half_coax$b inches ($e$half_coax_cm$b centimeters) $e
<br>
<b>Shorter</b>

   $p Actual phase line length : $e$phase$p inches ($e$phase_cm$p centimeters) $e

<b>Longer</b>

   $p Actual phase line length : $e$phase1$p inches ($e$phase1_cm$p centimeters) $e
</pre>

<hr noshade size="5">

<blockquote>
<p>You must choose either a shorter or longer cable run to properly phase your antennas.</p>
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
