#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> PLL 3rd Order Passive Loop Filter Calculator, tilt.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2002 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
use Math::Trig;
select STDOUT;
$| = 1;

my $pic = "pics/pll_filter.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

my $loop = $FORM{'loop'};
my $loop_val = $FORM{'loop_val'};

my $ref = $FORM{'ref'};
my $ref_val = $FORM{'ref_val'};

my $phase = $FORM{'phase'};

my $vco_tune = $FORM{'vco_tune'};

my $pump = $FORM{'pump'};

my $att = $FORM{'att'};

# Clean up user input data
#
$frq =~ tr/0-9.//csd;

if (!$frq) {
  $frq = 2450; $frq_val = "MHz";
}

if ($frq_val eq "GHz") {
  $frq = $frq * 1000;
}

$loop =~ tr/0-9.//csd;

if (!$loop) {
  $loop = 1000; $loop_val = "Hz";
}

if ($loop_val eq "kHz") {
  $loop = $loop * 1000;
}

$ref =~ tr/0-9.//csd;

if (!$ref) {
  $ref = 10000; $loop_val = "Hz";
}

if ($ref_val eq "kHz") {
  $ref = $ref * 1000;
}

$phase =~ tr/0-9.//csd;

if (!$phase || $phase > 360) {
  $phase = 45;
}

$vco_tune =~ tr/0-9.//csd;

if (!$vco_tune) {
  $vco_tune = 40;
}

$pump =~ tr/0-9.//csd;

if (!$pump) {
  $pump = 4;
}

$att =~ tr/0-9.//csd;

if (!$att) {
  $att = 20;
}

# Start calculations
#

# A bunch of math equations I don't understand go here...
#

$wp = 2 * pi * $loop;

$Op = pi * ($phase / 180);

$pump = $pump / 1000;

$N = ($frq * 1000000) / $ref;

$T3 = 1 / (10 * $wp);

#$wp = 1.424 * $wp;

$T1 = (sec($Op) - tan($Op)) / $wp;

$T3 = sqrt(((10 ** ($att / 20) - 1)) / (((2 * pi * $ref) ** 2)));

$a = (tan($Op) * ($T1 + $T3)) / ((($T1 + $T3) ** 2) + $T1 * $T3);
$b = 1 + (((($T1 + $T3) ** 2) + $T1 * $T3) / ((tan($Op) * ($T1 + $T3)) ** 2));
$wc = $a * (sqrt ($b) - 1);

$T2 = 1 / (($wc ** 2) * ($T1 + $T3));

$c = ($T1 * $pump * ($vco_tune * 1000000)) / ($N * $T2 * ($wc ** 2));
$C1 = $c * sqrt ((1 + (($wc * $T2) ** 2)) / ((1 + ($wc * $T1) ** 2) * (1 + + ($wc * $T3) ** 2)));

$C2 = $C1 * (($T2 / $T1) - 1);

$R2 = $T2 / $C2;

$R1 = 3 * $R2;

$C3 = $T3 / $R1;

# Make all pretty
#
$frq_mhz = sprintf "%.4f", $frq;
$frq_ghz = sprintf "%.4f", $frq / 1000;

$loop_hz = sprintf "%.4f", $loop;
$loop_khz = sprintf "%.4f", $loop / 1000;

$ref_hz = sprintf "%.4f", $ref;
$ref_khz = sprintf "%.4f", $ref / 1000;

$phase = sprintf "%.4f", $phase;

$pump = sprintf "%.4f", $pump * 1000;

$vco_tune = sprintf "%.4f", $vco_tune;

$att = sprintf "%.4f", $att;

$N = sprintf "%.4f", $N;

$T1 = sprintf "%.4f", $T1 * 1000000;
$T2 = sprintf "%.4f", $T2 * 1000000;
$T3 = sprintf "%.4f", $T3 * 1000000;

$C1_u = sprintf "%.4f", $C1 * 1000000;
$C1_p = sprintf "%.2f", $C1 * 1000000000000;
$C2_u = sprintf "%.4f", $C2 * 1000000;
$C2_p = sprintf "%.2f", $C2 * 1000000000000;
$C3_u = sprintf "%.4f", $C3 * 1000000;
$C3_p = sprintf "%.2f", $C3 * 1000000000000;

$R2 = sprintf "%.2f", $R2;
$R1 = sprintf "%.2f", $R1;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>PLL 3rd Order Passive Loop Filter Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h3>PLL 3rd Order Passive Loop Filter Calculator Results</h3>

<hr noshade>
<img src="$pic" alt="[pll_filter]">
</center>

<hr noshade>
<pre>
               $b VCO output frequency : $e$frq_mhz$b MHz ($e$frq_ghz$b GHz) $e
                     $b Loop bandwidth : $e$loop_hz$b Hz ($e$loop_khz$b kHz) $e
         $b Loop refererence frequency : $e$ref_hz$b Hz ($e$ref_khz$b kHz) $e
                       $b Phase margin : $e$phase$b degrees $e
$b Phase detector/charge pump constant : $e$pump$b mA/2*pi*rad $e
        $b VCO tuning voltage constant : $e$vco_tune$b MHz/Volt $e
        $b Low pass filter attenuation : $e$att$b dB $e
<br>
                   $p Time constant T1 : $e$T1$p &micro;S $e
                   $p Time constant T2 : $e$T2$p &micro;S $e
                   $p Time constant T3 : $e$T3$p &micro;S $e
<br>
                      $p Divider ratio : $e$N
                        $p Value of C1 : $e$C1_u$p &micro;F ($e$C1_p$p pF) $e
                        $p Value of C2 : $e$C2_u$p &micro;F ($e$C2_p$p pF) $e
	                $p Value of C3 : $e$C3_u$p &micro;F ($e$C3_p$p pF) $e
                        $p Value of R1 : $e$R1$p ohms $e
	                $p Value of R2 : $e$R2$p ohms $e
</pre>

<hr noshade size="5">
<p><font size="-1">Calculated on $date GMT</font></p>
</body>
</html>
EOF
