#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> RF Safety Compliance Calculator, rfsafety.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $pwr = $FORM{'pwr'};
my $pwr_val = $FORM{'pwr_val'};

my $gain = $FORM{'gain'};
my $gain_val = $FORM{'gain_val'};

my $dx = $FORM{'dx'};
my $dx_val = $FORM{'dx_val'};

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

my $gnd = $FORM{'gnd'};

# Clean up user input data
#
$pwr =~ tr/0-9.-//csd;

if (!$pwr) {
  $pwr = 20; $pwr_val = "Watts"; # 20 watts
}

$gain =~ tr/0-9.//csd;

if (!$gain) {
  $gain = 15; $gain_val = "dBi"; # 15 dBi
}

$dx =~ tr/0-9.//csd;

if (!$dx) {
  $dx = 10; $ref_dep_val = "meters"; # 10 meters
}

$frq =~ tr/0-9.//csd;

if (!$frq) {
  $frq = 146; $frq_val = "MHz"; # 146 MHz
}

$gnd =~ tr/a-zA-Z//csd;

if (!$gnd) {
  $gnd = "Yes";
}

# Power
#
if ($pwr_val eq "dBm") {
  $pwr = (10 ** ($pwr / 10)) / 1000; # dBm to watts
}

# Gain
#
if ($gain_val eq "dBd") {
  $gain = $gain + 2.15; # dBd to dBi
}

# Distance
#
if ($dx_val eq "feet") {
  $dx = $dx * 30.48; # ft to cm
}
elsif ($dx_val eq "meters") {
  $dx = $dx * 100; # m to cm
}

# Frequency
#
if ($frq_val eq "kHz") {
  $frq = $frq / 1000; # kHz to MHz
}
elsif ($frq_val eq "GHz") {
  $frq = $frq * 1000; # GHz to MHz
}

# Start calculations
#
$eirp = (1000 * $pwr) * (10 ** ($gain / 10));

if ($frq > 100000) {
  $frq = 146;
}

if ($frq < 1.34) {
  $std1 = 100;
  $std2 = 100;
}
elsif ($frq < 3) {
  $std1 = 100;
  $std2 = 180 / ($frq ** 2);
}
elsif ($frq < 30) {
  $std1 = 900 / ($frq ** 2);
  $std2 = 180;
}
elsif ($frq < 300) {
  $std1 = 1;
  $std2 = 0.2;
}
elsif ($frq < 1500) {
  $std1 = $frq / 300;
  $std2 = $frq / 1500;
}
elsif ($frq < 100000) {
  $std1 = 5;
  $std2 = 1;
}

if ($gnd eq "Yes") {
  $gf = 0.64;
  $gr = "Yes";
}
else {
  $gf = 0.25;
  $gr = "No";
}

$pwrdens = ($gf * $eirp) / (pi * ($dx ** 2));
$pwrdens = (($pwrdens * 10000) + 0.5) / 10000;

$dx1 = (sqrt(($gf * $eirp) / ($std1 * pi))) / 30.48;
$dx1 = (($dx1 * 10) + 0.5) / 10;

$dx2 = (sqrt(($gf * $eirp)/($std2 * pi))) / 30.48;
$dx2 = (($dx2 * 10) + 0.5) / 10;

$std1 = ((($std1 * 100) + 0.5) / 100);
$std2 = ((($std2 * 100) + 0.5) / 100);

$comp1 = ($dx > $dx1) ? "Yes" : "No";
$comp2 = ($dx > $dx2) ? "Yes" : "No";

# Make all pretty
#
$frq = sprintf "%.3f", $frq;
$pwr = sprintf "%.3f", $pwr;
$gain = sprintf "%.3f", $gain;

$dx_ft = sprintf "%.3f", $dx / 30.48;
$dx = sprintf "%.3f", $dx / 100;
$dx1_m = sprintf "%.3f", $dx1 * 0.3048;
$dx1 = sprintf "%.3f", $dx1;
$dx2_m = sprintf "%.3f", $dx2 * 0.3048;
$dx2 = sprintf "%.3f", $dx2;

$pwrdens = sprintf "%.3f", $pwrdens;

$std1 = sprintf "%.3f", $std1;
$std2 = sprintf "%.3f", $std2;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>RF Safety Compliance Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>RF Safety Compliance Calculator Results</h2>
</center>

<hr noshade>
<pre>
  $b Frequency of operation : $e$frq$b MHz $e
$b Average power at antenna : $e$pwr$b Watts $e
            $b Antenna gain : $e$gain$b dBi $e
   $b Distance from antenna : $e$dx$b meters ($e$dx_ft$b feet) $e
 $b Estimated power density : $e$pwrdens$b mW/cm<sup>2</sup> $e
      $b Ground reflections : $e$gr
<br>
<b><u>Maximum Permissible Exposure (MPE)</u></b>
<br>
   $p Controlled environment : $e$std1$p mW/cm<sup>2</sup> $e
 $p Uncontrolled environment : $e$std2$p mW/cm<sup>2</sup> $e
<br>
<b><u>Distance to compliance from center of antenna</u></b>
<br>
   $p Controlled environment : $e$dx1_m$p meters ($e$dx1$p feet) $e
   $p Controlled environment : $e$dx2_m$p meters ($e$dx2$p feet) $e
<br>
$p   Is the controlled environment area compliant : $e$comp1
$p Is the uncontrolled environment area compliant : $e$comp2
</pre>

<p><center><b>Don't be a wuss, stand closer to that antenna.</b></center></p>

<hr noshade size="5">

<blockquote>
<p>Alternate Calculation Methods</p>

<p>1) Exposure is averaged over six minutes in controlled environments and 30 minutes in uncontrolled environments.  If you never transmit more than three minutes in any six minute period, divide the power density shown above by two when calculating the power density in your own household.  Also divide by two when calculating fields beyond your property if you never transmit more than 15 minutes in any 30 minute period.</p>

<p>2) If you wish to estimate the power density at a point below the main lobe of a directional antenna, and if the antenna's vertical pattern is known, recalculate using the antenna's gain in the relevant direction.</p>
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
