#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> RF Safety Compliance Calculator, rfsafety.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $form = "./rfsafety.cgi";

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>RF Safety Compliance Calculator</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<font face="Verdana, Arial, Helvetica">
<h2>RF Safety Compliance Calculator</h2>

<p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p>
</center>

<hr noshade>
<blockquote>
<p>This program uses the formulas given in FCC OET Bulletin No. 65 to estimate power density in the main lobe of an antenna, with use of the EPA recommended ground reflection factor as an option.</p>

<p>This program is intended for far-field calculations. It may overestimate the actual field strength of high gain antennas in the near-field (within several wavelengths of the antenna). However, it may also underestimate the strength of fields that may be encountered in &quot;hot spots&quot; in the near-field. No computer program can predict where wiring or reflective objects may create hot spots in your particular installation.</p>
</blockquote>

<form action="$form" method="post">
<table border="0">
<tr>
<td><b>Enter the average power at the antenna</b></td>
<td><input type="text" name="pwr" size="5" value=""></td>
<td><select name="pwr_val">
<option selected>Watts</option>
<option>dBm</option>
</select></td>
</tr>

<tr>
<td><b>Enter the antenna gain</b></td>
<td><input type="text" name="gain" size="5" value=""></td>
<td><select name="gain_val">
<option selected>dBi</option>
<option>dBd</option>
</select></td>
</tr>

<tr>
<td><b>Enter the distance to area of interest from antenna center</b></td>
<td><input type="text" name="dx" size="5" value=""></td>
<td><select name="dx_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td><b>Enter the frequency of operation</b></td>
<td><input type="text" name="frq" size="5" value=""></td>
<td><select name="frq_val">
<option selected>MHz</option>
<option>kHz</option>
<option>GHz</option>
</select></td>
</tr>

<tr>
<td><b>Do you wish to include the effects of ground reflections?</b></td>
<td><select name="gnd_val">
<option selected>Yes</option>
<option>No</option>
</select></td>
</tr>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">
</font>

<blockquote>
<p>Ground effects need not be included in most main beam calculations but including them may yield more accurate results with very low antennas, non-directional antennas, and calculations below the main lobe of directional antennas.</p>

<p>This program is based on a BASIC program written by N6NB.</p>
</blockquote>

</body>
</html>
EOF
