#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Stripline Analysis & Design, strip.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

$pic = "pics/strip.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $imp = $FORM{'imp'};

my $er = $FORM{'er'};

my $ht = $FORM{'ht'};
my $ht_val = $FORM{'ht_val'};

my $wid = $FORM{'wid'};
my $wid_val = $FORM{'wid_val'};

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

# Clean up user input data
#
$imp =~ tr/0-9.//csd;

$er =~ tr/0-9.//csd;

if (!$er) {
  $er = 4.8; # 4.8 dielectric constant
}

$ht =~ tr/0-9.//csd;
$ht_val =~ tr/a-z//csd;

if (!$ht) {
  $ht = 1.5; $ht_val = "millimeters"; # 1.5 mm substrate thickness
}

$wid =~ tr/0-9.//csd;
$wid_val =~ tr/a-z//csd;

if (!$wid) {
  $wid = 2.8; $wid_val = "millimeters"; # 2.8 millimeters wide
}

$frq =~ tr/0-9.//csd;
$frq_val =~ tr/a-zA-Z//csd;

if (!$frq) {
  $frq = 2450; $frq_val = "MHz"; # 2450.0 MHz
}

# Substrate thickness
#
if ($ht_val eq "inches") {
  $ht = $ht * 25.4; # in to mm
}
elsif ($ht_val eq "mils") {
  $ht = $ht * 0.0254; # mils to mm
}

# Width
#
if ($wid_val eq "inches") {
  $wid = $wid * 25.4; # in to mm
}
elsif ($wid_val eq "mils") {
  $wid = $wid * 0.0254; # mils to mm
}

# Frequncy
#
if ($frq_val eq "GHz") {
  $frq = $frq * 1000;
}

# Start calculations
#
if ($imp) {
  $Z = $imp;
  $wid = $ht * (((120 * pi) / ($imp * (sqrt ($er + (sqrt $er))))) - 1);
}

# Velocity factor
#
$vf = 1 / sqrt (1 + (($er - 1) * (0.5 + (0.5 / sqrt (1 + ((10 * $ht) / $wid))))));

# Velocity of propagation
#
$vp = 1 / sqrt $er;

# Wavelength (mm)
#
$lamda = 10 * ($vf * (29980 / $frq));

# Effective dielectric constant
#
$ee = (($er + 1) / 2) + ((($er - 1) / 2) * (1 / sqrt (1 + (12 * ($ht / $wid)))));

if (!$Z) {
  if (($wid / $ht) <= 1) {
    $Z = (60 / (sqrt $ee)) * (log (((8 * $ht) / $wid) + ($wid / (4 * $ht))));
  }
  else {
    $Z = 120 * pi / (((($wid / $ht) + 1.393) + (0.667 * (log(($wid / $ht) + 1.444)))) * sqrt $ee);
  }
}

# Make all pretty
#
$Z = sprintf "%.3f", $Z;

$er = sprintf "%.3f", $er;
$ee = sprintf "%.3f", $ee;

$ht_mil = sprintf "%.3f", $ht / 0.0254;
$ht_in = sprintf "%.3f", $ht / 25.4;
$ht = sprintf "%.3f", $ht;

$wid_mil = sprintf "%.3f", $wid / 0.0254;
$wid_in = sprintf "%.3f", $wid / 25.4;
$wid = sprintf "%.3f", $wid;

$quarter_mil = sprintf "%.3f", ($lamda / 0.0254) / 4;
$quarter_in = sprintf "%.3f", ($lamda / 25.4) / 4;
$quarter = sprintf "%.3f", $lamda / 4;

$lamda_mil = sprintf "%.3f", $lamda / 0.0254;
$lamda_in = sprintf "%.3f", $lamda / 25.4;
$lamda = sprintf "%.3f", $lamda;

$vp = sprintf "%.3f", $vp;
$vf = sprintf "%.3f", $vf;

$frq = sprintf "%.3f", $frq;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Stripline Analysis &amp; Design Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Stripline Analysis &amp; Design Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[stripline]"></center>
<hr noshade>

<pre>
          $b Operating frequency : $e$frq$b MHz $e
          $b Dielectric constant : $e$er
$b Effective dielectric constant : $e$ee
          $b Substrate thickness : $e$ht$b mm ($e$ht_in$b inches / $e$ht_mil$b mils) $e
<br>
          $p Stripline impedance : $e$Z$p ohms $e
     $p Stripline physical width : $e$wid$p mm ($e$wid_in$p inches / $e$wid_mil$p mils) $e
              $p Velocity factor : $e$vf
      $p Velocity of propagation : $e$vp
        $p One wavelength (360&deg;) : $e$lamda$p mm ($e$lamda_in$p inches / $e$lamda_mil$p mils) $e
     $p Quarter wavelength (90&deg;) : $e$quarter$p mm ($e$quarter_in$p inches / $e$quarter_mil$p mils) $e
</pre>

<hr noshade size="5">

<blockquote>
<p>To convert a length to electrical degrees or vice versa, just cross muliply.</p>

<p>
Examples:
<pre>

	  360&deg;       x
	------- = ------
	64.0 mm   1.6 mm    x = 9&deg;
or<br>

          360&deg;      9&deg;
	------- = -----
        64.0 mm     x       x = 1.6 mm
</pre>
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
