#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Stripline Analysis & Design, strip.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL
## NO WARRANTY. Please send bug reports / patches / reports.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $pic = "pics/strip.png";
my $form = "./strip.cgi";
my $er = 4.8; # dielectric constant

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Stripline Analysis &amp; Design</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<font face="Verdana, Arial, Helvetica">
<h2>Stripline Analysis &amp; Design</h2>

<p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p>
</center>

<hr noshade>
<center><img src="$pic" alt="[stripline]"></center>

<hr noshade>
<form action="$form" method="post">
<table border="0">
<tr>
<td><b>Enter the dielectric constant of the board material</b></td>
<td><input type="text" name="er" size="5" value="$er"></td>
</tr>

<tr>
<td><b>Enter the substrate thickness</b></td>
<td><input type="text" name="ht" size="5" value=""></td>
<td><select name="ht_val">
<option selected>millimeters</option>
<option>inches</option>
<option>mils</option>
</select></td>
</tr>

<tr>
<td><b>Enter the operating frequency</b></td>
<td><input type="text" name="frq" size="5" value=""></td>
<td><select name="frq_val">
<option selected>MHz</option>
<option>GHz</option>
</select></td>
</tr>

<tr>
<td><b>Enter the stripline's width</b></td>
<td><input type="text" name="wid" size="5" value=""></td>
<td><select name="wid_val">
<option selected>millimeters</option>
<option>inches</option>
<option>mils</option>
</select></td>
</tr>

<tr>
<td><b><em>OR</em> enter the impedance required</b></td>
<td><input type="text" name="imp" size="5" value=""></td>
<td>Ohms</td>
</tr>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">
</font>

<blockquote>
<ul>
<li>Fiberglass-epoxy type boards (G-10/FR-4) have a dielectric constant of around 4.2 to 4.8</li>

<li>Teflon boards have a dielectric constant of around 2.55</li>

<li>The dielectric constant varies with board manufacture and frequency, that's why it's called a <u>constant</u>.</li>

<li>One ounce weight corresponds to a copper thickness of 0.0014 inches (0.04 mm)</li>

<li>Two ounce weight corresponds to a copper thickness of 0.0028 inches (0.08 mm)</li>

<li>Common 1/16 inch board has a substrate thickness of 0.059 inches (1.5 mm)</li>

<li>Common 1/32 inch board has a substrate thickness of 0.028 inches (0.71 mm)</li>

</ul>
</blockquote>

</body>
</html>
EOF
