#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Fresnel Zone Boundary Calculator, fresnel.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $pic = "pics/fresnel.png";
my $form = "./fresnel.cgi";
my $freq = 2450; # 2450 MHz

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Fresnel Zone Boundary Calculator</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<font face="Verdana, Arial, Helvetica">
<center>
<h2>Fresnel Zone Boundary Calculator</h2>

<p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p>
</center>

<hr noshade>
<center><img src="$pic" alt="[fresnel zone]"></center>

<hr noshade>
<form action="$form" method="post">
<table border="0">
<tr>
<td><b>Enter the operating frequency</b>
<td><input type="text" name="frq" size="7" value="$freq">
<td><select name="frq_val">
<option selected>MHz</option>
<option>GHz</option>
</select></td>
</tr>

<tr>
<td><b>Enter the distance from site A to the obstruction</b>
<td><input type="text" name="a_dis" size="7" value="">
<td><select name="a_dis_val">
<option selected>kilometers</option>
<option>meters</option>
<option>miles</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td><b>Enter the distance from site B to the obstruction</b>
<td><input type="text" name="b_dis" size="7" value="">
<td><select name="b_dis_val">
<option selected>kilometers</option>
<option>meters</option>
<option>miles</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td><b>N <sub>th</sub> Fresnel zone to calculate</b>
<td><select name="nth">
<option>0.3</option>
<option>0.4</option>
<option>0.5</option>
<option>0.7</option>
<option>0.8</option>
<option>0.9</option>
<option selected>1</option>
<option>2</option>
<option>3</option>
<option>4</option>
<option>5</option>
<option>6</option>
<option>7</option>
<option>8</option>
<option>9</option>
</select></td>
</tr>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">
</font>

<blockquote>
<p>The site A and site B distances should add up to the total path distance.</p>

<p><a href="http://www.solectek.com/tech-center/tt-howhard.html">Visit</a> this Solectek site for a good paper on Fresnel zones and radio line-of-sight.</p>
</blockquote>

</body>
</html>
EOF
