#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Knife Edge Diffraction Loss Calculator, knife.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $pic = "pics/knife_edge.png";
my $form = "./knife.cgi";
my $freq = 2450;

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Knife Edge Diffraction Loss Calculator</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<font face="Verdana, Arial, Helvetica">
<center>
<h2>Knife Edge Diffraction Loss Calculator</h2>

<p><font size="-1">A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</font></p>
</center>

<hr noshade>
<center><img src="$pic" alt="[knife edge]"></center>

<hr noshade>
<form action="$form" method="post">
<table border="0">
<tr>
<td align="left"><b>Enter the operating frequency</b></td>
<td align="right"><input type="text" name="frq" size="7" value="$freq"></td>
<td align="right"><select name="frq_val">
<option selected>MHz</option>
<option>GHz</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Enter the distance from site A to the obstruction</b></td>
<td align="right"><input type="text" name="a_dis" size="7" value=""></td>
<td align="right"><select name="a_dis_val">
<option selected>kilometers</option>
<option>miles</option>
</select></td>
</tr>

<tr>
<td align="left"><b>Enter the height of the obstruction</b></td>
<td align="right"><input type="text" name="height" size="7" value=""></td>
<td align="right"><select name="height_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>
</table>

<hr noshade>
<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">
</font>

<blockquote>
<p>Elevation of the knife edge is relative to the two antennas</p>
</blockquote>

</body>
</html>
EOF
