#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Scattering Parameters Are Fun!, sparm.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $S11_mag = $FORM{'S11_mag'};
my $S11_ang = $FORM{'S11_ang'};

my $S12_mag = $FORM{'S12_mag'};
my $S12_ang = $FORM{'S12_ang'};

my $S21_mag = $FORM{'S21_mag'};
my $S21_ang = $FORM{'S21_ang'};

my $S22_mag = $FORM{'S22_mag'};
my $S22_ang = $FORM{'S22_ang'};

# Clean up user input data
#
$S11_mag =~ tr/0-9.-//csd;
$S11_ang =~ tr/0-9.-//csd;

$S12_mag =~ tr/0-9.-//csd;
$S12_ang =~ tr/0-9.-//csd;

$S21_mag =~ tr/0-9.-//csd;
$S21_ang =~ tr/0-9.-//csd;

$S22_mag =~ tr/0-9.-//csd;
$S22_ang =~ tr/0-9.-//csd;

# Start calculations
#

# Maximum Stable Gain
#
$MSG = 10 * log10($S21_mag / $S12_mag);

# Transducer Unilatral Gain
#
$GTU = 10 * log10($S21_mag ** 2);

# D
#
$a = $S11_mag * $S22_mag;
$b = $S11_ang + $S22_ang;
$c = $S12_mag * $S21_mag;
$d = $S12_ang + $S21_ang;

$xt = ($a * cos($b * (pi / 180))) - ($c * cos($d * (pi / 180)));
$yt = ($a * sin($b * (pi / 180))) - ($c * sin($d * (pi / 180)));

$R = sqrt(($xt ** 2) + ($yt ** 2));
$R_theta = (atan2($yt, $xt)) * (180 / pi);

# K
#
$K = (1 + ($R ** 2) - ($S11_mag ** 2) - ($S22_mag ** 2)) / (2 * $S12_mag * $S21_mag);

if ($K > 1) {
  $K_msg = "Uncondtionally stable";
}
else {
  $K_msg = "Unstable";
}

# B1
#
$B1 = 1 + ($S11_mag ** 2) - ($S22_mag ** 2) - ($R ** 2);

if ($B1 > 0) {
  $pos = 1;
}
else {
  $pos = 0;
}

# Maximum Available Gain
#
if ($pos == 1) {
  $MAG = $MSG + (10 * log10($K - sqrt(($K ** 2) - 1)));
} 

if (!$pos) {
  $MAG = $MSG + (10 * log10($K + sqrt(($K ** 2) - 1)));
} 

# C1
#
$a = $R * $S22_mag;
$b = $R_theta + ($S22_ang * -1);

$xt = ($S11_mag * cos($S11_ang * (pi / 180))) - ($a * cos($b * (pi / 180)));
$yt = ($S11_mag * sin($S11_ang * (pi / 180))) - ($a * sin($b * (pi / 180)));

$R1 = sqrt(($xt ** 2) + ($yt ** 2));
$R1_theta = (atan2($yt, $xt)) * (180 / pi);

# Gamma in
#
if ($pos == 1) {
  $gamma_in = ($B1 - sqrt(($B1 ** 2) - (4 * ($R1 ** 2)))) / (2 * $R1);
}

if (!$pos) {
  $gamma_in = ($B1 + sqrt(($B1 ** 2) - (4 * ($R1 ** 2)))) / (2 * $R1)
}

# B2
#
$B2 = 1 + ($S22_mag ** 2) - ($S11_mag ** 2) - ($R ** 2);

# C2
#
$a = $R * $S11_mag;
$b = $R_theta + ($S11_ang * -1);

$xt = ($S22_mag * cos($S22_ang * (pi / 180))) - ($a * cos($b * (pi / 180)));
$yt = ($S22_mag * sin($S22_ang * (pi / 180))) - ($a * sin($b * (pi / 180)));

$R2 = sqrt(($xt ** 2) + ($yt ** 2));
$R2_theta = (atan2($yt, $xt)) * (180 / pi);

# Gamma out
#
if ($B2 > 0) {
  $pos = 1;
}
else {
  $pos = 0;
}

if ($pos == 1) {
  $gamma_out = ($B2 - sqrt(($B2 ** 2) - (4 * ($R2 ** 2)))) / (2 * $R2);
}

if (!$pos) {
  $gamma_out = ($B2 + sqrt(($B2 ** 2) - (4 * ($R2 ** 2)))) / (2 * $R2)
}

# Make all pretty
#
$GTU = sprintf "%.3f", $GTU;
$MSG = sprintf "%.3f", $MSG;
$R = sprintf "%.3f", $R;
$R_theta = sprintf "%.3f", $R_theta;
$R1 = sprintf "%.3f", $R1;
$R1_theta = sprintf "%.3f", $R1_theta;
$R2 = sprintf "%.3f", $R2;
$R2_theta = sprintf "%.3f", $R2_theta;
$K = sprintf "%.3f", $K;
$B1 = sprintf "%.3f", $B1;
$MAG = sprintf "%.3f", $MAG;
$B2 = sprintf "%.3f", $B2;

$gamma_in = sprintf "%.3f", $gamma_in;
$gamma_out = sprintf "%.3f", $gamma_out;

$date = scalar gmtime;

# Draw me a web page
#
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Scattering Parameters Are Fun! Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h3>Scattering Parameters Are Fun! Results</h3>
</center>

<hr noshade>
<pre>
       $p Maximum Stable Gain (MSG) : $e$MSG$p dB $e
    $p Maximum Available Gain (MAG) : $e$MAG$p dB $e
$p Transducer Unilateral Gain (G<sub>TU</sub>) : $e$GTU$p dB $e
<br>
$p Rollett Stability Factor (K) : $e$K$p ($e$K_msg$p) $e
                          $p B<sub>1</sub> : $e$B1
                          $p B<sub>2</sub> : $e$B2
                           $p D : $e$R$p <em>theta</em> $e$R_theta$p degrees $e
                          $p C<sub>1</sub> : $e$R1$p <em>theta</em> $e$R1_theta$p degrees $e
                          $p C<sub>2</sub> : $e$R2$p <em>theta</em> $e$R2_theta$p degrees $e
<br>
                 $p Gamma Input : $e$gamma_in$p <em>theta</em> $e$R1_theta$p degrees $e
                $p Gamma Output : $e$gamma_out$p <em>theta</em> $e$R2_theta$p degrees $e
</pre>

<hr noshade size="5">

<blockquote>
<p><b><u>Notes</u></b></p>

<ul>
<li>Transistor input and output reflection coefficients can be transformed into transistor input and output impedances using a Smith chart.</li>

<li>Maximum Stable Gain (MSG) should be at least 10 dB.</li>

<li>The stability factor (K) must be greater than one for the device to be unconditionally stable.</li>
</ul>
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>
</body>
</html>
EOF
